<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for IncomingPaymentInstructionResult StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:IncomingPaymentInstructionResult
 * @subpackage Structs
 */
class IncomingPaymentInstructionResult extends AbstractStructBase
{
    /**
     * The AccountAddress
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AccountAddress;
    /**
     * The AccountName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AccountName;
    /**
     * The AccountNo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AccountNo;
    /**
     * The BankAddress
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $BankAddress;
    /**
     * The BankName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $BankName;
    /**
     * The CurrencyCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CurrencyCode;
    /**
     * The ErrorCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ErrorCode;
    /**
     * The ErrorMessage
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ErrorMessage;
    /**
     * The Reference
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Reference;
    /**
     * The RoutingTransit
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RoutingTransit;
    /**
     * The SwiftCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SwiftCode;
    /**
     * Constructor method for IncomingPaymentInstructionResult
     * @uses IncomingPaymentInstructionResult::setAccountAddress()
     * @uses IncomingPaymentInstructionResult::setAccountName()
     * @uses IncomingPaymentInstructionResult::setAccountNo()
     * @uses IncomingPaymentInstructionResult::setBankAddress()
     * @uses IncomingPaymentInstructionResult::setBankName()
     * @uses IncomingPaymentInstructionResult::setCurrencyCode()
     * @uses IncomingPaymentInstructionResult::setErrorCode()
     * @uses IncomingPaymentInstructionResult::setErrorMessage()
     * @uses IncomingPaymentInstructionResult::setReference()
     * @uses IncomingPaymentInstructionResult::setRoutingTransit()
     * @uses IncomingPaymentInstructionResult::setSwiftCode()
     * @param string $accountAddress
     * @param string $accountName
     * @param string $accountNo
     * @param string $bankAddress
     * @param string $bankName
     * @param string $currencyCode
     * @param int $errorCode
     * @param string $errorMessage
     * @param string $reference
     * @param string $routingTransit
     * @param string $swiftCode
     */
    public function __construct($accountAddress = null, $accountName = null, $accountNo = null, $bankAddress = null, $bankName = null, $currencyCode = null, $errorCode = null, $errorMessage = null, $reference = null, $routingTransit = null, $swiftCode = null)
    {
        $this
            ->setAccountAddress($accountAddress)
            ->setAccountName($accountName)
            ->setAccountNo($accountNo)
            ->setBankAddress($bankAddress)
            ->setBankName($bankName)
            ->setCurrencyCode($currencyCode)
            ->setErrorCode($errorCode)
            ->setErrorMessage($errorMessage)
            ->setReference($reference)
            ->setRoutingTransit($routingTransit)
            ->setSwiftCode($swiftCode);
    }
    /**
     * Get AccountAddress value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAccountAddress()
    {
        return isset($this->AccountAddress) ? $this->AccountAddress : null;
    }
    /**
     * Set AccountAddress value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $accountAddress
     * @return \StructType\IncomingPaymentInstructionResult
     */
    public function setAccountAddress($accountAddress = null)
    {
        // validation for constraint: string
        if (!is_null($accountAddress) && !is_string($accountAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accountAddress, true), gettype($accountAddress)), __LINE__);
        }
        if (is_null($accountAddress) || (is_array($accountAddress) && empty($accountAddress))) {
            unset($this->AccountAddress);
        } else {
            $this->AccountAddress = $accountAddress;
        }
        return $this;
    }
    /**
     * Get AccountName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAccountName()
    {
        return isset($this->AccountName) ? $this->AccountName : null;
    }
    /**
     * Set AccountName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $accountName
     * @return \StructType\IncomingPaymentInstructionResult
     */
    public function setAccountName($accountName = null)
    {
        // validation for constraint: string
        if (!is_null($accountName) && !is_string($accountName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accountName, true), gettype($accountName)), __LINE__);
        }
        if (is_null($accountName) || (is_array($accountName) && empty($accountName))) {
            unset($this->AccountName);
        } else {
            $this->AccountName = $accountName;
        }
        return $this;
    }
    /**
     * Get AccountNo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAccountNo()
    {
        return isset($this->AccountNo) ? $this->AccountNo : null;
    }
    /**
     * Set AccountNo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $accountNo
     * @return \StructType\IncomingPaymentInstructionResult
     */
    public function setAccountNo($accountNo = null)
    {
        // validation for constraint: string
        if (!is_null($accountNo) && !is_string($accountNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accountNo, true), gettype($accountNo)), __LINE__);
        }
        if (is_null($accountNo) || (is_array($accountNo) && empty($accountNo))) {
            unset($this->AccountNo);
        } else {
            $this->AccountNo = $accountNo;
        }
        return $this;
    }
    /**
     * Get BankAddress value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBankAddress()
    {
        return isset($this->BankAddress) ? $this->BankAddress : null;
    }
    /**
     * Set BankAddress value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bankAddress
     * @return \StructType\IncomingPaymentInstructionResult
     */
    public function setBankAddress($bankAddress = null)
    {
        // validation for constraint: string
        if (!is_null($bankAddress) && !is_string($bankAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bankAddress, true), gettype($bankAddress)), __LINE__);
        }
        if (is_null($bankAddress) || (is_array($bankAddress) && empty($bankAddress))) {
            unset($this->BankAddress);
        } else {
            $this->BankAddress = $bankAddress;
        }
        return $this;
    }
    /**
     * Get BankName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBankName()
    {
        return isset($this->BankName) ? $this->BankName : null;
    }
    /**
     * Set BankName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bankName
     * @return \StructType\IncomingPaymentInstructionResult
     */
    public function setBankName($bankName = null)
    {
        // validation for constraint: string
        if (!is_null($bankName) && !is_string($bankName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bankName, true), gettype($bankName)), __LINE__);
        }
        if (is_null($bankName) || (is_array($bankName) && empty($bankName))) {
            unset($this->BankName);
        } else {
            $this->BankName = $bankName;
        }
        return $this;
    }
    /**
     * Get CurrencyCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCurrencyCode()
    {
        return isset($this->CurrencyCode) ? $this->CurrencyCode : null;
    }
    /**
     * Set CurrencyCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $currencyCode
     * @return \StructType\IncomingPaymentInstructionResult
     */
    public function setCurrencyCode($currencyCode = null)
    {
        // validation for constraint: string
        if (!is_null($currencyCode) && !is_string($currencyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currencyCode, true), gettype($currencyCode)), __LINE__);
        }
        if (is_null($currencyCode) || (is_array($currencyCode) && empty($currencyCode))) {
            unset($this->CurrencyCode);
        } else {
            $this->CurrencyCode = $currencyCode;
        }
        return $this;
    }
    /**
     * Get ErrorCode value
     * @return int|null
     */
    public function getErrorCode()
    {
        return $this->ErrorCode;
    }
    /**
     * Set ErrorCode value
     * @param int $errorCode
     * @return \StructType\IncomingPaymentInstructionResult
     */
    public function setErrorCode($errorCode = null)
    {
        // validation for constraint: int
        if (!is_null($errorCode) && !(is_int($errorCode) || ctype_digit($errorCode))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($errorCode, true), gettype($errorCode)), __LINE__);
        }
        $this->ErrorCode = $errorCode;
        return $this;
    }
    /**
     * Get ErrorMessage value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getErrorMessage()
    {
        return isset($this->ErrorMessage) ? $this->ErrorMessage : null;
    }
    /**
     * Set ErrorMessage value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $errorMessage
     * @return \StructType\IncomingPaymentInstructionResult
     */
    public function setErrorMessage($errorMessage = null)
    {
        // validation for constraint: string
        if (!is_null($errorMessage) && !is_string($errorMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($errorMessage, true), gettype($errorMessage)), __LINE__);
        }
        if (is_null($errorMessage) || (is_array($errorMessage) && empty($errorMessage))) {
            unset($this->ErrorMessage);
        } else {
            $this->ErrorMessage = $errorMessage;
        }
        return $this;
    }
    /**
     * Get Reference value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getReference()
    {
        return isset($this->Reference) ? $this->Reference : null;
    }
    /**
     * Set Reference value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $reference
     * @return \StructType\IncomingPaymentInstructionResult
     */
    public function setReference($reference = null)
    {
        // validation for constraint: string
        if (!is_null($reference) && !is_string($reference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reference, true), gettype($reference)), __LINE__);
        }
        if (is_null($reference) || (is_array($reference) && empty($reference))) {
            unset($this->Reference);
        } else {
            $this->Reference = $reference;
        }
        return $this;
    }
    /**
     * Get RoutingTransit value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRoutingTransit()
    {
        return isset($this->RoutingTransit) ? $this->RoutingTransit : null;
    }
    /**
     * Set RoutingTransit value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $routingTransit
     * @return \StructType\IncomingPaymentInstructionResult
     */
    public function setRoutingTransit($routingTransit = null)
    {
        // validation for constraint: string
        if (!is_null($routingTransit) && !is_string($routingTransit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($routingTransit, true), gettype($routingTransit)), __LINE__);
        }
        if (is_null($routingTransit) || (is_array($routingTransit) && empty($routingTransit))) {
            unset($this->RoutingTransit);
        } else {
            $this->RoutingTransit = $routingTransit;
        }
        return $this;
    }
    /**
     * Get SwiftCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSwiftCode()
    {
        return isset($this->SwiftCode) ? $this->SwiftCode : null;
    }
    /**
     * Set SwiftCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $swiftCode
     * @return \StructType\IncomingPaymentInstructionResult
     */
    public function setSwiftCode($swiftCode = null)
    {
        // validation for constraint: string
        if (!is_null($swiftCode) && !is_string($swiftCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($swiftCode, true), gettype($swiftCode)), __LINE__);
        }
        if (is_null($swiftCode) || (is_array($swiftCode) && empty($swiftCode))) {
            unset($this->SwiftCode);
        } else {
            $this->SwiftCode = $swiftCode;
        }
        return $this;
    }
}
