<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetQuoteTBAResult StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:GetQuoteTBAResult
 * @subpackage Structs
 */
class GetQuoteTBAResult extends AbstractStructBase
{
    /**
     * The ErrorCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ErrorCode;
    /**
     * The ErrorMessage
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ErrorMessage;
    /**
     * The Fee
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $Fee;
    /**
     * The FromAccountNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FromAccountNumber;
    /**
     * The FxAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $FxAmount;
    /**
     * The FxCurrencyID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FxCurrencyID;
    /**
     * The PaymentMethod
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PaymentMethod;
    /**
     * The Quote
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Quote
     */
    public $Quote;
    /**
     * The Rate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $Rate;
    /**
     * The SettlementAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $SettlementAmount;
    /**
     * The SettlementCurrencyID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SettlementCurrencyID;
    /**
     * The ToAccountNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ToAccountNumber;
    /**
     * The TotalSettlementAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $TotalSettlementAmount;
    /**
     * Constructor method for GetQuoteTBAResult
     * @uses GetQuoteTBAResult::setErrorCode()
     * @uses GetQuoteTBAResult::setErrorMessage()
     * @uses GetQuoteTBAResult::setFee()
     * @uses GetQuoteTBAResult::setFromAccountNumber()
     * @uses GetQuoteTBAResult::setFxAmount()
     * @uses GetQuoteTBAResult::setFxCurrencyID()
     * @uses GetQuoteTBAResult::setPaymentMethod()
     * @uses GetQuoteTBAResult::setQuote()
     * @uses GetQuoteTBAResult::setRate()
     * @uses GetQuoteTBAResult::setSettlementAmount()
     * @uses GetQuoteTBAResult::setSettlementCurrencyID()
     * @uses GetQuoteTBAResult::setToAccountNumber()
     * @uses GetQuoteTBAResult::setTotalSettlementAmount()
     * @param int $errorCode
     * @param string $errorMessage
     * @param float $fee
     * @param string $fromAccountNumber
     * @param float $fxAmount
     * @param string $fxCurrencyID
     * @param string $paymentMethod
     * @param \StructType\Quote $quote
     * @param float $rate
     * @param float $settlementAmount
     * @param string $settlementCurrencyID
     * @param string $toAccountNumber
     * @param float $totalSettlementAmount
     */
    public function __construct($errorCode = null, $errorMessage = null, $fee = null, $fromAccountNumber = null, $fxAmount = null, $fxCurrencyID = null, $paymentMethod = null, \StructType\Quote $quote = null, $rate = null, $settlementAmount = null, $settlementCurrencyID = null, $toAccountNumber = null, $totalSettlementAmount = null)
    {
        $this
            ->setErrorCode($errorCode)
            ->setErrorMessage($errorMessage)
            ->setFee($fee)
            ->setFromAccountNumber($fromAccountNumber)
            ->setFxAmount($fxAmount)
            ->setFxCurrencyID($fxCurrencyID)
            ->setPaymentMethod($paymentMethod)
            ->setQuote($quote)
            ->setRate($rate)
            ->setSettlementAmount($settlementAmount)
            ->setSettlementCurrencyID($settlementCurrencyID)
            ->setToAccountNumber($toAccountNumber)
            ->setTotalSettlementAmount($totalSettlementAmount);
    }
    /**
     * Get ErrorCode value
     * @return int|null
     */
    public function getErrorCode()
    {
        return $this->ErrorCode;
    }
    /**
     * Set ErrorCode value
     * @param int $errorCode
     * @return \StructType\GetQuoteTBAResult
     */
    public function setErrorCode($errorCode = null)
    {
        // validation for constraint: int
        if (!is_null($errorCode) && !(is_int($errorCode) || ctype_digit($errorCode))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($errorCode, true), gettype($errorCode)), __LINE__);
        }
        $this->ErrorCode = $errorCode;
        return $this;
    }
    /**
     * Get ErrorMessage value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getErrorMessage()
    {
        return isset($this->ErrorMessage) ? $this->ErrorMessage : null;
    }
    /**
     * Set ErrorMessage value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $errorMessage
     * @return \StructType\GetQuoteTBAResult
     */
    public function setErrorMessage($errorMessage = null)
    {
        // validation for constraint: string
        if (!is_null($errorMessage) && !is_string($errorMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($errorMessage, true), gettype($errorMessage)), __LINE__);
        }
        if (is_null($errorMessage) || (is_array($errorMessage) && empty($errorMessage))) {
            unset($this->ErrorMessage);
        } else {
            $this->ErrorMessage = $errorMessage;
        }
        return $this;
    }
    /**
     * Get Fee value
     * @return float|null
     */
    public function getFee()
    {
        return $this->Fee;
    }
    /**
     * Set Fee value
     * @param float $fee
     * @return \StructType\GetQuoteTBAResult
     */
    public function setFee($fee = null)
    {
        // validation for constraint: float
        if (!is_null($fee) && !(is_float($fee) || is_numeric($fee))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($fee, true), gettype($fee)), __LINE__);
        }
        $this->Fee = $fee;
        return $this;
    }
    /**
     * Get FromAccountNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFromAccountNumber()
    {
        return isset($this->FromAccountNumber) ? $this->FromAccountNumber : null;
    }
    /**
     * Set FromAccountNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $fromAccountNumber
     * @return \StructType\GetQuoteTBAResult
     */
    public function setFromAccountNumber($fromAccountNumber = null)
    {
        // validation for constraint: string
        if (!is_null($fromAccountNumber) && !is_string($fromAccountNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fromAccountNumber, true), gettype($fromAccountNumber)), __LINE__);
        }
        if (is_null($fromAccountNumber) || (is_array($fromAccountNumber) && empty($fromAccountNumber))) {
            unset($this->FromAccountNumber);
        } else {
            $this->FromAccountNumber = $fromAccountNumber;
        }
        return $this;
    }
    /**
     * Get FxAmount value
     * @return float|null
     */
    public function getFxAmount()
    {
        return $this->FxAmount;
    }
    /**
     * Set FxAmount value
     * @param float $fxAmount
     * @return \StructType\GetQuoteTBAResult
     */
    public function setFxAmount($fxAmount = null)
    {
        // validation for constraint: float
        if (!is_null($fxAmount) && !(is_float($fxAmount) || is_numeric($fxAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($fxAmount, true), gettype($fxAmount)), __LINE__);
        }
        $this->FxAmount = $fxAmount;
        return $this;
    }
    /**
     * Get FxCurrencyID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFxCurrencyID()
    {
        return isset($this->FxCurrencyID) ? $this->FxCurrencyID : null;
    }
    /**
     * Set FxCurrencyID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $fxCurrencyID
     * @return \StructType\GetQuoteTBAResult
     */
    public function setFxCurrencyID($fxCurrencyID = null)
    {
        // validation for constraint: string
        if (!is_null($fxCurrencyID) && !is_string($fxCurrencyID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fxCurrencyID, true), gettype($fxCurrencyID)), __LINE__);
        }
        if (is_null($fxCurrencyID) || (is_array($fxCurrencyID) && empty($fxCurrencyID))) {
            unset($this->FxCurrencyID);
        } else {
            $this->FxCurrencyID = $fxCurrencyID;
        }
        return $this;
    }
    /**
     * Get PaymentMethod value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPaymentMethod()
    {
        return isset($this->PaymentMethod) ? $this->PaymentMethod : null;
    }
    /**
     * Set PaymentMethod value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $paymentMethod
     * @return \StructType\GetQuoteTBAResult
     */
    public function setPaymentMethod($paymentMethod = null)
    {
        // validation for constraint: string
        if (!is_null($paymentMethod) && !is_string($paymentMethod)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentMethod, true), gettype($paymentMethod)), __LINE__);
        }
        if (is_null($paymentMethod) || (is_array($paymentMethod) && empty($paymentMethod))) {
            unset($this->PaymentMethod);
        } else {
            $this->PaymentMethod = $paymentMethod;
        }
        return $this;
    }
    /**
     * Get Quote value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Quote|null
     */
    public function getQuote()
    {
        return isset($this->Quote) ? $this->Quote : null;
    }
    /**
     * Set Quote value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Quote $quote
     * @return \StructType\GetQuoteTBAResult
     */
    public function setQuote(\StructType\Quote $quote = null)
    {
        if (is_null($quote) || (is_array($quote) && empty($quote))) {
            unset($this->Quote);
        } else {
            $this->Quote = $quote;
        }
        return $this;
    }
    /**
     * Get Rate value
     * @return float|null
     */
    public function getRate()
    {
        return $this->Rate;
    }
    /**
     * Set Rate value
     * @param float $rate
     * @return \StructType\GetQuoteTBAResult
     */
    public function setRate($rate = null)
    {
        // validation for constraint: float
        if (!is_null($rate) && !(is_float($rate) || is_numeric($rate))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($rate, true), gettype($rate)), __LINE__);
        }
        $this->Rate = $rate;
        return $this;
    }
    /**
     * Get SettlementAmount value
     * @return float|null
     */
    public function getSettlementAmount()
    {
        return $this->SettlementAmount;
    }
    /**
     * Set SettlementAmount value
     * @param float $settlementAmount
     * @return \StructType\GetQuoteTBAResult
     */
    public function setSettlementAmount($settlementAmount = null)
    {
        // validation for constraint: float
        if (!is_null($settlementAmount) && !(is_float($settlementAmount) || is_numeric($settlementAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($settlementAmount, true), gettype($settlementAmount)), __LINE__);
        }
        $this->SettlementAmount = $settlementAmount;
        return $this;
    }
    /**
     * Get SettlementCurrencyID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSettlementCurrencyID()
    {
        return isset($this->SettlementCurrencyID) ? $this->SettlementCurrencyID : null;
    }
    /**
     * Set SettlementCurrencyID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $settlementCurrencyID
     * @return \StructType\GetQuoteTBAResult
     */
    public function setSettlementCurrencyID($settlementCurrencyID = null)
    {
        // validation for constraint: string
        if (!is_null($settlementCurrencyID) && !is_string($settlementCurrencyID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($settlementCurrencyID, true), gettype($settlementCurrencyID)), __LINE__);
        }
        if (is_null($settlementCurrencyID) || (is_array($settlementCurrencyID) && empty($settlementCurrencyID))) {
            unset($this->SettlementCurrencyID);
        } else {
            $this->SettlementCurrencyID = $settlementCurrencyID;
        }
        return $this;
    }
    /**
     * Get ToAccountNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getToAccountNumber()
    {
        return isset($this->ToAccountNumber) ? $this->ToAccountNumber : null;
    }
    /**
     * Set ToAccountNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $toAccountNumber
     * @return \StructType\GetQuoteTBAResult
     */
    public function setToAccountNumber($toAccountNumber = null)
    {
        // validation for constraint: string
        if (!is_null($toAccountNumber) && !is_string($toAccountNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($toAccountNumber, true), gettype($toAccountNumber)), __LINE__);
        }
        if (is_null($toAccountNumber) || (is_array($toAccountNumber) && empty($toAccountNumber))) {
            unset($this->ToAccountNumber);
        } else {
            $this->ToAccountNumber = $toAccountNumber;
        }
        return $this;
    }
    /**
     * Get TotalSettlementAmount value
     * @return float|null
     */
    public function getTotalSettlementAmount()
    {
        return $this->TotalSettlementAmount;
    }
    /**
     * Set TotalSettlementAmount value
     * @param float $totalSettlementAmount
     * @return \StructType\GetQuoteTBAResult
     */
    public function setTotalSettlementAmount($totalSettlementAmount = null)
    {
        // validation for constraint: float
        if (!is_null($totalSettlementAmount) && !(is_float($totalSettlementAmount) || is_numeric($totalSettlementAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($totalSettlementAmount, true), gettype($totalSettlementAmount)), __LINE__);
        }
        $this->TotalSettlementAmount = $totalSettlementAmount;
        return $this;
    }
}
