<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetQuoteResult StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:GetQuoteResult
 * @subpackage Structs
 */
class GetQuoteResult extends AbstractStructBase
{
    /**
     * The ErrorCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ErrorCode;
    /**
     * The ErrorMessage
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ErrorMessage;
    /**
     * The Payment
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfDeal
     */
    public $Payment;
    /**
     * The Quote
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Quote
     */
    public $Quote;
    /**
     * The TotalNumberOfPayment
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $TotalNumberOfPayment;
    /**
     * Constructor method for GetQuoteResult
     * @uses GetQuoteResult::setErrorCode()
     * @uses GetQuoteResult::setErrorMessage()
     * @uses GetQuoteResult::setPayment()
     * @uses GetQuoteResult::setQuote()
     * @uses GetQuoteResult::setTotalNumberOfPayment()
     * @param int $errorCode
     * @param string $errorMessage
     * @param \ArrayType\ArrayOfDeal $payment
     * @param \StructType\Quote $quote
     * @param int $totalNumberOfPayment
     */
    public function __construct($errorCode = null, $errorMessage = null, \ArrayType\ArrayOfDeal $payment = null, \StructType\Quote $quote = null, $totalNumberOfPayment = null)
    {
        $this
            ->setErrorCode($errorCode)
            ->setErrorMessage($errorMessage)
            ->setPayment($payment)
            ->setQuote($quote)
            ->setTotalNumberOfPayment($totalNumberOfPayment);
    }
    /**
     * Get ErrorCode value
     * @return int|null
     */
    public function getErrorCode()
    {
        return $this->ErrorCode;
    }
    /**
     * Set ErrorCode value
     * @param int $errorCode
     * @return \StructType\GetQuoteResult
     */
    public function setErrorCode($errorCode = null)
    {
        // validation for constraint: int
        if (!is_null($errorCode) && !(is_int($errorCode) || ctype_digit($errorCode))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($errorCode, true), gettype($errorCode)), __LINE__);
        }
        $this->ErrorCode = $errorCode;
        return $this;
    }
    /**
     * Get ErrorMessage value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getErrorMessage()
    {
        return isset($this->ErrorMessage) ? $this->ErrorMessage : null;
    }
    /**
     * Set ErrorMessage value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $errorMessage
     * @return \StructType\GetQuoteResult
     */
    public function setErrorMessage($errorMessage = null)
    {
        // validation for constraint: string
        if (!is_null($errorMessage) && !is_string($errorMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($errorMessage, true), gettype($errorMessage)), __LINE__);
        }
        if (is_null($errorMessage) || (is_array($errorMessage) && empty($errorMessage))) {
            unset($this->ErrorMessage);
        } else {
            $this->ErrorMessage = $errorMessage;
        }
        return $this;
    }
    /**
     * Get Payment value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfDeal|null
     */
    public function getPayment()
    {
        return isset($this->Payment) ? $this->Payment : null;
    }
    /**
     * Set Payment value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfDeal $payment
     * @return \StructType\GetQuoteResult
     */
    public function setPayment(\ArrayType\ArrayOfDeal $payment = null)
    {
        if (is_null($payment) || (is_array($payment) && empty($payment))) {
            unset($this->Payment);
        } else {
            $this->Payment = $payment;
        }
        return $this;
    }
    /**
     * Get Quote value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Quote|null
     */
    public function getQuote()
    {
        return isset($this->Quote) ? $this->Quote : null;
    }
    /**
     * Set Quote value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Quote $quote
     * @return \StructType\GetQuoteResult
     */
    public function setQuote(\StructType\Quote $quote = null)
    {
        if (is_null($quote) || (is_array($quote) && empty($quote))) {
            unset($this->Quote);
        } else {
            $this->Quote = $quote;
        }
        return $this;
    }
    /**
     * Get TotalNumberOfPayment value
     * @return int|null
     */
    public function getTotalNumberOfPayment()
    {
        return $this->TotalNumberOfPayment;
    }
    /**
     * Set TotalNumberOfPayment value
     * @param int $totalNumberOfPayment
     * @return \StructType\GetQuoteResult
     */
    public function setTotalNumberOfPayment($totalNumberOfPayment = null)
    {
        // validation for constraint: int
        if (!is_null($totalNumberOfPayment) && !(is_int($totalNumberOfPayment) || ctype_digit($totalNumberOfPayment))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($totalNumberOfPayment, true), gettype($totalNumberOfPayment)), __LINE__);
        }
        $this->TotalNumberOfPayment = $totalNumberOfPayment;
        return $this;
    }
}
