<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetPayeeInfo_0_0_2Result StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:GetPayeeInfo_0_0_2Result
 * @subpackage Structs
 */
class GetPayeeInfo_0_0_2Result extends AbstractStructBase
{
    /**
     * The ErrorCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ErrorCode;
    /**
     * The ErrorMessage
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ErrorMessage;
    /**
     * The NumberOfPayees
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $NumberOfPayees;
    /**
     * The PayeeDetail
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfPayeeDetail_0_0_2
     */
    public $PayeeDetail;
    /**
     * Constructor method for GetPayeeInfo_0_0_2Result
     * @uses GetPayeeInfo_0_0_2Result::setErrorCode()
     * @uses GetPayeeInfo_0_0_2Result::setErrorMessage()
     * @uses GetPayeeInfo_0_0_2Result::setNumberOfPayees()
     * @uses GetPayeeInfo_0_0_2Result::setPayeeDetail()
     * @param int $errorCode
     * @param string $errorMessage
     * @param string $numberOfPayees
     * @param \ArrayType\ArrayOfPayeeDetail_0_0_2 $payeeDetail
     */
    public function __construct($errorCode = null, $errorMessage = null, $numberOfPayees = null, \ArrayType\ArrayOfPayeeDetail_0_0_2 $payeeDetail = null)
    {
        $this
            ->setErrorCode($errorCode)
            ->setErrorMessage($errorMessage)
            ->setNumberOfPayees($numberOfPayees)
            ->setPayeeDetail($payeeDetail);
    }
    /**
     * Get ErrorCode value
     * @return int|null
     */
    public function getErrorCode()
    {
        return $this->ErrorCode;
    }
    /**
     * Set ErrorCode value
     * @param int $errorCode
     * @return \StructType\GetPayeeInfo_0_0_2Result
     */
    public function setErrorCode($errorCode = null)
    {
        // validation for constraint: int
        if (!is_null($errorCode) && !(is_int($errorCode) || ctype_digit($errorCode))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($errorCode, true), gettype($errorCode)), __LINE__);
        }
        $this->ErrorCode = $errorCode;
        return $this;
    }
    /**
     * Get ErrorMessage value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getErrorMessage()
    {
        return isset($this->ErrorMessage) ? $this->ErrorMessage : null;
    }
    /**
     * Set ErrorMessage value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $errorMessage
     * @return \StructType\GetPayeeInfo_0_0_2Result
     */
    public function setErrorMessage($errorMessage = null)
    {
        // validation for constraint: string
        if (!is_null($errorMessage) && !is_string($errorMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($errorMessage, true), gettype($errorMessage)), __LINE__);
        }
        if (is_null($errorMessage) || (is_array($errorMessage) && empty($errorMessage))) {
            unset($this->ErrorMessage);
        } else {
            $this->ErrorMessage = $errorMessage;
        }
        return $this;
    }
    /**
     * Get NumberOfPayees value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNumberOfPayees()
    {
        return isset($this->NumberOfPayees) ? $this->NumberOfPayees : null;
    }
    /**
     * Set NumberOfPayees value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $numberOfPayees
     * @return \StructType\GetPayeeInfo_0_0_2Result
     */
    public function setNumberOfPayees($numberOfPayees = null)
    {
        // validation for constraint: string
        if (!is_null($numberOfPayees) && !is_string($numberOfPayees)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($numberOfPayees, true), gettype($numberOfPayees)), __LINE__);
        }
        if (is_null($numberOfPayees) || (is_array($numberOfPayees) && empty($numberOfPayees))) {
            unset($this->NumberOfPayees);
        } else {
            $this->NumberOfPayees = $numberOfPayees;
        }
        return $this;
    }
    /**
     * Get PayeeDetail value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfPayeeDetail_0_0_2|null
     */
    public function getPayeeDetail()
    {
        return isset($this->PayeeDetail) ? $this->PayeeDetail : null;
    }
    /**
     * Set PayeeDetail value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfPayeeDetail_0_0_2 $payeeDetail
     * @return \StructType\GetPayeeInfo_0_0_2Result
     */
    public function setPayeeDetail(\ArrayType\ArrayOfPayeeDetail_0_0_2 $payeeDetail = null)
    {
        if (is_null($payeeDetail) || (is_array($payeeDetail) && empty($payeeDetail))) {
            unset($this->PayeeDetail);
        } else {
            $this->PayeeDetail = $payeeDetail;
        }
        return $this;
    }
}
