<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Post ServiceType
 * @subpackage Services
 */
class Post extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named PostDeal
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\PostDeal $parameters
     * @return \StructType\PostDealResponse|bool
     */
    public function PostDeal(\StructType\PostDeal $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->PostDeal($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named PostDeal_0_0_1
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\PostDeal_0_0_1 $parameters
     * @return \StructType\PostDeal_0_0_1Response|bool
     */
    public function PostDeal_0_0_1(\StructType\PostDeal_0_0_1 $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->PostDeal_0_0_1($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named PostDeal_0_0_2
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\PostDeal_0_0_2 $parameters
     * @return \StructType\PostDeal_0_0_2Response|bool
     */
    public function PostDeal_0_0_2(\StructType\PostDeal_0_0_2 $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->PostDeal_0_0_2($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named PostDealConfirmation
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\PostDealConfirmation $parameters
     * @return \StructType\PostDealConfirmationResponse|bool
     */
    public function PostDealConfirmation(\StructType\PostDealConfirmation $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->PostDealConfirmation($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\PostDealConfirmationResponse|\StructType\PostDealResponse|\StructType\PostDeal_0_0_1Response|\StructType\PostDeal_0_0_2Response
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
