<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TransactionDetails_0_0_1 StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:TransactionDetails_0_0_1
 * @subpackage Structs
 */
class TransactionDetails_0_0_1 extends AbstractStructBase
{
    /**
     * The DealId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DealId;
    /**
     * The Deposit
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $Deposit;
    /**
     * The Narration
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Narration;
    /**
     * The TransactionDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TransactionDate;
    /**
     * The TransactionSequenceNo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $TransactionSequenceNo;
    /**
     * The TransactionType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TransactionType;
    /**
     * The Withdrawal
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $Withdrawal;
    /**
     * Constructor method for TransactionDetails_0_0_1
     * @uses TransactionDetails_0_0_1::setDealId()
     * @uses TransactionDetails_0_0_1::setDeposit()
     * @uses TransactionDetails_0_0_1::setNarration()
     * @uses TransactionDetails_0_0_1::setTransactionDate()
     * @uses TransactionDetails_0_0_1::setTransactionSequenceNo()
     * @uses TransactionDetails_0_0_1::setTransactionType()
     * @uses TransactionDetails_0_0_1::setWithdrawal()
     * @param string $dealId
     * @param float $deposit
     * @param string $narration
     * @param string $transactionDate
     * @param int $transactionSequenceNo
     * @param string $transactionType
     * @param float $withdrawal
     */
    public function __construct($dealId = null, $deposit = null, $narration = null, $transactionDate = null, $transactionSequenceNo = null, $transactionType = null, $withdrawal = null)
    {
        $this
            ->setDealId($dealId)
            ->setDeposit($deposit)
            ->setNarration($narration)
            ->setTransactionDate($transactionDate)
            ->setTransactionSequenceNo($transactionSequenceNo)
            ->setTransactionType($transactionType)
            ->setWithdrawal($withdrawal);
    }
    /**
     * Get DealId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDealId()
    {
        return isset($this->DealId) ? $this->DealId : null;
    }
    /**
     * Set DealId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dealId
     * @return \StructType\TransactionDetails_0_0_1
     */
    public function setDealId($dealId = null)
    {
        // validation for constraint: string
        if (!is_null($dealId) && !is_string($dealId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dealId, true), gettype($dealId)), __LINE__);
        }
        if (is_null($dealId) || (is_array($dealId) && empty($dealId))) {
            unset($this->DealId);
        } else {
            $this->DealId = $dealId;
        }
        return $this;
    }
    /**
     * Get Deposit value
     * @return float|null
     */
    public function getDeposit()
    {
        return $this->Deposit;
    }
    /**
     * Set Deposit value
     * @param float $deposit
     * @return \StructType\TransactionDetails_0_0_1
     */
    public function setDeposit($deposit = null)
    {
        // validation for constraint: float
        if (!is_null($deposit) && !(is_float($deposit) || is_numeric($deposit))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($deposit, true), gettype($deposit)), __LINE__);
        }
        $this->Deposit = $deposit;
        return $this;
    }
    /**
     * Get Narration value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNarration()
    {
        return isset($this->Narration) ? $this->Narration : null;
    }
    /**
     * Set Narration value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $narration
     * @return \StructType\TransactionDetails_0_0_1
     */
    public function setNarration($narration = null)
    {
        // validation for constraint: string
        if (!is_null($narration) && !is_string($narration)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($narration, true), gettype($narration)), __LINE__);
        }
        if (is_null($narration) || (is_array($narration) && empty($narration))) {
            unset($this->Narration);
        } else {
            $this->Narration = $narration;
        }
        return $this;
    }
    /**
     * Get TransactionDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTransactionDate()
    {
        return isset($this->TransactionDate) ? $this->TransactionDate : null;
    }
    /**
     * Set TransactionDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $transactionDate
     * @return \StructType\TransactionDetails_0_0_1
     */
    public function setTransactionDate($transactionDate = null)
    {
        // validation for constraint: string
        if (!is_null($transactionDate) && !is_string($transactionDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionDate, true), gettype($transactionDate)), __LINE__);
        }
        if (is_null($transactionDate) || (is_array($transactionDate) && empty($transactionDate))) {
            unset($this->TransactionDate);
        } else {
            $this->TransactionDate = $transactionDate;
        }
        return $this;
    }
    /**
     * Get TransactionSequenceNo value
     * @return int|null
     */
    public function getTransactionSequenceNo()
    {
        return $this->TransactionSequenceNo;
    }
    /**
     * Set TransactionSequenceNo value
     * @param int $transactionSequenceNo
     * @return \StructType\TransactionDetails_0_0_1
     */
    public function setTransactionSequenceNo($transactionSequenceNo = null)
    {
        // validation for constraint: int
        if (!is_null($transactionSequenceNo) && !(is_int($transactionSequenceNo) || ctype_digit($transactionSequenceNo))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($transactionSequenceNo, true), gettype($transactionSequenceNo)), __LINE__);
        }
        $this->TransactionSequenceNo = $transactionSequenceNo;
        return $this;
    }
    /**
     * Get TransactionType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTransactionType()
    {
        return isset($this->TransactionType) ? $this->TransactionType : null;
    }
    /**
     * Set TransactionType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $transactionType
     * @return \StructType\TransactionDetails_0_0_1
     */
    public function setTransactionType($transactionType = null)
    {
        // validation for constraint: string
        if (!is_null($transactionType) && !is_string($transactionType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionType, true), gettype($transactionType)), __LINE__);
        }
        if (is_null($transactionType) || (is_array($transactionType) && empty($transactionType))) {
            unset($this->TransactionType);
        } else {
            $this->TransactionType = $transactionType;
        }
        return $this;
    }
    /**
     * Get Withdrawal value
     * @return float|null
     */
    public function getWithdrawal()
    {
        return $this->Withdrawal;
    }
    /**
     * Set Withdrawal value
     * @param float $withdrawal
     * @return \StructType\TransactionDetails_0_0_1
     */
    public function setWithdrawal($withdrawal = null)
    {
        // validation for constraint: float
        if (!is_null($withdrawal) && !(is_float($withdrawal) || is_numeric($withdrawal))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($withdrawal, true), gettype($withdrawal)), __LINE__);
        }
        $this->Withdrawal = $withdrawal;
        return $this;
    }
}
