<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SubmitIncomingDealResult StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:SubmitIncomingDealResult
 * @subpackage Structs
 */
class SubmitIncomingDealResult extends AbstractStructBase
{
    /**
     * The DealID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DealID;
    /**
     * The ErrorCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ErrorCode;
    /**
     * The ErrorMessage
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ErrorMessage;
    /**
     * The InstructionToSender
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfInstructionToSender
     */
    public $InstructionToSender;
    /**
     * The OrgID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OrgID;
    /**
     * The PaymentDetail
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfSubmitIncomingDealDetail
     */
    public $PaymentDetail;
    /**
     * The TotalPayment
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $TotalPayment;
    /**
     * Constructor method for SubmitIncomingDealResult
     * @uses SubmitIncomingDealResult::setDealID()
     * @uses SubmitIncomingDealResult::setErrorCode()
     * @uses SubmitIncomingDealResult::setErrorMessage()
     * @uses SubmitIncomingDealResult::setInstructionToSender()
     * @uses SubmitIncomingDealResult::setOrgID()
     * @uses SubmitIncomingDealResult::setPaymentDetail()
     * @uses SubmitIncomingDealResult::setTotalPayment()
     * @param string $dealID
     * @param int $errorCode
     * @param string $errorMessage
     * @param \ArrayType\ArrayOfInstructionToSender $instructionToSender
     * @param string $orgID
     * @param \ArrayType\ArrayOfSubmitIncomingDealDetail $paymentDetail
     * @param int $totalPayment
     */
    public function __construct($dealID = null, $errorCode = null, $errorMessage = null, \ArrayType\ArrayOfInstructionToSender $instructionToSender = null, $orgID = null, \ArrayType\ArrayOfSubmitIncomingDealDetail $paymentDetail = null, $totalPayment = null)
    {
        $this
            ->setDealID($dealID)
            ->setErrorCode($errorCode)
            ->setErrorMessage($errorMessage)
            ->setInstructionToSender($instructionToSender)
            ->setOrgID($orgID)
            ->setPaymentDetail($paymentDetail)
            ->setTotalPayment($totalPayment);
    }
    /**
     * Get DealID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDealID()
    {
        return isset($this->DealID) ? $this->DealID : null;
    }
    /**
     * Set DealID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dealID
     * @return \StructType\SubmitIncomingDealResult
     */
    public function setDealID($dealID = null)
    {
        // validation for constraint: string
        if (!is_null($dealID) && !is_string($dealID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dealID, true), gettype($dealID)), __LINE__);
        }
        if (is_null($dealID) || (is_array($dealID) && empty($dealID))) {
            unset($this->DealID);
        } else {
            $this->DealID = $dealID;
        }
        return $this;
    }
    /**
     * Get ErrorCode value
     * @return int|null
     */
    public function getErrorCode()
    {
        return $this->ErrorCode;
    }
    /**
     * Set ErrorCode value
     * @param int $errorCode
     * @return \StructType\SubmitIncomingDealResult
     */
    public function setErrorCode($errorCode = null)
    {
        // validation for constraint: int
        if (!is_null($errorCode) && !(is_int($errorCode) || ctype_digit($errorCode))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($errorCode, true), gettype($errorCode)), __LINE__);
        }
        $this->ErrorCode = $errorCode;
        return $this;
    }
    /**
     * Get ErrorMessage value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getErrorMessage()
    {
        return isset($this->ErrorMessage) ? $this->ErrorMessage : null;
    }
    /**
     * Set ErrorMessage value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $errorMessage
     * @return \StructType\SubmitIncomingDealResult
     */
    public function setErrorMessage($errorMessage = null)
    {
        // validation for constraint: string
        if (!is_null($errorMessage) && !is_string($errorMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($errorMessage, true), gettype($errorMessage)), __LINE__);
        }
        if (is_null($errorMessage) || (is_array($errorMessage) && empty($errorMessage))) {
            unset($this->ErrorMessage);
        } else {
            $this->ErrorMessage = $errorMessage;
        }
        return $this;
    }
    /**
     * Get InstructionToSender value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfInstructionToSender|null
     */
    public function getInstructionToSender()
    {
        return isset($this->InstructionToSender) ? $this->InstructionToSender : null;
    }
    /**
     * Set InstructionToSender value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfInstructionToSender $instructionToSender
     * @return \StructType\SubmitIncomingDealResult
     */
    public function setInstructionToSender(\ArrayType\ArrayOfInstructionToSender $instructionToSender = null)
    {
        if (is_null($instructionToSender) || (is_array($instructionToSender) && empty($instructionToSender))) {
            unset($this->InstructionToSender);
        } else {
            $this->InstructionToSender = $instructionToSender;
        }
        return $this;
    }
    /**
     * Get OrgID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrgID()
    {
        return isset($this->OrgID) ? $this->OrgID : null;
    }
    /**
     * Set OrgID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $orgID
     * @return \StructType\SubmitIncomingDealResult
     */
    public function setOrgID($orgID = null)
    {
        // validation for constraint: string
        if (!is_null($orgID) && !is_string($orgID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($orgID, true), gettype($orgID)), __LINE__);
        }
        if (is_null($orgID) || (is_array($orgID) && empty($orgID))) {
            unset($this->OrgID);
        } else {
            $this->OrgID = $orgID;
        }
        return $this;
    }
    /**
     * Get PaymentDetail value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfSubmitIncomingDealDetail|null
     */
    public function getPaymentDetail()
    {
        return isset($this->PaymentDetail) ? $this->PaymentDetail : null;
    }
    /**
     * Set PaymentDetail value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfSubmitIncomingDealDetail $paymentDetail
     * @return \StructType\SubmitIncomingDealResult
     */
    public function setPaymentDetail(\ArrayType\ArrayOfSubmitIncomingDealDetail $paymentDetail = null)
    {
        if (is_null($paymentDetail) || (is_array($paymentDetail) && empty($paymentDetail))) {
            unset($this->PaymentDetail);
        } else {
            $this->PaymentDetail = $paymentDetail;
        }
        return $this;
    }
    /**
     * Get TotalPayment value
     * @return int|null
     */
    public function getTotalPayment()
    {
        return $this->TotalPayment;
    }
    /**
     * Set TotalPayment value
     * @param int $totalPayment
     * @return \StructType\SubmitIncomingDealResult
     */
    public function setTotalPayment($totalPayment = null)
    {
        // validation for constraint: int
        if (!is_null($totalPayment) && !(is_int($totalPayment) || ctype_digit($totalPayment))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($totalPayment, true), gettype($totalPayment)), __LINE__);
        }
        $this->TotalPayment = $totalPayment;
        return $this;
    }
}
