<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DeletePendingDealByIdResult StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:DeletePendingDealByIdResult
 * @subpackage Structs
 */
class DeletePendingDealByIdResult extends AbstractStructBase
{
    /**
     * The DealID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $DealID;
    /**
     * The ErrorCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ErrorCode;
    /**
     * The ErrorMessage
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ErrorMessage;
    /**
     * Constructor method for DeletePendingDealByIdResult
     * @uses DeletePendingDealByIdResult::setDealID()
     * @uses DeletePendingDealByIdResult::setErrorCode()
     * @uses DeletePendingDealByIdResult::setErrorMessage()
     * @param int $dealID
     * @param int $errorCode
     * @param string $errorMessage
     */
    public function __construct($dealID = null, $errorCode = null, $errorMessage = null)
    {
        $this
            ->setDealID($dealID)
            ->setErrorCode($errorCode)
            ->setErrorMessage($errorMessage);
    }
    /**
     * Get DealID value
     * @return int|null
     */
    public function getDealID()
    {
        return $this->DealID;
    }
    /**
     * Set DealID value
     * @param int $dealID
     * @return \StructType\DeletePendingDealByIdResult
     */
    public function setDealID($dealID = null)
    {
        // validation for constraint: int
        if (!is_null($dealID) && !(is_int($dealID) || ctype_digit($dealID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($dealID, true), gettype($dealID)), __LINE__);
        }
        $this->DealID = $dealID;
        return $this;
    }
    /**
     * Get ErrorCode value
     * @return int|null
     */
    public function getErrorCode()
    {
        return $this->ErrorCode;
    }
    /**
     * Set ErrorCode value
     * @param int $errorCode
     * @return \StructType\DeletePendingDealByIdResult
     */
    public function setErrorCode($errorCode = null)
    {
        // validation for constraint: int
        if (!is_null($errorCode) && !(is_int($errorCode) || ctype_digit($errorCode))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($errorCode, true), gettype($errorCode)), __LINE__);
        }
        $this->ErrorCode = $errorCode;
        return $this;
    }
    /**
     * Get ErrorMessage value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getErrorMessage()
    {
        return isset($this->ErrorMessage) ? $this->ErrorMessage : null;
    }
    /**
     * Set ErrorMessage value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $errorMessage
     * @return \StructType\DeletePendingDealByIdResult
     */
    public function setErrorMessage($errorMessage = null)
    {
        // validation for constraint: string
        if (!is_null($errorMessage) && !is_string($errorMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($errorMessage, true), gettype($errorMessage)), __LINE__);
        }
        if (is_null($errorMessage) || (is_array($errorMessage) && empty($errorMessage))) {
            unset($this->ErrorMessage);
        } else {
            $this->ErrorMessage = $errorMessage;
        }
        return $this;
    }
}
