<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DeletePendingDealByIdRequest StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:DeletePendingDealByIdRequest
 * @subpackage Structs
 */
class DeletePendingDealByIdRequest extends AbstractStructBase
{
    /**
     * The DealID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $DealID;
    /**
     * The MethodID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $MethodID;
    /**
     * The OrgID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OrgID;
    /**
     * Constructor method for DeletePendingDealByIdRequest
     * @uses DeletePendingDealByIdRequest::setDealID()
     * @uses DeletePendingDealByIdRequest::setMethodID()
     * @uses DeletePendingDealByIdRequest::setOrgID()
     * @param int $dealID
     * @param string $methodID
     * @param string $orgID
     */
    public function __construct($dealID = null, $methodID = null, $orgID = null)
    {
        $this
            ->setDealID($dealID)
            ->setMethodID($methodID)
            ->setOrgID($orgID);
    }
    /**
     * Get DealID value
     * @return int|null
     */
    public function getDealID()
    {
        return $this->DealID;
    }
    /**
     * Set DealID value
     * @param int $dealID
     * @return \StructType\DeletePendingDealByIdRequest
     */
    public function setDealID($dealID = null)
    {
        // validation for constraint: int
        if (!is_null($dealID) && !(is_int($dealID) || ctype_digit($dealID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($dealID, true), gettype($dealID)), __LINE__);
        }
        $this->DealID = $dealID;
        return $this;
    }
    /**
     * Get MethodID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMethodID()
    {
        return isset($this->MethodID) ? $this->MethodID : null;
    }
    /**
     * Set MethodID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $methodID
     * @return \StructType\DeletePendingDealByIdRequest
     */
    public function setMethodID($methodID = null)
    {
        // validation for constraint: string
        if (!is_null($methodID) && !is_string($methodID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($methodID, true), gettype($methodID)), __LINE__);
        }
        if (is_null($methodID) || (is_array($methodID) && empty($methodID))) {
            unset($this->MethodID);
        } else {
            $this->MethodID = $methodID;
        }
        return $this;
    }
    /**
     * Get OrgID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrgID()
    {
        return isset($this->OrgID) ? $this->OrgID : null;
    }
    /**
     * Set OrgID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $orgID
     * @return \StructType\DeletePendingDealByIdRequest
     */
    public function setOrgID($orgID = null)
    {
        // validation for constraint: string
        if (!is_null($orgID) && !is_string($orgID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($orgID, true), gettype($orgID)), __LINE__);
        }
        if (is_null($orgID) || (is_array($orgID) && empty($orgID))) {
            unset($this->OrgID);
        } else {
            $this->OrgID = $orgID;
        }
        return $this;
    }
}
