<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AcceptAndSubmitDealTBAResult StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:AcceptAndSubmitDealTBAResult
 * @subpackage Structs
 */
class AcceptAndSubmitDealTBAResult extends AbstractStructBase
{
    /**
     * The DealId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DealId;
    /**
     * The DealNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DealNumber;
    /**
     * The ErrorCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ErrorCode;
    /**
     * The ErrorMessage
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ErrorMessage;
    /**
     * The QuoteID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $QuoteID;
    /**
     * Constructor method for AcceptAndSubmitDealTBAResult
     * @uses AcceptAndSubmitDealTBAResult::setDealId()
     * @uses AcceptAndSubmitDealTBAResult::setDealNumber()
     * @uses AcceptAndSubmitDealTBAResult::setErrorCode()
     * @uses AcceptAndSubmitDealTBAResult::setErrorMessage()
     * @uses AcceptAndSubmitDealTBAResult::setQuoteID()
     * @param string $dealId
     * @param string $dealNumber
     * @param int $errorCode
     * @param string $errorMessage
     * @param int $quoteID
     */
    public function __construct($dealId = null, $dealNumber = null, $errorCode = null, $errorMessage = null, $quoteID = null)
    {
        $this
            ->setDealId($dealId)
            ->setDealNumber($dealNumber)
            ->setErrorCode($errorCode)
            ->setErrorMessage($errorMessage)
            ->setQuoteID($quoteID);
    }
    /**
     * Get DealId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDealId()
    {
        return isset($this->DealId) ? $this->DealId : null;
    }
    /**
     * Set DealId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dealId
     * @return \StructType\AcceptAndSubmitDealTBAResult
     */
    public function setDealId($dealId = null)
    {
        // validation for constraint: string
        if (!is_null($dealId) && !is_string($dealId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dealId, true), gettype($dealId)), __LINE__);
        }
        if (is_null($dealId) || (is_array($dealId) && empty($dealId))) {
            unset($this->DealId);
        } else {
            $this->DealId = $dealId;
        }
        return $this;
    }
    /**
     * Get DealNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDealNumber()
    {
        return isset($this->DealNumber) ? $this->DealNumber : null;
    }
    /**
     * Set DealNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dealNumber
     * @return \StructType\AcceptAndSubmitDealTBAResult
     */
    public function setDealNumber($dealNumber = null)
    {
        // validation for constraint: string
        if (!is_null($dealNumber) && !is_string($dealNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dealNumber, true), gettype($dealNumber)), __LINE__);
        }
        if (is_null($dealNumber) || (is_array($dealNumber) && empty($dealNumber))) {
            unset($this->DealNumber);
        } else {
            $this->DealNumber = $dealNumber;
        }
        return $this;
    }
    /**
     * Get ErrorCode value
     * @return int|null
     */
    public function getErrorCode()
    {
        return $this->ErrorCode;
    }
    /**
     * Set ErrorCode value
     * @param int $errorCode
     * @return \StructType\AcceptAndSubmitDealTBAResult
     */
    public function setErrorCode($errorCode = null)
    {
        // validation for constraint: int
        if (!is_null($errorCode) && !(is_int($errorCode) || ctype_digit($errorCode))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($errorCode, true), gettype($errorCode)), __LINE__);
        }
        $this->ErrorCode = $errorCode;
        return $this;
    }
    /**
     * Get ErrorMessage value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getErrorMessage()
    {
        return isset($this->ErrorMessage) ? $this->ErrorMessage : null;
    }
    /**
     * Set ErrorMessage value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $errorMessage
     * @return \StructType\AcceptAndSubmitDealTBAResult
     */
    public function setErrorMessage($errorMessage = null)
    {
        // validation for constraint: string
        if (!is_null($errorMessage) && !is_string($errorMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($errorMessage, true), gettype($errorMessage)), __LINE__);
        }
        if (is_null($errorMessage) || (is_array($errorMessage) && empty($errorMessage))) {
            unset($this->ErrorMessage);
        } else {
            $this->ErrorMessage = $errorMessage;
        }
        return $this;
    }
    /**
     * Get QuoteID value
     * @return int|null
     */
    public function getQuoteID()
    {
        return $this->QuoteID;
    }
    /**
     * Set QuoteID value
     * @param int $quoteID
     * @return \StructType\AcceptAndSubmitDealTBAResult
     */
    public function setQuoteID($quoteID = null)
    {
        // validation for constraint: int
        if (!is_null($quoteID) && !(is_int($quoteID) || ctype_digit($quoteID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($quoteID, true), gettype($quoteID)), __LINE__);
        }
        $this->QuoteID = $quoteID;
        return $this;
    }
}
