<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Accept ServiceType
 * @subpackage Services
 */
class Accept extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named AcceptQuote
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AcceptQuote $parameters
     * @return \StructType\AcceptQuoteResponse|bool
     */
    public function AcceptQuote(\StructType\AcceptQuote $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->AcceptQuote($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AcceptAndSubmitDealTBA
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AcceptAndSubmitDealTBA $parameters
     * @return \StructType\AcceptAndSubmitDealTBAResponse|bool
     */
    public function AcceptAndSubmitDealTBA(\StructType\AcceptAndSubmitDealTBA $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->AcceptAndSubmitDealTBA($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\AcceptAndSubmitDealTBAResponse|\StructType\AcceptQuoteResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
