<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfAccountDetails ArrayType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfAccountDetails
 * @subpackage Arrays
 */
class ArrayOfAccountDetails extends AbstractStructArrayBase
{
    /**
     * The AccountDetails
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\AccountDetails[]
     */
    public $AccountDetails;
    /**
     * Constructor method for ArrayOfAccountDetails
     * @uses ArrayOfAccountDetails::setAccountDetails()
     * @param \StructType\AccountDetails[] $accountDetails
     */
    public function __construct(array $accountDetails = array())
    {
        $this
            ->setAccountDetails($accountDetails);
    }
    /**
     * Get AccountDetails value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\AccountDetails[]|null
     */
    public function getAccountDetails()
    {
        return isset($this->AccountDetails) ? $this->AccountDetails : null;
    }
    /**
     * This method is responsible for validating the values passed to the setAccountDetails method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAccountDetails method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAccountDetailsForArrayConstraintsFromSetAccountDetails(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfAccountDetailsAccountDetailsItem) {
            // validation for constraint: itemType
            if (!$arrayOfAccountDetailsAccountDetailsItem instanceof \StructType\AccountDetails) {
                $invalidValues[] = is_object($arrayOfAccountDetailsAccountDetailsItem) ? get_class($arrayOfAccountDetailsAccountDetailsItem) : sprintf('%s(%s)', gettype($arrayOfAccountDetailsAccountDetailsItem), var_export($arrayOfAccountDetailsAccountDetailsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The AccountDetails property can only contain items of type \StructType\AccountDetails, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set AccountDetails value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\AccountDetails[] $accountDetails
     * @return \ArrayType\ArrayOfAccountDetails
     */
    public function setAccountDetails(array $accountDetails = array())
    {
        // validation for constraint: array
        if ('' !== ($accountDetailsArrayErrorMessage = self::validateAccountDetailsForArrayConstraintsFromSetAccountDetails($accountDetails))) {
            throw new \InvalidArgumentException($accountDetailsArrayErrorMessage, __LINE__);
        }
        if (is_null($accountDetails) || (is_array($accountDetails) && empty($accountDetails))) {
            unset($this->AccountDetails);
        } else {
            $this->AccountDetails = $accountDetails;
        }
        return $this;
    }
    /**
     * Add item to AccountDetails value
     * @throws \InvalidArgumentException
     * @param \StructType\AccountDetails $item
     * @return \ArrayType\ArrayOfAccountDetails
     */
    public function addToAccountDetails(\StructType\AccountDetails $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\AccountDetails) {
            throw new \InvalidArgumentException(sprintf('The AccountDetails property can only contain items of type \StructType\AccountDetails, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->AccountDetails[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\AccountDetails|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\AccountDetails|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\AccountDetails|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\AccountDetails|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\AccountDetails|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string AccountDetails
     */
    public function getAttributeName()
    {
        return 'AccountDetails';
    }
}
