<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ValidateIBAN StructType
 * @subpackage Structs
 */
class ValidateIBAN extends AbstractStructBase
{
    /**
     * The request
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ValidateIBANRequest
     */
    public $request;
    /**
     * Constructor method for ValidateIBAN
     * @uses ValidateIBAN::setRequest()
     * @param \StructType\ValidateIBANRequest $request
     */
    public function __construct(\StructType\ValidateIBANRequest $request = null)
    {
        $this
            ->setRequest($request);
    }
    /**
     * Get request value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ValidateIBANRequest|null
     */
    public function getRequest()
    {
        return isset($this->request) ? $this->request : null;
    }
    /**
     * Set request value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\ValidateIBANRequest $request
     * @return \StructType\ValidateIBAN
     */
    public function setRequest(\StructType\ValidateIBANRequest $request = null)
    {
        if (is_null($request) || (is_array($request) && empty($request))) {
            unset($this->request);
        } else {
            $this->request = $request;
        }
        return $this;
    }
}
