<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TransactionDetails StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:TransactionDetails
 * @subpackage Structs
 */
class TransactionDetails extends AbstractStructBase
{
    /**
     * The Balance
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $Balance;
    /**
     * The Deposit
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $Deposit;
    /**
     * The Narration
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Narration;
    /**
     * The TransactionDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $TransactionDate;
    /**
     * The TransactionSequenceNo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $TransactionSequenceNo;
    /**
     * The Withdrawal
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $Withdrawal;
    /**
     * Constructor method for TransactionDetails
     * @uses TransactionDetails::setBalance()
     * @uses TransactionDetails::setDeposit()
     * @uses TransactionDetails::setNarration()
     * @uses TransactionDetails::setTransactionDate()
     * @uses TransactionDetails::setTransactionSequenceNo()
     * @uses TransactionDetails::setWithdrawal()
     * @param float $balance
     * @param float $deposit
     * @param string $narration
     * @param string $transactionDate
     * @param int $transactionSequenceNo
     * @param float $withdrawal
     */
    public function __construct($balance = null, $deposit = null, $narration = null, $transactionDate = null, $transactionSequenceNo = null, $withdrawal = null)
    {
        $this
            ->setBalance($balance)
            ->setDeposit($deposit)
            ->setNarration($narration)
            ->setTransactionDate($transactionDate)
            ->setTransactionSequenceNo($transactionSequenceNo)
            ->setWithdrawal($withdrawal);
    }
    /**
     * Get Balance value
     * @return float|null
     */
    public function getBalance()
    {
        return $this->Balance;
    }
    /**
     * Set Balance value
     * @param float $balance
     * @return \StructType\TransactionDetails
     */
    public function setBalance($balance = null)
    {
        // validation for constraint: float
        if (!is_null($balance) && !(is_float($balance) || is_numeric($balance))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($balance, true), gettype($balance)), __LINE__);
        }
        $this->Balance = $balance;
        return $this;
    }
    /**
     * Get Deposit value
     * @return float|null
     */
    public function getDeposit()
    {
        return $this->Deposit;
    }
    /**
     * Set Deposit value
     * @param float $deposit
     * @return \StructType\TransactionDetails
     */
    public function setDeposit($deposit = null)
    {
        // validation for constraint: float
        if (!is_null($deposit) && !(is_float($deposit) || is_numeric($deposit))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($deposit, true), gettype($deposit)), __LINE__);
        }
        $this->Deposit = $deposit;
        return $this;
    }
    /**
     * Get Narration value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNarration()
    {
        return isset($this->Narration) ? $this->Narration : null;
    }
    /**
     * Set Narration value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $narration
     * @return \StructType\TransactionDetails
     */
    public function setNarration($narration = null)
    {
        // validation for constraint: string
        if (!is_null($narration) && !is_string($narration)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($narration, true), gettype($narration)), __LINE__);
        }
        if (is_null($narration) || (is_array($narration) && empty($narration))) {
            unset($this->Narration);
        } else {
            $this->Narration = $narration;
        }
        return $this;
    }
    /**
     * Get TransactionDate value
     * @return string|null
     */
    public function getTransactionDate()
    {
        return $this->TransactionDate;
    }
    /**
     * Set TransactionDate value
     * @param string $transactionDate
     * @return \StructType\TransactionDetails
     */
    public function setTransactionDate($transactionDate = null)
    {
        // validation for constraint: string
        if (!is_null($transactionDate) && !is_string($transactionDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionDate, true), gettype($transactionDate)), __LINE__);
        }
        $this->TransactionDate = $transactionDate;
        return $this;
    }
    /**
     * Get TransactionSequenceNo value
     * @return int|null
     */
    public function getTransactionSequenceNo()
    {
        return $this->TransactionSequenceNo;
    }
    /**
     * Set TransactionSequenceNo value
     * @param int $transactionSequenceNo
     * @return \StructType\TransactionDetails
     */
    public function setTransactionSequenceNo($transactionSequenceNo = null)
    {
        // validation for constraint: int
        if (!is_null($transactionSequenceNo) && !(is_int($transactionSequenceNo) || ctype_digit($transactionSequenceNo))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($transactionSequenceNo, true), gettype($transactionSequenceNo)), __LINE__);
        }
        $this->TransactionSequenceNo = $transactionSequenceNo;
        return $this;
    }
    /**
     * Get Withdrawal value
     * @return float|null
     */
    public function getWithdrawal()
    {
        return $this->Withdrawal;
    }
    /**
     * Set Withdrawal value
     * @param float $withdrawal
     * @return \StructType\TransactionDetails
     */
    public function setWithdrawal($withdrawal = null)
    {
        // validation for constraint: float
        if (!is_null($withdrawal) && !(is_float($withdrawal) || is_numeric($withdrawal))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($withdrawal, true), gettype($withdrawal)), __LINE__);
        }
        $this->Withdrawal = $withdrawal;
        return $this;
    }
}
