<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SubmitIncomingDealDetail StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:SubmitIncomingDealDetail
 * @subpackage Structs
 */
class SubmitIncomingDealDetail extends AbstractStructBase
{
    /**
     * The Fee
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $Fee;
    /**
     * The FxAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $FxAmount;
    /**
     * The FxCurrencyID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FxCurrencyID;
    /**
     * The InternalReference
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $InternalReference;
    /**
     * The PaymentMethod
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PaymentMethod;
    /**
     * The PaymentSequenceNo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $PaymentSequenceNo;
    /**
     * The Rate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $Rate;
    /**
     * The SettlementAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $SettlementAmount;
    /**
     * The SettlementCurrencyID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SettlementCurrencyID;
    /**
     * The TotalSettlementAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $TotalSettlementAmount;
    /**
     * The payee
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\SubmitIncomingPayee
     */
    public $payee;
    /**
     * Constructor method for SubmitIncomingDealDetail
     * @uses SubmitIncomingDealDetail::setFee()
     * @uses SubmitIncomingDealDetail::setFxAmount()
     * @uses SubmitIncomingDealDetail::setFxCurrencyID()
     * @uses SubmitIncomingDealDetail::setInternalReference()
     * @uses SubmitIncomingDealDetail::setPaymentMethod()
     * @uses SubmitIncomingDealDetail::setPaymentSequenceNo()
     * @uses SubmitIncomingDealDetail::setRate()
     * @uses SubmitIncomingDealDetail::setSettlementAmount()
     * @uses SubmitIncomingDealDetail::setSettlementCurrencyID()
     * @uses SubmitIncomingDealDetail::setTotalSettlementAmount()
     * @uses SubmitIncomingDealDetail::setPayee()
     * @param float $fee
     * @param float $fxAmount
     * @param string $fxCurrencyID
     * @param string $internalReference
     * @param string $paymentMethod
     * @param int $paymentSequenceNo
     * @param float $rate
     * @param float $settlementAmount
     * @param string $settlementCurrencyID
     * @param float $totalSettlementAmount
     * @param \StructType\SubmitIncomingPayee $payee
     */
    public function __construct($fee = null, $fxAmount = null, $fxCurrencyID = null, $internalReference = null, $paymentMethod = null, $paymentSequenceNo = null, $rate = null, $settlementAmount = null, $settlementCurrencyID = null, $totalSettlementAmount = null, \StructType\SubmitIncomingPayee $payee = null)
    {
        $this
            ->setFee($fee)
            ->setFxAmount($fxAmount)
            ->setFxCurrencyID($fxCurrencyID)
            ->setInternalReference($internalReference)
            ->setPaymentMethod($paymentMethod)
            ->setPaymentSequenceNo($paymentSequenceNo)
            ->setRate($rate)
            ->setSettlementAmount($settlementAmount)
            ->setSettlementCurrencyID($settlementCurrencyID)
            ->setTotalSettlementAmount($totalSettlementAmount)
            ->setPayee($payee);
    }
    /**
     * Get Fee value
     * @return float|null
     */
    public function getFee()
    {
        return $this->Fee;
    }
    /**
     * Set Fee value
     * @param float $fee
     * @return \StructType\SubmitIncomingDealDetail
     */
    public function setFee($fee = null)
    {
        // validation for constraint: float
        if (!is_null($fee) && !(is_float($fee) || is_numeric($fee))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($fee, true), gettype($fee)), __LINE__);
        }
        $this->Fee = $fee;
        return $this;
    }
    /**
     * Get FxAmount value
     * @return float|null
     */
    public function getFxAmount()
    {
        return $this->FxAmount;
    }
    /**
     * Set FxAmount value
     * @param float $fxAmount
     * @return \StructType\SubmitIncomingDealDetail
     */
    public function setFxAmount($fxAmount = null)
    {
        // validation for constraint: float
        if (!is_null($fxAmount) && !(is_float($fxAmount) || is_numeric($fxAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($fxAmount, true), gettype($fxAmount)), __LINE__);
        }
        $this->FxAmount = $fxAmount;
        return $this;
    }
    /**
     * Get FxCurrencyID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFxCurrencyID()
    {
        return isset($this->FxCurrencyID) ? $this->FxCurrencyID : null;
    }
    /**
     * Set FxCurrencyID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $fxCurrencyID
     * @return \StructType\SubmitIncomingDealDetail
     */
    public function setFxCurrencyID($fxCurrencyID = null)
    {
        // validation for constraint: string
        if (!is_null($fxCurrencyID) && !is_string($fxCurrencyID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fxCurrencyID, true), gettype($fxCurrencyID)), __LINE__);
        }
        if (is_null($fxCurrencyID) || (is_array($fxCurrencyID) && empty($fxCurrencyID))) {
            unset($this->FxCurrencyID);
        } else {
            $this->FxCurrencyID = $fxCurrencyID;
        }
        return $this;
    }
    /**
     * Get InternalReference value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInternalReference()
    {
        return isset($this->InternalReference) ? $this->InternalReference : null;
    }
    /**
     * Set InternalReference value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $internalReference
     * @return \StructType\SubmitIncomingDealDetail
     */
    public function setInternalReference($internalReference = null)
    {
        // validation for constraint: string
        if (!is_null($internalReference) && !is_string($internalReference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($internalReference, true), gettype($internalReference)), __LINE__);
        }
        if (is_null($internalReference) || (is_array($internalReference) && empty($internalReference))) {
            unset($this->InternalReference);
        } else {
            $this->InternalReference = $internalReference;
        }
        return $this;
    }
    /**
     * Get PaymentMethod value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPaymentMethod()
    {
        return isset($this->PaymentMethod) ? $this->PaymentMethod : null;
    }
    /**
     * Set PaymentMethod value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $paymentMethod
     * @return \StructType\SubmitIncomingDealDetail
     */
    public function setPaymentMethod($paymentMethod = null)
    {
        // validation for constraint: string
        if (!is_null($paymentMethod) && !is_string($paymentMethod)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentMethod, true), gettype($paymentMethod)), __LINE__);
        }
        if (is_null($paymentMethod) || (is_array($paymentMethod) && empty($paymentMethod))) {
            unset($this->PaymentMethod);
        } else {
            $this->PaymentMethod = $paymentMethod;
        }
        return $this;
    }
    /**
     * Get PaymentSequenceNo value
     * @return int|null
     */
    public function getPaymentSequenceNo()
    {
        return $this->PaymentSequenceNo;
    }
    /**
     * Set PaymentSequenceNo value
     * @param int $paymentSequenceNo
     * @return \StructType\SubmitIncomingDealDetail
     */
    public function setPaymentSequenceNo($paymentSequenceNo = null)
    {
        // validation for constraint: int
        if (!is_null($paymentSequenceNo) && !(is_int($paymentSequenceNo) || ctype_digit($paymentSequenceNo))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($paymentSequenceNo, true), gettype($paymentSequenceNo)), __LINE__);
        }
        $this->PaymentSequenceNo = $paymentSequenceNo;
        return $this;
    }
    /**
     * Get Rate value
     * @return float|null
     */
    public function getRate()
    {
        return $this->Rate;
    }
    /**
     * Set Rate value
     * @param float $rate
     * @return \StructType\SubmitIncomingDealDetail
     */
    public function setRate($rate = null)
    {
        // validation for constraint: float
        if (!is_null($rate) && !(is_float($rate) || is_numeric($rate))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($rate, true), gettype($rate)), __LINE__);
        }
        $this->Rate = $rate;
        return $this;
    }
    /**
     * Get SettlementAmount value
     * @return float|null
     */
    public function getSettlementAmount()
    {
        return $this->SettlementAmount;
    }
    /**
     * Set SettlementAmount value
     * @param float $settlementAmount
     * @return \StructType\SubmitIncomingDealDetail
     */
    public function setSettlementAmount($settlementAmount = null)
    {
        // validation for constraint: float
        if (!is_null($settlementAmount) && !(is_float($settlementAmount) || is_numeric($settlementAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($settlementAmount, true), gettype($settlementAmount)), __LINE__);
        }
        $this->SettlementAmount = $settlementAmount;
        return $this;
    }
    /**
     * Get SettlementCurrencyID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSettlementCurrencyID()
    {
        return isset($this->SettlementCurrencyID) ? $this->SettlementCurrencyID : null;
    }
    /**
     * Set SettlementCurrencyID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $settlementCurrencyID
     * @return \StructType\SubmitIncomingDealDetail
     */
    public function setSettlementCurrencyID($settlementCurrencyID = null)
    {
        // validation for constraint: string
        if (!is_null($settlementCurrencyID) && !is_string($settlementCurrencyID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($settlementCurrencyID, true), gettype($settlementCurrencyID)), __LINE__);
        }
        if (is_null($settlementCurrencyID) || (is_array($settlementCurrencyID) && empty($settlementCurrencyID))) {
            unset($this->SettlementCurrencyID);
        } else {
            $this->SettlementCurrencyID = $settlementCurrencyID;
        }
        return $this;
    }
    /**
     * Get TotalSettlementAmount value
     * @return float|null
     */
    public function getTotalSettlementAmount()
    {
        return $this->TotalSettlementAmount;
    }
    /**
     * Set TotalSettlementAmount value
     * @param float $totalSettlementAmount
     * @return \StructType\SubmitIncomingDealDetail
     */
    public function setTotalSettlementAmount($totalSettlementAmount = null)
    {
        // validation for constraint: float
        if (!is_null($totalSettlementAmount) && !(is_float($totalSettlementAmount) || is_numeric($totalSettlementAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($totalSettlementAmount, true), gettype($totalSettlementAmount)), __LINE__);
        }
        $this->TotalSettlementAmount = $totalSettlementAmount;
        return $this;
    }
    /**
     * Get payee value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\SubmitIncomingPayee|null
     */
    public function getPayee()
    {
        return isset($this->payee) ? $this->payee : null;
    }
    /**
     * Set payee value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\SubmitIncomingPayee $payee
     * @return \StructType\SubmitIncomingDealDetail
     */
    public function setPayee(\StructType\SubmitIncomingPayee $payee = null)
    {
        if (is_null($payee) || (is_array($payee) && empty($payee))) {
            unset($this->payee);
        } else {
            $this->payee = $payee;
        }
        return $this;
    }
}
