<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PostDealConfirmationResult StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:PostDealConfirmationResult
 * @subpackage Structs
 */
class PostDealConfirmationResult extends AbstractStructBase
{
    /**
     * The AFXDealID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AFXDealID;
    /**
     * The AFXPaymentID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AFXPaymentID;
    /**
     * The DealPostCallID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $DealPostCallID;
    /**
     * The DealPostConfirm
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $DealPostConfirm;
    /**
     * The ErrorCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ErrorCode;
    /**
     * The ErrorMessage
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ErrorMessage;
    /**
     * The OrgID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OrgID;
    /**
     * Constructor method for PostDealConfirmationResult
     * @uses PostDealConfirmationResult::setAFXDealID()
     * @uses PostDealConfirmationResult::setAFXPaymentID()
     * @uses PostDealConfirmationResult::setDealPostCallID()
     * @uses PostDealConfirmationResult::setDealPostConfirm()
     * @uses PostDealConfirmationResult::setErrorCode()
     * @uses PostDealConfirmationResult::setErrorMessage()
     * @uses PostDealConfirmationResult::setOrgID()
     * @param string $aFXDealID
     * @param string $aFXPaymentID
     * @param int $dealPostCallID
     * @param string $dealPostConfirm
     * @param int $errorCode
     * @param string $errorMessage
     * @param string $orgID
     */
    public function __construct($aFXDealID = null, $aFXPaymentID = null, $dealPostCallID = null, $dealPostConfirm = null, $errorCode = null, $errorMessage = null, $orgID = null)
    {
        $this
            ->setAFXDealID($aFXDealID)
            ->setAFXPaymentID($aFXPaymentID)
            ->setDealPostCallID($dealPostCallID)
            ->setDealPostConfirm($dealPostConfirm)
            ->setErrorCode($errorCode)
            ->setErrorMessage($errorMessage)
            ->setOrgID($orgID);
    }
    /**
     * Get AFXDealID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAFXDealID()
    {
        return isset($this->AFXDealID) ? $this->AFXDealID : null;
    }
    /**
     * Set AFXDealID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $aFXDealID
     * @return \StructType\PostDealConfirmationResult
     */
    public function setAFXDealID($aFXDealID = null)
    {
        // validation for constraint: string
        if (!is_null($aFXDealID) && !is_string($aFXDealID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aFXDealID, true), gettype($aFXDealID)), __LINE__);
        }
        if (is_null($aFXDealID) || (is_array($aFXDealID) && empty($aFXDealID))) {
            unset($this->AFXDealID);
        } else {
            $this->AFXDealID = $aFXDealID;
        }
        return $this;
    }
    /**
     * Get AFXPaymentID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAFXPaymentID()
    {
        return isset($this->AFXPaymentID) ? $this->AFXPaymentID : null;
    }
    /**
     * Set AFXPaymentID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $aFXPaymentID
     * @return \StructType\PostDealConfirmationResult
     */
    public function setAFXPaymentID($aFXPaymentID = null)
    {
        // validation for constraint: string
        if (!is_null($aFXPaymentID) && !is_string($aFXPaymentID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aFXPaymentID, true), gettype($aFXPaymentID)), __LINE__);
        }
        if (is_null($aFXPaymentID) || (is_array($aFXPaymentID) && empty($aFXPaymentID))) {
            unset($this->AFXPaymentID);
        } else {
            $this->AFXPaymentID = $aFXPaymentID;
        }
        return $this;
    }
    /**
     * Get DealPostCallID value
     * @return int|null
     */
    public function getDealPostCallID()
    {
        return $this->DealPostCallID;
    }
    /**
     * Set DealPostCallID value
     * @param int $dealPostCallID
     * @return \StructType\PostDealConfirmationResult
     */
    public function setDealPostCallID($dealPostCallID = null)
    {
        // validation for constraint: int
        if (!is_null($dealPostCallID) && !(is_int($dealPostCallID) || ctype_digit($dealPostCallID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($dealPostCallID, true), gettype($dealPostCallID)), __LINE__);
        }
        $this->DealPostCallID = $dealPostCallID;
        return $this;
    }
    /**
     * Get DealPostConfirm value
     * @return string|null
     */
    public function getDealPostConfirm()
    {
        return $this->DealPostConfirm;
    }
    /**
     * Set DealPostConfirm value
     * @uses \EnumType\DealPostConfirm::valueIsValid()
     * @uses \EnumType\DealPostConfirm::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $dealPostConfirm
     * @return \StructType\PostDealConfirmationResult
     */
    public function setDealPostConfirm($dealPostConfirm = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\DealPostConfirm::valueIsValid($dealPostConfirm)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\DealPostConfirm', is_array($dealPostConfirm) ? implode(', ', $dealPostConfirm) : var_export($dealPostConfirm, true), implode(', ', \EnumType\DealPostConfirm::getValidValues())), __LINE__);
        }
        $this->DealPostConfirm = $dealPostConfirm;
        return $this;
    }
    /**
     * Get ErrorCode value
     * @return int|null
     */
    public function getErrorCode()
    {
        return $this->ErrorCode;
    }
    /**
     * Set ErrorCode value
     * @param int $errorCode
     * @return \StructType\PostDealConfirmationResult
     */
    public function setErrorCode($errorCode = null)
    {
        // validation for constraint: int
        if (!is_null($errorCode) && !(is_int($errorCode) || ctype_digit($errorCode))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($errorCode, true), gettype($errorCode)), __LINE__);
        }
        $this->ErrorCode = $errorCode;
        return $this;
    }
    /**
     * Get ErrorMessage value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getErrorMessage()
    {
        return isset($this->ErrorMessage) ? $this->ErrorMessage : null;
    }
    /**
     * Set ErrorMessage value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $errorMessage
     * @return \StructType\PostDealConfirmationResult
     */
    public function setErrorMessage($errorMessage = null)
    {
        // validation for constraint: string
        if (!is_null($errorMessage) && !is_string($errorMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($errorMessage, true), gettype($errorMessage)), __LINE__);
        }
        if (is_null($errorMessage) || (is_array($errorMessage) && empty($errorMessage))) {
            unset($this->ErrorMessage);
        } else {
            $this->ErrorMessage = $errorMessage;
        }
        return $this;
    }
    /**
     * Get OrgID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrgID()
    {
        return isset($this->OrgID) ? $this->OrgID : null;
    }
    /**
     * Set OrgID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $orgID
     * @return \StructType\PostDealConfirmationResult
     */
    public function setOrgID($orgID = null)
    {
        // validation for constraint: string
        if (!is_null($orgID) && !is_string($orgID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($orgID, true), gettype($orgID)), __LINE__);
        }
        if (is_null($orgID) || (is_array($orgID) && empty($orgID))) {
            unset($this->OrgID);
        } else {
            $this->OrgID = $orgID;
        }
        return $this;
    }
}
