<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Submit ServiceType
 * @subpackage Services
 */
class Submit extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named SubmitDeal
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SubmitDeal $parameters
     * @return \StructType\SubmitDealResponse|bool
     */
    public function SubmitDeal(\StructType\SubmitDeal $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SubmitDeal($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SubmitDealDefaultFunding
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SubmitDealDefaultFunding $parameters
     * @return \StructType\SubmitDealDefaultFundingResponse|bool
     */
    public function SubmitDealDefaultFunding(\StructType\SubmitDealDefaultFunding $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SubmitDealDefaultFunding($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SubmitDealAutoQuote
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SubmitDealAutoQuote $parameters
     * @return \StructType\SubmitDealAutoQuoteResponse|bool
     */
    public function SubmitDealAutoQuote(\StructType\SubmitDealAutoQuote $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SubmitDealAutoQuote($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SubmitDealForApproval
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SubmitDealForApproval $parameters
     * @return \StructType\SubmitDealForApprovalResponse|bool
     */
    public function SubmitDealForApproval(\StructType\SubmitDealForApproval $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SubmitDealForApproval($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SubmitDeal_0_0_1
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SubmitDeal_0_0_1 $parameters
     * @return \StructType\SubmitDeal_0_0_1Response|bool
     */
    public function SubmitDeal_0_0_1(\StructType\SubmitDeal_0_0_1 $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SubmitDeal_0_0_1($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SubmitDeal_0_0_2
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SubmitDeal_0_0_2 $parameters
     * @return \StructType\SubmitDeal_0_0_2Response|bool
     */
    public function SubmitDeal_0_0_2(\StructType\SubmitDeal_0_0_2 $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SubmitDeal_0_0_2($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SubmitIncomingDeal
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SubmitIncomingDeal $parameters
     * @return \StructType\SubmitIncomingDealResponse|bool
     */
    public function SubmitIncomingDeal(\StructType\SubmitIncomingDeal $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SubmitIncomingDeal($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\SubmitDealAutoQuoteResponse|\StructType\SubmitDealDefaultFundingResponse|\StructType\SubmitDealForApprovalResponse|\StructType\SubmitDealResponse|\StructType\SubmitDeal_0_0_1Response|\StructType\SubmitDeal_0_0_2Response|\StructType\SubmitIncomingDealResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
