<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Incoming ServiceType
 * @subpackage Services
 */
class Incoming extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named IncomingFundStatusCheck
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\IncomingFundStatusCheck $parameters
     * @return \StructType\IncomingFundStatusCheckResponse|bool
     */
    public function IncomingFundStatusCheck(\StructType\IncomingFundStatusCheck $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->IncomingFundStatusCheck($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\IncomingFundStatusCheckResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
