<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ValidationDetails StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ValidationDetails
 * @subpackage Structs
 */
class ValidationDetails extends AbstractStructBase
{
    /**
     * The ErrorCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ErrorCode;
    /**
     * The ErrorDetail
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfErrorDetails
     */
    public $ErrorDetail;
    /**
     * The PayeeDetail
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\PayeeDetail
     */
    public $PayeeDetail;
    /**
     * Constructor method for ValidationDetails
     * @uses ValidationDetails::setErrorCode()
     * @uses ValidationDetails::setErrorDetail()
     * @uses ValidationDetails::setPayeeDetail()
     * @param int $errorCode
     * @param \ArrayType\ArrayOfErrorDetails $errorDetail
     * @param \StructType\PayeeDetail $payeeDetail
     */
    public function __construct($errorCode = null, \ArrayType\ArrayOfErrorDetails $errorDetail = null, \StructType\PayeeDetail $payeeDetail = null)
    {
        $this
            ->setErrorCode($errorCode)
            ->setErrorDetail($errorDetail)
            ->setPayeeDetail($payeeDetail);
    }
    /**
     * Get ErrorCode value
     * @return int|null
     */
    public function getErrorCode()
    {
        return $this->ErrorCode;
    }
    /**
     * Set ErrorCode value
     * @param int $errorCode
     * @return \StructType\ValidationDetails
     */
    public function setErrorCode($errorCode = null)
    {
        // validation for constraint: int
        if (!is_null($errorCode) && !(is_int($errorCode) || ctype_digit($errorCode))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($errorCode, true), gettype($errorCode)), __LINE__);
        }
        $this->ErrorCode = $errorCode;
        return $this;
    }
    /**
     * Get ErrorDetail value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfErrorDetails|null
     */
    public function getErrorDetail()
    {
        return isset($this->ErrorDetail) ? $this->ErrorDetail : null;
    }
    /**
     * Set ErrorDetail value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfErrorDetails $errorDetail
     * @return \StructType\ValidationDetails
     */
    public function setErrorDetail(\ArrayType\ArrayOfErrorDetails $errorDetail = null)
    {
        if (is_null($errorDetail) || (is_array($errorDetail) && empty($errorDetail))) {
            unset($this->ErrorDetail);
        } else {
            $this->ErrorDetail = $errorDetail;
        }
        return $this;
    }
    /**
     * Get PayeeDetail value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\PayeeDetail|null
     */
    public function getPayeeDetail()
    {
        return isset($this->PayeeDetail) ? $this->PayeeDetail : null;
    }
    /**
     * Set PayeeDetail value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\PayeeDetail $payeeDetail
     * @return \StructType\ValidationDetails
     */
    public function setPayeeDetail(\StructType\PayeeDetail $payeeDetail = null)
    {
        if (is_null($payeeDetail) || (is_array($payeeDetail) && empty($payeeDetail))) {
            unset($this->PayeeDetail);
        } else {
            $this->PayeeDetail = $payeeDetail;
        }
        return $this;
    }
}
