<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ValidateIBANResult StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ValidateIBANResult
 * @subpackage Structs
 */
class ValidateIBANResult extends AbstractStructBase
{
    /**
     * The Address
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Address;
    /**
     * The BankName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $BankName;
    /**
     * The BeneficiaryBankCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $BeneficiaryBankCode;
    /**
     * The BeneficiaryBankCountryId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $BeneficiaryBankCountryId;
    /**
     * The BeneficiaryBankRoutingCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $BeneficiaryBankRoutingCode;
    /**
     * The City
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $City;
    /**
     * The Country
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Country;
    /**
     * The CountryCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CountryCode;
    /**
     * The ErrorCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ErrorCode;
    /**
     * The ErrorMessage
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ErrorMessage;
    /**
     * The IBANNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $IBANNumber;
    /**
     * The RoutingCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RoutingCode;
    /**
     * The SwiftCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SwiftCode;
    /**
     * The Valid
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $Valid;
    /**
     * Constructor method for ValidateIBANResult
     * @uses ValidateIBANResult::setAddress()
     * @uses ValidateIBANResult::setBankName()
     * @uses ValidateIBANResult::setBeneficiaryBankCode()
     * @uses ValidateIBANResult::setBeneficiaryBankCountryId()
     * @uses ValidateIBANResult::setBeneficiaryBankRoutingCode()
     * @uses ValidateIBANResult::setCity()
     * @uses ValidateIBANResult::setCountry()
     * @uses ValidateIBANResult::setCountryCode()
     * @uses ValidateIBANResult::setErrorCode()
     * @uses ValidateIBANResult::setErrorMessage()
     * @uses ValidateIBANResult::setIBANNumber()
     * @uses ValidateIBANResult::setRoutingCode()
     * @uses ValidateIBANResult::setSwiftCode()
     * @uses ValidateIBANResult::setValid()
     * @param string $address
     * @param string $bankName
     * @param string $beneficiaryBankCode
     * @param string $beneficiaryBankCountryId
     * @param string $beneficiaryBankRoutingCode
     * @param string $city
     * @param string $country
     * @param string $countryCode
     * @param int $errorCode
     * @param string $errorMessage
     * @param string $iBANNumber
     * @param string $routingCode
     * @param string $swiftCode
     * @param bool $valid
     */
    public function __construct($address = null, $bankName = null, $beneficiaryBankCode = null, $beneficiaryBankCountryId = null, $beneficiaryBankRoutingCode = null, $city = null, $country = null, $countryCode = null, $errorCode = null, $errorMessage = null, $iBANNumber = null, $routingCode = null, $swiftCode = null, $valid = null)
    {
        $this
            ->setAddress($address)
            ->setBankName($bankName)
            ->setBeneficiaryBankCode($beneficiaryBankCode)
            ->setBeneficiaryBankCountryId($beneficiaryBankCountryId)
            ->setBeneficiaryBankRoutingCode($beneficiaryBankRoutingCode)
            ->setCity($city)
            ->setCountry($country)
            ->setCountryCode($countryCode)
            ->setErrorCode($errorCode)
            ->setErrorMessage($errorMessage)
            ->setIBANNumber($iBANNumber)
            ->setRoutingCode($routingCode)
            ->setSwiftCode($swiftCode)
            ->setValid($valid);
    }
    /**
     * Get Address value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAddress()
    {
        return isset($this->Address) ? $this->Address : null;
    }
    /**
     * Set Address value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $address
     * @return \StructType\ValidateIBANResult
     */
    public function setAddress($address = null)
    {
        // validation for constraint: string
        if (!is_null($address) && !is_string($address)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($address, true), gettype($address)), __LINE__);
        }
        if (is_null($address) || (is_array($address) && empty($address))) {
            unset($this->Address);
        } else {
            $this->Address = $address;
        }
        return $this;
    }
    /**
     * Get BankName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBankName()
    {
        return isset($this->BankName) ? $this->BankName : null;
    }
    /**
     * Set BankName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bankName
     * @return \StructType\ValidateIBANResult
     */
    public function setBankName($bankName = null)
    {
        // validation for constraint: string
        if (!is_null($bankName) && !is_string($bankName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bankName, true), gettype($bankName)), __LINE__);
        }
        if (is_null($bankName) || (is_array($bankName) && empty($bankName))) {
            unset($this->BankName);
        } else {
            $this->BankName = $bankName;
        }
        return $this;
    }
    /**
     * Get BeneficiaryBankCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBeneficiaryBankCode()
    {
        return isset($this->BeneficiaryBankCode) ? $this->BeneficiaryBankCode : null;
    }
    /**
     * Set BeneficiaryBankCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $beneficiaryBankCode
     * @return \StructType\ValidateIBANResult
     */
    public function setBeneficiaryBankCode($beneficiaryBankCode = null)
    {
        // validation for constraint: string
        if (!is_null($beneficiaryBankCode) && !is_string($beneficiaryBankCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($beneficiaryBankCode, true), gettype($beneficiaryBankCode)), __LINE__);
        }
        if (is_null($beneficiaryBankCode) || (is_array($beneficiaryBankCode) && empty($beneficiaryBankCode))) {
            unset($this->BeneficiaryBankCode);
        } else {
            $this->BeneficiaryBankCode = $beneficiaryBankCode;
        }
        return $this;
    }
    /**
     * Get BeneficiaryBankCountryId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBeneficiaryBankCountryId()
    {
        return isset($this->BeneficiaryBankCountryId) ? $this->BeneficiaryBankCountryId : null;
    }
    /**
     * Set BeneficiaryBankCountryId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $beneficiaryBankCountryId
     * @return \StructType\ValidateIBANResult
     */
    public function setBeneficiaryBankCountryId($beneficiaryBankCountryId = null)
    {
        // validation for constraint: string
        if (!is_null($beneficiaryBankCountryId) && !is_string($beneficiaryBankCountryId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($beneficiaryBankCountryId, true), gettype($beneficiaryBankCountryId)), __LINE__);
        }
        if (is_null($beneficiaryBankCountryId) || (is_array($beneficiaryBankCountryId) && empty($beneficiaryBankCountryId))) {
            unset($this->BeneficiaryBankCountryId);
        } else {
            $this->BeneficiaryBankCountryId = $beneficiaryBankCountryId;
        }
        return $this;
    }
    /**
     * Get BeneficiaryBankRoutingCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBeneficiaryBankRoutingCode()
    {
        return isset($this->BeneficiaryBankRoutingCode) ? $this->BeneficiaryBankRoutingCode : null;
    }
    /**
     * Set BeneficiaryBankRoutingCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $beneficiaryBankRoutingCode
     * @return \StructType\ValidateIBANResult
     */
    public function setBeneficiaryBankRoutingCode($beneficiaryBankRoutingCode = null)
    {
        // validation for constraint: string
        if (!is_null($beneficiaryBankRoutingCode) && !is_string($beneficiaryBankRoutingCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($beneficiaryBankRoutingCode, true), gettype($beneficiaryBankRoutingCode)), __LINE__);
        }
        if (is_null($beneficiaryBankRoutingCode) || (is_array($beneficiaryBankRoutingCode) && empty($beneficiaryBankRoutingCode))) {
            unset($this->BeneficiaryBankRoutingCode);
        } else {
            $this->BeneficiaryBankRoutingCode = $beneficiaryBankRoutingCode;
        }
        return $this;
    }
    /**
     * Get City value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCity()
    {
        return isset($this->City) ? $this->City : null;
    }
    /**
     * Set City value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $city
     * @return \StructType\ValidateIBANResult
     */
    public function setCity($city = null)
    {
        // validation for constraint: string
        if (!is_null($city) && !is_string($city)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($city, true), gettype($city)), __LINE__);
        }
        if (is_null($city) || (is_array($city) && empty($city))) {
            unset($this->City);
        } else {
            $this->City = $city;
        }
        return $this;
    }
    /**
     * Get Country value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCountry()
    {
        return isset($this->Country) ? $this->Country : null;
    }
    /**
     * Set Country value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $country
     * @return \StructType\ValidateIBANResult
     */
    public function setCountry($country = null)
    {
        // validation for constraint: string
        if (!is_null($country) && !is_string($country)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($country, true), gettype($country)), __LINE__);
        }
        if (is_null($country) || (is_array($country) && empty($country))) {
            unset($this->Country);
        } else {
            $this->Country = $country;
        }
        return $this;
    }
    /**
     * Get CountryCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCountryCode()
    {
        return isset($this->CountryCode) ? $this->CountryCode : null;
    }
    /**
     * Set CountryCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $countryCode
     * @return \StructType\ValidateIBANResult
     */
    public function setCountryCode($countryCode = null)
    {
        // validation for constraint: string
        if (!is_null($countryCode) && !is_string($countryCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($countryCode, true), gettype($countryCode)), __LINE__);
        }
        if (is_null($countryCode) || (is_array($countryCode) && empty($countryCode))) {
            unset($this->CountryCode);
        } else {
            $this->CountryCode = $countryCode;
        }
        return $this;
    }
    /**
     * Get ErrorCode value
     * @return int|null
     */
    public function getErrorCode()
    {
        return $this->ErrorCode;
    }
    /**
     * Set ErrorCode value
     * @param int $errorCode
     * @return \StructType\ValidateIBANResult
     */
    public function setErrorCode($errorCode = null)
    {
        // validation for constraint: int
        if (!is_null($errorCode) && !(is_int($errorCode) || ctype_digit($errorCode))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($errorCode, true), gettype($errorCode)), __LINE__);
        }
        $this->ErrorCode = $errorCode;
        return $this;
    }
    /**
     * Get ErrorMessage value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getErrorMessage()
    {
        return isset($this->ErrorMessage) ? $this->ErrorMessage : null;
    }
    /**
     * Set ErrorMessage value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $errorMessage
     * @return \StructType\ValidateIBANResult
     */
    public function setErrorMessage($errorMessage = null)
    {
        // validation for constraint: string
        if (!is_null($errorMessage) && !is_string($errorMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($errorMessage, true), gettype($errorMessage)), __LINE__);
        }
        if (is_null($errorMessage) || (is_array($errorMessage) && empty($errorMessage))) {
            unset($this->ErrorMessage);
        } else {
            $this->ErrorMessage = $errorMessage;
        }
        return $this;
    }
    /**
     * Get IBANNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIBANNumber()
    {
        return isset($this->IBANNumber) ? $this->IBANNumber : null;
    }
    /**
     * Set IBANNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $iBANNumber
     * @return \StructType\ValidateIBANResult
     */
    public function setIBANNumber($iBANNumber = null)
    {
        // validation for constraint: string
        if (!is_null($iBANNumber) && !is_string($iBANNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iBANNumber, true), gettype($iBANNumber)), __LINE__);
        }
        if (is_null($iBANNumber) || (is_array($iBANNumber) && empty($iBANNumber))) {
            unset($this->IBANNumber);
        } else {
            $this->IBANNumber = $iBANNumber;
        }
        return $this;
    }
    /**
     * Get RoutingCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRoutingCode()
    {
        return isset($this->RoutingCode) ? $this->RoutingCode : null;
    }
    /**
     * Set RoutingCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $routingCode
     * @return \StructType\ValidateIBANResult
     */
    public function setRoutingCode($routingCode = null)
    {
        // validation for constraint: string
        if (!is_null($routingCode) && !is_string($routingCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($routingCode, true), gettype($routingCode)), __LINE__);
        }
        if (is_null($routingCode) || (is_array($routingCode) && empty($routingCode))) {
            unset($this->RoutingCode);
        } else {
            $this->RoutingCode = $routingCode;
        }
        return $this;
    }
    /**
     * Get SwiftCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSwiftCode()
    {
        return isset($this->SwiftCode) ? $this->SwiftCode : null;
    }
    /**
     * Set SwiftCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $swiftCode
     * @return \StructType\ValidateIBANResult
     */
    public function setSwiftCode($swiftCode = null)
    {
        // validation for constraint: string
        if (!is_null($swiftCode) && !is_string($swiftCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($swiftCode, true), gettype($swiftCode)), __LINE__);
        }
        if (is_null($swiftCode) || (is_array($swiftCode) && empty($swiftCode))) {
            unset($this->SwiftCode);
        } else {
            $this->SwiftCode = $swiftCode;
        }
        return $this;
    }
    /**
     * Get Valid value
     * @return bool|null
     */
    public function getValid()
    {
        return $this->Valid;
    }
    /**
     * Set Valid value
     * @param bool $valid
     * @return \StructType\ValidateIBANResult
     */
    public function setValid($valid = null)
    {
        // validation for constraint: boolean
        if (!is_null($valid) && !is_bool($valid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($valid, true), gettype($valid)), __LINE__);
        }
        $this->Valid = $valid;
        return $this;
    }
}
