<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Quote StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:Quote
 * @subpackage Structs
 */
class Quote extends AbstractStructBase
{
    /**
     * The ExpiryTime
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ExpiryTime;
    /**
     * The ID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ID;
    /**
     * The QuoteDateTime
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $QuoteDateTime;
    /**
     * Constructor method for Quote
     * @uses Quote::setExpiryTime()
     * @uses Quote::setID()
     * @uses Quote::setQuoteDateTime()
     * @param string $expiryTime
     * @param int $iD
     * @param string $quoteDateTime
     */
    public function __construct($expiryTime = null, $iD = null, $quoteDateTime = null)
    {
        $this
            ->setExpiryTime($expiryTime)
            ->setID($iD)
            ->setQuoteDateTime($quoteDateTime);
    }
    /**
     * Get ExpiryTime value
     * @return string|null
     */
    public function getExpiryTime()
    {
        return $this->ExpiryTime;
    }
    /**
     * Set ExpiryTime value
     * @param string $expiryTime
     * @return \StructType\Quote
     */
    public function setExpiryTime($expiryTime = null)
    {
        // validation for constraint: string
        if (!is_null($expiryTime) && !is_string($expiryTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($expiryTime, true), gettype($expiryTime)), __LINE__);
        }
        $this->ExpiryTime = $expiryTime;
        return $this;
    }
    /**
     * Get ID value
     * @return int|null
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param int $iD
     * @return \StructType\Quote
     */
    public function setID($iD = null)
    {
        // validation for constraint: int
        if (!is_null($iD) && !(is_int($iD) || ctype_digit($iD))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($iD, true), gettype($iD)), __LINE__);
        }
        $this->ID = $iD;
        return $this;
    }
    /**
     * Get QuoteDateTime value
     * @return string|null
     */
    public function getQuoteDateTime()
    {
        return $this->QuoteDateTime;
    }
    /**
     * Set QuoteDateTime value
     * @param string $quoteDateTime
     * @return \StructType\Quote
     */
    public function setQuoteDateTime($quoteDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($quoteDateTime) && !is_string($quoteDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($quoteDateTime, true), gettype($quoteDateTime)), __LINE__);
        }
        $this->QuoteDateTime = $quoteDateTime;
        return $this;
    }
}
