<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PostDealResult StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:PostDealResult
 * @subpackage Structs
 */
class PostDealResult extends AbstractStructBase
{
    /**
     * The DealPostCallID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $DealPostCallID;
    /**
     * The Deals
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfDealDetails
     */
    public $Deals;
    /**
     * The ErrorCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ErrorCode;
    /**
     * The ErrorMessage
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ErrorMessage;
    /**
     * The NumberOfDeals
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $NumberOfDeals;
    /**
     * Constructor method for PostDealResult
     * @uses PostDealResult::setDealPostCallID()
     * @uses PostDealResult::setDeals()
     * @uses PostDealResult::setErrorCode()
     * @uses PostDealResult::setErrorMessage()
     * @uses PostDealResult::setNumberOfDeals()
     * @param int $dealPostCallID
     * @param \ArrayType\ArrayOfDealDetails $deals
     * @param int $errorCode
     * @param string $errorMessage
     * @param int $numberOfDeals
     */
    public function __construct($dealPostCallID = null, \ArrayType\ArrayOfDealDetails $deals = null, $errorCode = null, $errorMessage = null, $numberOfDeals = null)
    {
        $this
            ->setDealPostCallID($dealPostCallID)
            ->setDeals($deals)
            ->setErrorCode($errorCode)
            ->setErrorMessage($errorMessage)
            ->setNumberOfDeals($numberOfDeals);
    }
    /**
     * Get DealPostCallID value
     * @return int|null
     */
    public function getDealPostCallID()
    {
        return $this->DealPostCallID;
    }
    /**
     * Set DealPostCallID value
     * @param int $dealPostCallID
     * @return \StructType\PostDealResult
     */
    public function setDealPostCallID($dealPostCallID = null)
    {
        // validation for constraint: int
        if (!is_null($dealPostCallID) && !(is_int($dealPostCallID) || ctype_digit($dealPostCallID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($dealPostCallID, true), gettype($dealPostCallID)), __LINE__);
        }
        $this->DealPostCallID = $dealPostCallID;
        return $this;
    }
    /**
     * Get Deals value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfDealDetails|null
     */
    public function getDeals()
    {
        return isset($this->Deals) ? $this->Deals : null;
    }
    /**
     * Set Deals value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfDealDetails $deals
     * @return \StructType\PostDealResult
     */
    public function setDeals(\ArrayType\ArrayOfDealDetails $deals = null)
    {
        if (is_null($deals) || (is_array($deals) && empty($deals))) {
            unset($this->Deals);
        } else {
            $this->Deals = $deals;
        }
        return $this;
    }
    /**
     * Get ErrorCode value
     * @return int|null
     */
    public function getErrorCode()
    {
        return $this->ErrorCode;
    }
    /**
     * Set ErrorCode value
     * @param int $errorCode
     * @return \StructType\PostDealResult
     */
    public function setErrorCode($errorCode = null)
    {
        // validation for constraint: int
        if (!is_null($errorCode) && !(is_int($errorCode) || ctype_digit($errorCode))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($errorCode, true), gettype($errorCode)), __LINE__);
        }
        $this->ErrorCode = $errorCode;
        return $this;
    }
    /**
     * Get ErrorMessage value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getErrorMessage()
    {
        return isset($this->ErrorMessage) ? $this->ErrorMessage : null;
    }
    /**
     * Set ErrorMessage value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $errorMessage
     * @return \StructType\PostDealResult
     */
    public function setErrorMessage($errorMessage = null)
    {
        // validation for constraint: string
        if (!is_null($errorMessage) && !is_string($errorMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($errorMessage, true), gettype($errorMessage)), __LINE__);
        }
        if (is_null($errorMessage) || (is_array($errorMessage) && empty($errorMessage))) {
            unset($this->ErrorMessage);
        } else {
            $this->ErrorMessage = $errorMessage;
        }
        return $this;
    }
    /**
     * Get NumberOfDeals value
     * @return int|null
     */
    public function getNumberOfDeals()
    {
        return $this->NumberOfDeals;
    }
    /**
     * Set NumberOfDeals value
     * @param int $numberOfDeals
     * @return \StructType\PostDealResult
     */
    public function setNumberOfDeals($numberOfDeals = null)
    {
        // validation for constraint: int
        if (!is_null($numberOfDeals) && !(is_int($numberOfDeals) || ctype_digit($numberOfDeals))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numberOfDeals, true), gettype($numberOfDeals)), __LINE__);
        }
        $this->NumberOfDeals = $numberOfDeals;
        return $this;
    }
}
