<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetFundingAccountListResult StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:GetFundingAccountListResult
 * @subpackage Structs
 */
class GetFundingAccountListResult extends AbstractStructBase
{
    /**
     * The Account
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfAccountList
     */
    public $Account;
    /**
     * The ErrorCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ErrorCode;
    /**
     * The ErrorMessage
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ErrorMessage;
    /**
     * The NumberOfAccount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $NumberOfAccount;
    /**
     * Constructor method for GetFundingAccountListResult
     * @uses GetFundingAccountListResult::setAccount()
     * @uses GetFundingAccountListResult::setErrorCode()
     * @uses GetFundingAccountListResult::setErrorMessage()
     * @uses GetFundingAccountListResult::setNumberOfAccount()
     * @param \ArrayType\ArrayOfAccountList $account
     * @param int $errorCode
     * @param string $errorMessage
     * @param string $numberOfAccount
     */
    public function __construct(\ArrayType\ArrayOfAccountList $account = null, $errorCode = null, $errorMessage = null, $numberOfAccount = null)
    {
        $this
            ->setAccount($account)
            ->setErrorCode($errorCode)
            ->setErrorMessage($errorMessage)
            ->setNumberOfAccount($numberOfAccount);
    }
    /**
     * Get Account value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfAccountList|null
     */
    public function getAccount()
    {
        return isset($this->Account) ? $this->Account : null;
    }
    /**
     * Set Account value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfAccountList $account
     * @return \StructType\GetFundingAccountListResult
     */
    public function setAccount(\ArrayType\ArrayOfAccountList $account = null)
    {
        if (is_null($account) || (is_array($account) && empty($account))) {
            unset($this->Account);
        } else {
            $this->Account = $account;
        }
        return $this;
    }
    /**
     * Get ErrorCode value
     * @return int|null
     */
    public function getErrorCode()
    {
        return $this->ErrorCode;
    }
    /**
     * Set ErrorCode value
     * @param int $errorCode
     * @return \StructType\GetFundingAccountListResult
     */
    public function setErrorCode($errorCode = null)
    {
        // validation for constraint: int
        if (!is_null($errorCode) && !(is_int($errorCode) || ctype_digit($errorCode))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($errorCode, true), gettype($errorCode)), __LINE__);
        }
        $this->ErrorCode = $errorCode;
        return $this;
    }
    /**
     * Get ErrorMessage value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getErrorMessage()
    {
        return isset($this->ErrorMessage) ? $this->ErrorMessage : null;
    }
    /**
     * Set ErrorMessage value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $errorMessage
     * @return \StructType\GetFundingAccountListResult
     */
    public function setErrorMessage($errorMessage = null)
    {
        // validation for constraint: string
        if (!is_null($errorMessage) && !is_string($errorMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($errorMessage, true), gettype($errorMessage)), __LINE__);
        }
        if (is_null($errorMessage) || (is_array($errorMessage) && empty($errorMessage))) {
            unset($this->ErrorMessage);
        } else {
            $this->ErrorMessage = $errorMessage;
        }
        return $this;
    }
    /**
     * Get NumberOfAccount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNumberOfAccount()
    {
        return isset($this->NumberOfAccount) ? $this->NumberOfAccount : null;
    }
    /**
     * Set NumberOfAccount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $numberOfAccount
     * @return \StructType\GetFundingAccountListResult
     */
    public function setNumberOfAccount($numberOfAccount = null)
    {
        // validation for constraint: string
        if (!is_null($numberOfAccount) && !is_string($numberOfAccount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($numberOfAccount, true), gettype($numberOfAccount)), __LINE__);
        }
        if (is_null($numberOfAccount) || (is_array($numberOfAccount) && empty($numberOfAccount))) {
            unset($this->NumberOfAccount);
        } else {
            $this->NumberOfAccount = $numberOfAccount;
        }
        return $this;
    }
}
