<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetAccountActivityResult_0_0_1 StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:GetAccountActivityResult_0_0_1
 * @subpackage Structs
 */
class GetAccountActivityResult_0_0_1 extends AbstractStructBase
{
    /**
     * The AccountNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AccountNumber;
    /**
     * The Days
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Days;
    /**
     * The DealId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DealId;
    /**
     * The ErrorCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ErrorCode;
    /**
     * The ErrorMessage
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ErrorMessage;
    /**
     * The Factor
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Factor;
    /**
     * The Month
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Month;
    /**
     * The NumberOfTransaction
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $NumberOfTransaction;
    /**
     * The Transaction
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfTransactionDetails_0_0_1
     */
    public $Transaction;
    /**
     * The TransactionType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $TransactionType;
    /**
     * The Year
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Year;
    /**
     * Constructor method for GetAccountActivityResult_0_0_1
     * @uses GetAccountActivityResult_0_0_1::setAccountNumber()
     * @uses GetAccountActivityResult_0_0_1::setDays()
     * @uses GetAccountActivityResult_0_0_1::setDealId()
     * @uses GetAccountActivityResult_0_0_1::setErrorCode()
     * @uses GetAccountActivityResult_0_0_1::setErrorMessage()
     * @uses GetAccountActivityResult_0_0_1::setFactor()
     * @uses GetAccountActivityResult_0_0_1::setMonth()
     * @uses GetAccountActivityResult_0_0_1::setNumberOfTransaction()
     * @uses GetAccountActivityResult_0_0_1::setTransaction()
     * @uses GetAccountActivityResult_0_0_1::setTransactionType()
     * @uses GetAccountActivityResult_0_0_1::setYear()
     * @param string $accountNumber
     * @param int $days
     * @param string $dealId
     * @param int $errorCode
     * @param string $errorMessage
     * @param int $factor
     * @param int $month
     * @param int $numberOfTransaction
     * @param \ArrayType\ArrayOfTransactionDetails_0_0_1 $transaction
     * @param int $transactionType
     * @param int $year
     */
    public function __construct($accountNumber = null, $days = null, $dealId = null, $errorCode = null, $errorMessage = null, $factor = null, $month = null, $numberOfTransaction = null, \ArrayType\ArrayOfTransactionDetails_0_0_1 $transaction = null, $transactionType = null, $year = null)
    {
        $this
            ->setAccountNumber($accountNumber)
            ->setDays($days)
            ->setDealId($dealId)
            ->setErrorCode($errorCode)
            ->setErrorMessage($errorMessage)
            ->setFactor($factor)
            ->setMonth($month)
            ->setNumberOfTransaction($numberOfTransaction)
            ->setTransaction($transaction)
            ->setTransactionType($transactionType)
            ->setYear($year);
    }
    /**
     * Get AccountNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAccountNumber()
    {
        return isset($this->AccountNumber) ? $this->AccountNumber : null;
    }
    /**
     * Set AccountNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $accountNumber
     * @return \StructType\GetAccountActivityResult_0_0_1
     */
    public function setAccountNumber($accountNumber = null)
    {
        // validation for constraint: string
        if (!is_null($accountNumber) && !is_string($accountNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accountNumber, true), gettype($accountNumber)), __LINE__);
        }
        if (is_null($accountNumber) || (is_array($accountNumber) && empty($accountNumber))) {
            unset($this->AccountNumber);
        } else {
            $this->AccountNumber = $accountNumber;
        }
        return $this;
    }
    /**
     * Get Days value
     * @return int|null
     */
    public function getDays()
    {
        return $this->Days;
    }
    /**
     * Set Days value
     * @param int $days
     * @return \StructType\GetAccountActivityResult_0_0_1
     */
    public function setDays($days = null)
    {
        // validation for constraint: int
        if (!is_null($days) && !(is_int($days) || ctype_digit($days))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($days, true), gettype($days)), __LINE__);
        }
        $this->Days = $days;
        return $this;
    }
    /**
     * Get DealId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDealId()
    {
        return isset($this->DealId) ? $this->DealId : null;
    }
    /**
     * Set DealId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dealId
     * @return \StructType\GetAccountActivityResult_0_0_1
     */
    public function setDealId($dealId = null)
    {
        // validation for constraint: string
        if (!is_null($dealId) && !is_string($dealId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dealId, true), gettype($dealId)), __LINE__);
        }
        if (is_null($dealId) || (is_array($dealId) && empty($dealId))) {
            unset($this->DealId);
        } else {
            $this->DealId = $dealId;
        }
        return $this;
    }
    /**
     * Get ErrorCode value
     * @return int|null
     */
    public function getErrorCode()
    {
        return $this->ErrorCode;
    }
    /**
     * Set ErrorCode value
     * @param int $errorCode
     * @return \StructType\GetAccountActivityResult_0_0_1
     */
    public function setErrorCode($errorCode = null)
    {
        // validation for constraint: int
        if (!is_null($errorCode) && !(is_int($errorCode) || ctype_digit($errorCode))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($errorCode, true), gettype($errorCode)), __LINE__);
        }
        $this->ErrorCode = $errorCode;
        return $this;
    }
    /**
     * Get ErrorMessage value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getErrorMessage()
    {
        return isset($this->ErrorMessage) ? $this->ErrorMessage : null;
    }
    /**
     * Set ErrorMessage value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $errorMessage
     * @return \StructType\GetAccountActivityResult_0_0_1
     */
    public function setErrorMessage($errorMessage = null)
    {
        // validation for constraint: string
        if (!is_null($errorMessage) && !is_string($errorMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($errorMessage, true), gettype($errorMessage)), __LINE__);
        }
        if (is_null($errorMessage) || (is_array($errorMessage) && empty($errorMessage))) {
            unset($this->ErrorMessage);
        } else {
            $this->ErrorMessage = $errorMessage;
        }
        return $this;
    }
    /**
     * Get Factor value
     * @return int|null
     */
    public function getFactor()
    {
        return $this->Factor;
    }
    /**
     * Set Factor value
     * @param int $factor
     * @return \StructType\GetAccountActivityResult_0_0_1
     */
    public function setFactor($factor = null)
    {
        // validation for constraint: int
        if (!is_null($factor) && !(is_int($factor) || ctype_digit($factor))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($factor, true), gettype($factor)), __LINE__);
        }
        $this->Factor = $factor;
        return $this;
    }
    /**
     * Get Month value
     * @return int|null
     */
    public function getMonth()
    {
        return $this->Month;
    }
    /**
     * Set Month value
     * @param int $month
     * @return \StructType\GetAccountActivityResult_0_0_1
     */
    public function setMonth($month = null)
    {
        // validation for constraint: int
        if (!is_null($month) && !(is_int($month) || ctype_digit($month))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($month, true), gettype($month)), __LINE__);
        }
        $this->Month = $month;
        return $this;
    }
    /**
     * Get NumberOfTransaction value
     * @return int|null
     */
    public function getNumberOfTransaction()
    {
        return $this->NumberOfTransaction;
    }
    /**
     * Set NumberOfTransaction value
     * @param int $numberOfTransaction
     * @return \StructType\GetAccountActivityResult_0_0_1
     */
    public function setNumberOfTransaction($numberOfTransaction = null)
    {
        // validation for constraint: int
        if (!is_null($numberOfTransaction) && !(is_int($numberOfTransaction) || ctype_digit($numberOfTransaction))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numberOfTransaction, true), gettype($numberOfTransaction)), __LINE__);
        }
        $this->NumberOfTransaction = $numberOfTransaction;
        return $this;
    }
    /**
     * Get Transaction value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfTransactionDetails_0_0_1|null
     */
    public function getTransaction()
    {
        return isset($this->Transaction) ? $this->Transaction : null;
    }
    /**
     * Set Transaction value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfTransactionDetails_0_0_1 $transaction
     * @return \StructType\GetAccountActivityResult_0_0_1
     */
    public function setTransaction(\ArrayType\ArrayOfTransactionDetails_0_0_1 $transaction = null)
    {
        if (is_null($transaction) || (is_array($transaction) && empty($transaction))) {
            unset($this->Transaction);
        } else {
            $this->Transaction = $transaction;
        }
        return $this;
    }
    /**
     * Get TransactionType value
     * @return int|null
     */
    public function getTransactionType()
    {
        return $this->TransactionType;
    }
    /**
     * Set TransactionType value
     * @param int $transactionType
     * @return \StructType\GetAccountActivityResult_0_0_1
     */
    public function setTransactionType($transactionType = null)
    {
        // validation for constraint: int
        if (!is_null($transactionType) && !(is_int($transactionType) || ctype_digit($transactionType))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($transactionType, true), gettype($transactionType)), __LINE__);
        }
        $this->TransactionType = $transactionType;
        return $this;
    }
    /**
     * Get Year value
     * @return int|null
     */
    public function getYear()
    {
        return $this->Year;
    }
    /**
     * Set Year value
     * @param int $year
     * @return \StructType\GetAccountActivityResult_0_0_1
     */
    public function setYear($year = null)
    {
        // validation for constraint: int
        if (!is_null($year) && !(is_int($year) || ctype_digit($year))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($year, true), gettype($year)), __LINE__);
        }
        $this->Year = $year;
        return $this;
    }
}
