<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Delete ServiceType
 * @subpackage Services
 */
class Delete extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named DeletePayee
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\DeletePayee $parameters
     * @return \StructType\DeletePayeeResponse|bool
     */
    public function DeletePayee(\StructType\DeletePayee $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->DeletePayee($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named DeletePendingDealById
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\DeletePendingDealById $parameters
     * @return \StructType\DeletePendingDealByIdResponse|bool
     */
    public function DeletePendingDealById(\StructType\DeletePendingDealById $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->DeletePendingDealById($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\DeletePayeeResponse|\StructType\DeletePendingDealByIdResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
