<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DealDetail StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:DealDetail
 * @subpackage Structs
 */
class DealDetail extends AbstractStructBase
{
    /**
     * The Direction
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Direction;
    /**
     * The Fee
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $Fee;
    /**
     * The FxAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $FxAmount;
    /**
     * The FxCurrencyID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FxCurrencyID;
    /**
     * The InternalNotes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $InternalNotes;
    /**
     * The NotesToPayee
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $NotesToPayee;
    /**
     * The PaymentMethod
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PaymentMethod;
    /**
     * The PaymentSequenceNo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $PaymentSequenceNo;
    /**
     * The Rate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $Rate;
    /**
     * The SettlementAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $SettlementAmount;
    /**
     * The SettlementCurrencyID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SettlementCurrencyID;
    /**
     * The TotalSettlementAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $TotalSettlementAmount;
    /**
     * The payee
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Payee
     */
    public $payee;
    /**
     * Constructor method for DealDetail
     * @uses DealDetail::setDirection()
     * @uses DealDetail::setFee()
     * @uses DealDetail::setFxAmount()
     * @uses DealDetail::setFxCurrencyID()
     * @uses DealDetail::setInternalNotes()
     * @uses DealDetail::setNotesToPayee()
     * @uses DealDetail::setPaymentMethod()
     * @uses DealDetail::setPaymentSequenceNo()
     * @uses DealDetail::setRate()
     * @uses DealDetail::setSettlementAmount()
     * @uses DealDetail::setSettlementCurrencyID()
     * @uses DealDetail::setTotalSettlementAmount()
     * @uses DealDetail::setPayee()
     * @param string $direction
     * @param float $fee
     * @param float $fxAmount
     * @param string $fxCurrencyID
     * @param string $internalNotes
     * @param string $notesToPayee
     * @param string $paymentMethod
     * @param int $paymentSequenceNo
     * @param float $rate
     * @param float $settlementAmount
     * @param string $settlementCurrencyID
     * @param float $totalSettlementAmount
     * @param \StructType\Payee $payee
     */
    public function __construct($direction = null, $fee = null, $fxAmount = null, $fxCurrencyID = null, $internalNotes = null, $notesToPayee = null, $paymentMethod = null, $paymentSequenceNo = null, $rate = null, $settlementAmount = null, $settlementCurrencyID = null, $totalSettlementAmount = null, \StructType\Payee $payee = null)
    {
        $this
            ->setDirection($direction)
            ->setFee($fee)
            ->setFxAmount($fxAmount)
            ->setFxCurrencyID($fxCurrencyID)
            ->setInternalNotes($internalNotes)
            ->setNotesToPayee($notesToPayee)
            ->setPaymentMethod($paymentMethod)
            ->setPaymentSequenceNo($paymentSequenceNo)
            ->setRate($rate)
            ->setSettlementAmount($settlementAmount)
            ->setSettlementCurrencyID($settlementCurrencyID)
            ->setTotalSettlementAmount($totalSettlementAmount)
            ->setPayee($payee);
    }
    /**
     * Get Direction value
     * @return string|null
     */
    public function getDirection()
    {
        return $this->Direction;
    }
    /**
     * Set Direction value
     * @uses \EnumType\Direction::valueIsValid()
     * @uses \EnumType\Direction::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $direction
     * @return \StructType\DealDetail
     */
    public function setDirection($direction = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Direction::valueIsValid($direction)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\Direction', is_array($direction) ? implode(', ', $direction) : var_export($direction, true), implode(', ', \EnumType\Direction::getValidValues())), __LINE__);
        }
        $this->Direction = $direction;
        return $this;
    }
    /**
     * Get Fee value
     * @return float|null
     */
    public function getFee()
    {
        return $this->Fee;
    }
    /**
     * Set Fee value
     * @param float $fee
     * @return \StructType\DealDetail
     */
    public function setFee($fee = null)
    {
        // validation for constraint: float
        if (!is_null($fee) && !(is_float($fee) || is_numeric($fee))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($fee, true), gettype($fee)), __LINE__);
        }
        $this->Fee = $fee;
        return $this;
    }
    /**
     * Get FxAmount value
     * @return float|null
     */
    public function getFxAmount()
    {
        return $this->FxAmount;
    }
    /**
     * Set FxAmount value
     * @param float $fxAmount
     * @return \StructType\DealDetail
     */
    public function setFxAmount($fxAmount = null)
    {
        // validation for constraint: float
        if (!is_null($fxAmount) && !(is_float($fxAmount) || is_numeric($fxAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($fxAmount, true), gettype($fxAmount)), __LINE__);
        }
        $this->FxAmount = $fxAmount;
        return $this;
    }
    /**
     * Get FxCurrencyID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFxCurrencyID()
    {
        return isset($this->FxCurrencyID) ? $this->FxCurrencyID : null;
    }
    /**
     * Set FxCurrencyID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $fxCurrencyID
     * @return \StructType\DealDetail
     */
    public function setFxCurrencyID($fxCurrencyID = null)
    {
        // validation for constraint: string
        if (!is_null($fxCurrencyID) && !is_string($fxCurrencyID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fxCurrencyID, true), gettype($fxCurrencyID)), __LINE__);
        }
        if (is_null($fxCurrencyID) || (is_array($fxCurrencyID) && empty($fxCurrencyID))) {
            unset($this->FxCurrencyID);
        } else {
            $this->FxCurrencyID = $fxCurrencyID;
        }
        return $this;
    }
    /**
     * Get InternalNotes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInternalNotes()
    {
        return isset($this->InternalNotes) ? $this->InternalNotes : null;
    }
    /**
     * Set InternalNotes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $internalNotes
     * @return \StructType\DealDetail
     */
    public function setInternalNotes($internalNotes = null)
    {
        // validation for constraint: string
        if (!is_null($internalNotes) && !is_string($internalNotes)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($internalNotes, true), gettype($internalNotes)), __LINE__);
        }
        if (is_null($internalNotes) || (is_array($internalNotes) && empty($internalNotes))) {
            unset($this->InternalNotes);
        } else {
            $this->InternalNotes = $internalNotes;
        }
        return $this;
    }
    /**
     * Get NotesToPayee value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNotesToPayee()
    {
        return isset($this->NotesToPayee) ? $this->NotesToPayee : null;
    }
    /**
     * Set NotesToPayee value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $notesToPayee
     * @return \StructType\DealDetail
     */
    public function setNotesToPayee($notesToPayee = null)
    {
        // validation for constraint: string
        if (!is_null($notesToPayee) && !is_string($notesToPayee)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($notesToPayee, true), gettype($notesToPayee)), __LINE__);
        }
        if (is_null($notesToPayee) || (is_array($notesToPayee) && empty($notesToPayee))) {
            unset($this->NotesToPayee);
        } else {
            $this->NotesToPayee = $notesToPayee;
        }
        return $this;
    }
    /**
     * Get PaymentMethod value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPaymentMethod()
    {
        return isset($this->PaymentMethod) ? $this->PaymentMethod : null;
    }
    /**
     * Set PaymentMethod value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $paymentMethod
     * @return \StructType\DealDetail
     */
    public function setPaymentMethod($paymentMethod = null)
    {
        // validation for constraint: string
        if (!is_null($paymentMethod) && !is_string($paymentMethod)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentMethod, true), gettype($paymentMethod)), __LINE__);
        }
        if (is_null($paymentMethod) || (is_array($paymentMethod) && empty($paymentMethod))) {
            unset($this->PaymentMethod);
        } else {
            $this->PaymentMethod = $paymentMethod;
        }
        return $this;
    }
    /**
     * Get PaymentSequenceNo value
     * @return int|null
     */
    public function getPaymentSequenceNo()
    {
        return $this->PaymentSequenceNo;
    }
    /**
     * Set PaymentSequenceNo value
     * @param int $paymentSequenceNo
     * @return \StructType\DealDetail
     */
    public function setPaymentSequenceNo($paymentSequenceNo = null)
    {
        // validation for constraint: int
        if (!is_null($paymentSequenceNo) && !(is_int($paymentSequenceNo) || ctype_digit($paymentSequenceNo))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($paymentSequenceNo, true), gettype($paymentSequenceNo)), __LINE__);
        }
        $this->PaymentSequenceNo = $paymentSequenceNo;
        return $this;
    }
    /**
     * Get Rate value
     * @return float|null
     */
    public function getRate()
    {
        return $this->Rate;
    }
    /**
     * Set Rate value
     * @param float $rate
     * @return \StructType\DealDetail
     */
    public function setRate($rate = null)
    {
        // validation for constraint: float
        if (!is_null($rate) && !(is_float($rate) || is_numeric($rate))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($rate, true), gettype($rate)), __LINE__);
        }
        $this->Rate = $rate;
        return $this;
    }
    /**
     * Get SettlementAmount value
     * @return float|null
     */
    public function getSettlementAmount()
    {
        return $this->SettlementAmount;
    }
    /**
     * Set SettlementAmount value
     * @param float $settlementAmount
     * @return \StructType\DealDetail
     */
    public function setSettlementAmount($settlementAmount = null)
    {
        // validation for constraint: float
        if (!is_null($settlementAmount) && !(is_float($settlementAmount) || is_numeric($settlementAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($settlementAmount, true), gettype($settlementAmount)), __LINE__);
        }
        $this->SettlementAmount = $settlementAmount;
        return $this;
    }
    /**
     * Get SettlementCurrencyID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSettlementCurrencyID()
    {
        return isset($this->SettlementCurrencyID) ? $this->SettlementCurrencyID : null;
    }
    /**
     * Set SettlementCurrencyID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $settlementCurrencyID
     * @return \StructType\DealDetail
     */
    public function setSettlementCurrencyID($settlementCurrencyID = null)
    {
        // validation for constraint: string
        if (!is_null($settlementCurrencyID) && !is_string($settlementCurrencyID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($settlementCurrencyID, true), gettype($settlementCurrencyID)), __LINE__);
        }
        if (is_null($settlementCurrencyID) || (is_array($settlementCurrencyID) && empty($settlementCurrencyID))) {
            unset($this->SettlementCurrencyID);
        } else {
            $this->SettlementCurrencyID = $settlementCurrencyID;
        }
        return $this;
    }
    /**
     * Get TotalSettlementAmount value
     * @return float|null
     */
    public function getTotalSettlementAmount()
    {
        return $this->TotalSettlementAmount;
    }
    /**
     * Set TotalSettlementAmount value
     * @param float $totalSettlementAmount
     * @return \StructType\DealDetail
     */
    public function setTotalSettlementAmount($totalSettlementAmount = null)
    {
        // validation for constraint: float
        if (!is_null($totalSettlementAmount) && !(is_float($totalSettlementAmount) || is_numeric($totalSettlementAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($totalSettlementAmount, true), gettype($totalSettlementAmount)), __LINE__);
        }
        $this->TotalSettlementAmount = $totalSettlementAmount;
        return $this;
    }
    /**
     * Get payee value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Payee|null
     */
    public function getPayee()
    {
        return isset($this->payee) ? $this->payee : null;
    }
    /**
     * Set payee value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Payee $payee
     * @return \StructType\DealDetail
     */
    public function setPayee(\StructType\Payee $payee = null)
    {
        if (is_null($payee) || (is_array($payee) && empty($payee))) {
            unset($this->payee);
        } else {
            $this->payee = $payee;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DealDetail
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
