<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SubmitDealResult_0_0_1 StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:SubmitDealResult_0_0_1
 * @subpackage Structs
 */
class SubmitDealResult_0_0_1 extends AbstractStructBase
{
    /**
     * The DealID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DealID;
    /**
     * The ErrorCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ErrorCode;
    /**
     * The ErrorMessage
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ErrorMessage;
    /**
     * The PaymentDetail
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfDealDetail
     */
    public $PaymentDetail;
    /**
     * The TotalNumberOfPayment
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $TotalNumberOfPayment;
    /**
     * Constructor method for SubmitDealResult_0_0_1
     * @uses SubmitDealResult_0_0_1::setDealID()
     * @uses SubmitDealResult_0_0_1::setErrorCode()
     * @uses SubmitDealResult_0_0_1::setErrorMessage()
     * @uses SubmitDealResult_0_0_1::setPaymentDetail()
     * @uses SubmitDealResult_0_0_1::setTotalNumberOfPayment()
     * @param string $dealID
     * @param int $errorCode
     * @param string $errorMessage
     * @param \ArrayType\ArrayOfDealDetail $paymentDetail
     * @param int $totalNumberOfPayment
     */
    public function __construct($dealID = null, $errorCode = null, $errorMessage = null, \ArrayType\ArrayOfDealDetail $paymentDetail = null, $totalNumberOfPayment = null)
    {
        $this
            ->setDealID($dealID)
            ->setErrorCode($errorCode)
            ->setErrorMessage($errorMessage)
            ->setPaymentDetail($paymentDetail)
            ->setTotalNumberOfPayment($totalNumberOfPayment);
    }
    /**
     * Get DealID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDealID()
    {
        return isset($this->DealID) ? $this->DealID : null;
    }
    /**
     * Set DealID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dealID
     * @return \StructType\SubmitDealResult_0_0_1
     */
    public function setDealID($dealID = null)
    {
        // validation for constraint: string
        if (!is_null($dealID) && !is_string($dealID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dealID, true), gettype($dealID)), __LINE__);
        }
        if (is_null($dealID) || (is_array($dealID) && empty($dealID))) {
            unset($this->DealID);
        } else {
            $this->DealID = $dealID;
        }
        return $this;
    }
    /**
     * Get ErrorCode value
     * @return int|null
     */
    public function getErrorCode()
    {
        return $this->ErrorCode;
    }
    /**
     * Set ErrorCode value
     * @param int $errorCode
     * @return \StructType\SubmitDealResult_0_0_1
     */
    public function setErrorCode($errorCode = null)
    {
        // validation for constraint: int
        if (!is_null($errorCode) && !(is_int($errorCode) || ctype_digit($errorCode))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($errorCode, true), gettype($errorCode)), __LINE__);
        }
        $this->ErrorCode = $errorCode;
        return $this;
    }
    /**
     * Get ErrorMessage value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getErrorMessage()
    {
        return isset($this->ErrorMessage) ? $this->ErrorMessage : null;
    }
    /**
     * Set ErrorMessage value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $errorMessage
     * @return \StructType\SubmitDealResult_0_0_1
     */
    public function setErrorMessage($errorMessage = null)
    {
        // validation for constraint: string
        if (!is_null($errorMessage) && !is_string($errorMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($errorMessage, true), gettype($errorMessage)), __LINE__);
        }
        if (is_null($errorMessage) || (is_array($errorMessage) && empty($errorMessage))) {
            unset($this->ErrorMessage);
        } else {
            $this->ErrorMessage = $errorMessage;
        }
        return $this;
    }
    /**
     * Get PaymentDetail value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfDealDetail|null
     */
    public function getPaymentDetail()
    {
        return isset($this->PaymentDetail) ? $this->PaymentDetail : null;
    }
    /**
     * Set PaymentDetail value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfDealDetail $paymentDetail
     * @return \StructType\SubmitDealResult_0_0_1
     */
    public function setPaymentDetail(\ArrayType\ArrayOfDealDetail $paymentDetail = null)
    {
        if (is_null($paymentDetail) || (is_array($paymentDetail) && empty($paymentDetail))) {
            unset($this->PaymentDetail);
        } else {
            $this->PaymentDetail = $paymentDetail;
        }
        return $this;
    }
    /**
     * Get TotalNumberOfPayment value
     * @return int|null
     */
    public function getTotalNumberOfPayment()
    {
        return $this->TotalNumberOfPayment;
    }
    /**
     * Set TotalNumberOfPayment value
     * @param int $totalNumberOfPayment
     * @return \StructType\SubmitDealResult_0_0_1
     */
    public function setTotalNumberOfPayment($totalNumberOfPayment = null)
    {
        // validation for constraint: int
        if (!is_null($totalNumberOfPayment) && !(is_int($totalNumberOfPayment) || ctype_digit($totalNumberOfPayment))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($totalNumberOfPayment, true), gettype($totalNumberOfPayment)), __LINE__);
        }
        $this->TotalNumberOfPayment = $totalNumberOfPayment;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SubmitDealResult_0_0_1
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
