<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ValidateRoutingCodeRequest StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ValidateRoutingCodeRequest
 * @subpackage Structs
 */
class ValidateRoutingCodeRequest extends AbstractStructBase
{
    /**
     * The CountryCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CountryCode;
    /**
     * The CurrencyCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CurrencyCode;
    /**
     * The MethodID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $MethodID;
    /**
     * The OrgID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OrgID;
    /**
     * The RoutingCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RoutingCode;
    /**
     * The RoutingType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RoutingType;
    /**
     * Constructor method for ValidateRoutingCodeRequest
     * @uses ValidateRoutingCodeRequest::setCountryCode()
     * @uses ValidateRoutingCodeRequest::setCurrencyCode()
     * @uses ValidateRoutingCodeRequest::setMethodID()
     * @uses ValidateRoutingCodeRequest::setOrgID()
     * @uses ValidateRoutingCodeRequest::setRoutingCode()
     * @uses ValidateRoutingCodeRequest::setRoutingType()
     * @param string $countryCode
     * @param string $currencyCode
     * @param string $methodID
     * @param string $orgID
     * @param string $routingCode
     * @param string $routingType
     */
    public function __construct($countryCode = null, $currencyCode = null, $methodID = null, $orgID = null, $routingCode = null, $routingType = null)
    {
        $this
            ->setCountryCode($countryCode)
            ->setCurrencyCode($currencyCode)
            ->setMethodID($methodID)
            ->setOrgID($orgID)
            ->setRoutingCode($routingCode)
            ->setRoutingType($routingType);
    }
    /**
     * Get CountryCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCountryCode()
    {
        return isset($this->CountryCode) ? $this->CountryCode : null;
    }
    /**
     * Set CountryCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $countryCode
     * @return \StructType\ValidateRoutingCodeRequest
     */
    public function setCountryCode($countryCode = null)
    {
        // validation for constraint: string
        if (!is_null($countryCode) && !is_string($countryCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($countryCode, true), gettype($countryCode)), __LINE__);
        }
        if (is_null($countryCode) || (is_array($countryCode) && empty($countryCode))) {
            unset($this->CountryCode);
        } else {
            $this->CountryCode = $countryCode;
        }
        return $this;
    }
    /**
     * Get CurrencyCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCurrencyCode()
    {
        return isset($this->CurrencyCode) ? $this->CurrencyCode : null;
    }
    /**
     * Set CurrencyCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $currencyCode
     * @return \StructType\ValidateRoutingCodeRequest
     */
    public function setCurrencyCode($currencyCode = null)
    {
        // validation for constraint: string
        if (!is_null($currencyCode) && !is_string($currencyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currencyCode, true), gettype($currencyCode)), __LINE__);
        }
        if (is_null($currencyCode) || (is_array($currencyCode) && empty($currencyCode))) {
            unset($this->CurrencyCode);
        } else {
            $this->CurrencyCode = $currencyCode;
        }
        return $this;
    }
    /**
     * Get MethodID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMethodID()
    {
        return isset($this->MethodID) ? $this->MethodID : null;
    }
    /**
     * Set MethodID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $methodID
     * @return \StructType\ValidateRoutingCodeRequest
     */
    public function setMethodID($methodID = null)
    {
        // validation for constraint: string
        if (!is_null($methodID) && !is_string($methodID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($methodID, true), gettype($methodID)), __LINE__);
        }
        if (is_null($methodID) || (is_array($methodID) && empty($methodID))) {
            unset($this->MethodID);
        } else {
            $this->MethodID = $methodID;
        }
        return $this;
    }
    /**
     * Get OrgID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrgID()
    {
        return isset($this->OrgID) ? $this->OrgID : null;
    }
    /**
     * Set OrgID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $orgID
     * @return \StructType\ValidateRoutingCodeRequest
     */
    public function setOrgID($orgID = null)
    {
        // validation for constraint: string
        if (!is_null($orgID) && !is_string($orgID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($orgID, true), gettype($orgID)), __LINE__);
        }
        if (is_null($orgID) || (is_array($orgID) && empty($orgID))) {
            unset($this->OrgID);
        } else {
            $this->OrgID = $orgID;
        }
        return $this;
    }
    /**
     * Get RoutingCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRoutingCode()
    {
        return isset($this->RoutingCode) ? $this->RoutingCode : null;
    }
    /**
     * Set RoutingCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $routingCode
     * @return \StructType\ValidateRoutingCodeRequest
     */
    public function setRoutingCode($routingCode = null)
    {
        // validation for constraint: string
        if (!is_null($routingCode) && !is_string($routingCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($routingCode, true), gettype($routingCode)), __LINE__);
        }
        if (is_null($routingCode) || (is_array($routingCode) && empty($routingCode))) {
            unset($this->RoutingCode);
        } else {
            $this->RoutingCode = $routingCode;
        }
        return $this;
    }
    /**
     * Get RoutingType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRoutingType()
    {
        return isset($this->RoutingType) ? $this->RoutingType : null;
    }
    /**
     * Set RoutingType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $routingType
     * @return \StructType\ValidateRoutingCodeRequest
     */
    public function setRoutingType($routingType = null)
    {
        // validation for constraint: string
        if (!is_null($routingType) && !is_string($routingType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($routingType, true), gettype($routingType)), __LINE__);
        }
        if (is_null($routingType) || (is_array($routingType) && empty($routingType))) {
            unset($this->RoutingType);
        } else {
            $this->RoutingType = $routingType;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ValidateRoutingCodeRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
