<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PayeeDetail StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:PayeeDetail
 * @subpackage Structs
 */
class PayeeDetail extends AbstractStructBase
{
    /**
     * The CurrencyID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CurrencyID;
    /**
     * The OriginatorAccountNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OriginatorAccountNumber;
    /**
     * The OriginatorAddress1
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OriginatorAddress1;
    /**
     * The OriginatorAddress2
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OriginatorAddress2;
    /**
     * The OriginatorCity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OriginatorCity;
    /**
     * The OriginatorCountryID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OriginatorCountryID;
    /**
     * The OriginatorID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OriginatorID;
    /**
     * The OriginatorName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OriginatorName;
    /**
     * The OriginatorPostalCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OriginatorPostalCode;
    /**
     * The OriginatorProvince
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OriginatorProvince;
    /**
     * The OriginatorType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OriginatorType;
    /**
     * The PayeeAccountIBANNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PayeeAccountIBANNumber;
    /**
     * The PayeeAddress1
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PayeeAddress1;
    /**
     * The PayeeAddress2
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PayeeAddress2;
    /**
     * The PayeeBankAddress1
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PayeeBankAddress1;
    /**
     * The PayeeBankAddress2
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PayeeBankAddress2;
    /**
     * The PayeeBankBankCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PayeeBankBankCode;
    /**
     * The PayeeBankCity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PayeeBankCity;
    /**
     * The PayeeBankCountryID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PayeeBankCountryID;
    /**
     * The PayeeBankName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PayeeBankName;
    /**
     * The PayeeBankPostalCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PayeeBankPostalCode;
    /**
     * The PayeeBankProvince
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PayeeBankProvince;
    /**
     * The PayeeBankRoutingCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PayeeBankRoutingCode;
    /**
     * The PayeeBankRoutingType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PayeeBankRoutingType;
    /**
     * The PayeeBankSwiftCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PayeeBankSwiftCode;
    /**
     * The PayeeCity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PayeeCity;
    /**
     * The PayeeCountryID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PayeeCountryID;
    /**
     * The PayeeEmail
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PayeeEmail;
    /**
     * The PayeeID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $PayeeID;
    /**
     * The PayeeInterBankAddress1
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PayeeInterBankAddress1;
    /**
     * The PayeeInterBankAddress2
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PayeeInterBankAddress2;
    /**
     * The PayeeInterBankBankCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PayeeInterBankBankCode;
    /**
     * The PayeeInterBankCity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PayeeInterBankCity;
    /**
     * The PayeeInterBankCountryID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PayeeInterBankCountryID;
    /**
     * The PayeeInterBankName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PayeeInterBankName;
    /**
     * The PayeeInterBankPostalCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PayeeInterBankPostalCode;
    /**
     * The PayeeInterBankProvince
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PayeeInterBankProvince;
    /**
     * The PayeeInterBankRoutingCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PayeeInterBankRoutingCode;
    /**
     * The PayeeInterBankRoutingCodeType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PayeeInterBankRoutingCodeType;
    /**
     * The PayeeInternalReference
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PayeeInternalReference;
    /**
     * The PayeeName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PayeeName;
    /**
     * The PayeePostalCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PayeePostalCode;
    /**
     * The PayeeProvince
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PayeeProvince;
    /**
     * The PayeeReference
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PayeeReference;
    /**
     * The PayeeSendingBankInstructions
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PayeeSendingBankInstructions;
    /**
     * The PaymentMethod
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PaymentMethod;
    /**
     * Constructor method for PayeeDetail
     * @uses PayeeDetail::setCurrencyID()
     * @uses PayeeDetail::setOriginatorAccountNumber()
     * @uses PayeeDetail::setOriginatorAddress1()
     * @uses PayeeDetail::setOriginatorAddress2()
     * @uses PayeeDetail::setOriginatorCity()
     * @uses PayeeDetail::setOriginatorCountryID()
     * @uses PayeeDetail::setOriginatorID()
     * @uses PayeeDetail::setOriginatorName()
     * @uses PayeeDetail::setOriginatorPostalCode()
     * @uses PayeeDetail::setOriginatorProvince()
     * @uses PayeeDetail::setOriginatorType()
     * @uses PayeeDetail::setPayeeAccountIBANNumber()
     * @uses PayeeDetail::setPayeeAddress1()
     * @uses PayeeDetail::setPayeeAddress2()
     * @uses PayeeDetail::setPayeeBankAddress1()
     * @uses PayeeDetail::setPayeeBankAddress2()
     * @uses PayeeDetail::setPayeeBankBankCode()
     * @uses PayeeDetail::setPayeeBankCity()
     * @uses PayeeDetail::setPayeeBankCountryID()
     * @uses PayeeDetail::setPayeeBankName()
     * @uses PayeeDetail::setPayeeBankPostalCode()
     * @uses PayeeDetail::setPayeeBankProvince()
     * @uses PayeeDetail::setPayeeBankRoutingCode()
     * @uses PayeeDetail::setPayeeBankRoutingType()
     * @uses PayeeDetail::setPayeeBankSwiftCode()
     * @uses PayeeDetail::setPayeeCity()
     * @uses PayeeDetail::setPayeeCountryID()
     * @uses PayeeDetail::setPayeeEmail()
     * @uses PayeeDetail::setPayeeID()
     * @uses PayeeDetail::setPayeeInterBankAddress1()
     * @uses PayeeDetail::setPayeeInterBankAddress2()
     * @uses PayeeDetail::setPayeeInterBankBankCode()
     * @uses PayeeDetail::setPayeeInterBankCity()
     * @uses PayeeDetail::setPayeeInterBankCountryID()
     * @uses PayeeDetail::setPayeeInterBankName()
     * @uses PayeeDetail::setPayeeInterBankPostalCode()
     * @uses PayeeDetail::setPayeeInterBankProvince()
     * @uses PayeeDetail::setPayeeInterBankRoutingCode()
     * @uses PayeeDetail::setPayeeInterBankRoutingCodeType()
     * @uses PayeeDetail::setPayeeInternalReference()
     * @uses PayeeDetail::setPayeeName()
     * @uses PayeeDetail::setPayeePostalCode()
     * @uses PayeeDetail::setPayeeProvince()
     * @uses PayeeDetail::setPayeeReference()
     * @uses PayeeDetail::setPayeeSendingBankInstructions()
     * @uses PayeeDetail::setPaymentMethod()
     * @param string $currencyID
     * @param string $originatorAccountNumber
     * @param string $originatorAddress1
     * @param string $originatorAddress2
     * @param string $originatorCity
     * @param string $originatorCountryID
     * @param string $originatorID
     * @param string $originatorName
     * @param string $originatorPostalCode
     * @param string $originatorProvince
     * @param string $originatorType
     * @param string $payeeAccountIBANNumber
     * @param string $payeeAddress1
     * @param string $payeeAddress2
     * @param string $payeeBankAddress1
     * @param string $payeeBankAddress2
     * @param string $payeeBankBankCode
     * @param string $payeeBankCity
     * @param string $payeeBankCountryID
     * @param string $payeeBankName
     * @param string $payeeBankPostalCode
     * @param string $payeeBankProvince
     * @param string $payeeBankRoutingCode
     * @param string $payeeBankRoutingType
     * @param string $payeeBankSwiftCode
     * @param string $payeeCity
     * @param string $payeeCountryID
     * @param string $payeeEmail
     * @param int $payeeID
     * @param string $payeeInterBankAddress1
     * @param string $payeeInterBankAddress2
     * @param string $payeeInterBankBankCode
     * @param string $payeeInterBankCity
     * @param string $payeeInterBankCountryID
     * @param string $payeeInterBankName
     * @param string $payeeInterBankPostalCode
     * @param string $payeeInterBankProvince
     * @param string $payeeInterBankRoutingCode
     * @param string $payeeInterBankRoutingCodeType
     * @param string $payeeInternalReference
     * @param string $payeeName
     * @param string $payeePostalCode
     * @param string $payeeProvince
     * @param string $payeeReference
     * @param string $payeeSendingBankInstructions
     * @param string $paymentMethod
     */
    public function __construct($currencyID = null, $originatorAccountNumber = null, $originatorAddress1 = null, $originatorAddress2 = null, $originatorCity = null, $originatorCountryID = null, $originatorID = null, $originatorName = null, $originatorPostalCode = null, $originatorProvince = null, $originatorType = null, $payeeAccountIBANNumber = null, $payeeAddress1 = null, $payeeAddress2 = null, $payeeBankAddress1 = null, $payeeBankAddress2 = null, $payeeBankBankCode = null, $payeeBankCity = null, $payeeBankCountryID = null, $payeeBankName = null, $payeeBankPostalCode = null, $payeeBankProvince = null, $payeeBankRoutingCode = null, $payeeBankRoutingType = null, $payeeBankSwiftCode = null, $payeeCity = null, $payeeCountryID = null, $payeeEmail = null, $payeeID = null, $payeeInterBankAddress1 = null, $payeeInterBankAddress2 = null, $payeeInterBankBankCode = null, $payeeInterBankCity = null, $payeeInterBankCountryID = null, $payeeInterBankName = null, $payeeInterBankPostalCode = null, $payeeInterBankProvince = null, $payeeInterBankRoutingCode = null, $payeeInterBankRoutingCodeType = null, $payeeInternalReference = null, $payeeName = null, $payeePostalCode = null, $payeeProvince = null, $payeeReference = null, $payeeSendingBankInstructions = null, $paymentMethod = null)
    {
        $this
            ->setCurrencyID($currencyID)
            ->setOriginatorAccountNumber($originatorAccountNumber)
            ->setOriginatorAddress1($originatorAddress1)
            ->setOriginatorAddress2($originatorAddress2)
            ->setOriginatorCity($originatorCity)
            ->setOriginatorCountryID($originatorCountryID)
            ->setOriginatorID($originatorID)
            ->setOriginatorName($originatorName)
            ->setOriginatorPostalCode($originatorPostalCode)
            ->setOriginatorProvince($originatorProvince)
            ->setOriginatorType($originatorType)
            ->setPayeeAccountIBANNumber($payeeAccountIBANNumber)
            ->setPayeeAddress1($payeeAddress1)
            ->setPayeeAddress2($payeeAddress2)
            ->setPayeeBankAddress1($payeeBankAddress1)
            ->setPayeeBankAddress2($payeeBankAddress2)
            ->setPayeeBankBankCode($payeeBankBankCode)
            ->setPayeeBankCity($payeeBankCity)
            ->setPayeeBankCountryID($payeeBankCountryID)
            ->setPayeeBankName($payeeBankName)
            ->setPayeeBankPostalCode($payeeBankPostalCode)
            ->setPayeeBankProvince($payeeBankProvince)
            ->setPayeeBankRoutingCode($payeeBankRoutingCode)
            ->setPayeeBankRoutingType($payeeBankRoutingType)
            ->setPayeeBankSwiftCode($payeeBankSwiftCode)
            ->setPayeeCity($payeeCity)
            ->setPayeeCountryID($payeeCountryID)
            ->setPayeeEmail($payeeEmail)
            ->setPayeeID($payeeID)
            ->setPayeeInterBankAddress1($payeeInterBankAddress1)
            ->setPayeeInterBankAddress2($payeeInterBankAddress2)
            ->setPayeeInterBankBankCode($payeeInterBankBankCode)
            ->setPayeeInterBankCity($payeeInterBankCity)
            ->setPayeeInterBankCountryID($payeeInterBankCountryID)
            ->setPayeeInterBankName($payeeInterBankName)
            ->setPayeeInterBankPostalCode($payeeInterBankPostalCode)
            ->setPayeeInterBankProvince($payeeInterBankProvince)
            ->setPayeeInterBankRoutingCode($payeeInterBankRoutingCode)
            ->setPayeeInterBankRoutingCodeType($payeeInterBankRoutingCodeType)
            ->setPayeeInternalReference($payeeInternalReference)
            ->setPayeeName($payeeName)
            ->setPayeePostalCode($payeePostalCode)
            ->setPayeeProvince($payeeProvince)
            ->setPayeeReference($payeeReference)
            ->setPayeeSendingBankInstructions($payeeSendingBankInstructions)
            ->setPaymentMethod($paymentMethod);
    }
    /**
     * Get CurrencyID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCurrencyID()
    {
        return isset($this->CurrencyID) ? $this->CurrencyID : null;
    }
    /**
     * Set CurrencyID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $currencyID
     * @return \StructType\PayeeDetail
     */
    public function setCurrencyID($currencyID = null)
    {
        // validation for constraint: string
        if (!is_null($currencyID) && !is_string($currencyID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currencyID, true), gettype($currencyID)), __LINE__);
        }
        if (is_null($currencyID) || (is_array($currencyID) && empty($currencyID))) {
            unset($this->CurrencyID);
        } else {
            $this->CurrencyID = $currencyID;
        }
        return $this;
    }
    /**
     * Get OriginatorAccountNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOriginatorAccountNumber()
    {
        return isset($this->OriginatorAccountNumber) ? $this->OriginatorAccountNumber : null;
    }
    /**
     * Set OriginatorAccountNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $originatorAccountNumber
     * @return \StructType\PayeeDetail
     */
    public function setOriginatorAccountNumber($originatorAccountNumber = null)
    {
        // validation for constraint: string
        if (!is_null($originatorAccountNumber) && !is_string($originatorAccountNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($originatorAccountNumber, true), gettype($originatorAccountNumber)), __LINE__);
        }
        if (is_null($originatorAccountNumber) || (is_array($originatorAccountNumber) && empty($originatorAccountNumber))) {
            unset($this->OriginatorAccountNumber);
        } else {
            $this->OriginatorAccountNumber = $originatorAccountNumber;
        }
        return $this;
    }
    /**
     * Get OriginatorAddress1 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOriginatorAddress1()
    {
        return isset($this->OriginatorAddress1) ? $this->OriginatorAddress1 : null;
    }
    /**
     * Set OriginatorAddress1 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $originatorAddress1
     * @return \StructType\PayeeDetail
     */
    public function setOriginatorAddress1($originatorAddress1 = null)
    {
        // validation for constraint: string
        if (!is_null($originatorAddress1) && !is_string($originatorAddress1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($originatorAddress1, true), gettype($originatorAddress1)), __LINE__);
        }
        if (is_null($originatorAddress1) || (is_array($originatorAddress1) && empty($originatorAddress1))) {
            unset($this->OriginatorAddress1);
        } else {
            $this->OriginatorAddress1 = $originatorAddress1;
        }
        return $this;
    }
    /**
     * Get OriginatorAddress2 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOriginatorAddress2()
    {
        return isset($this->OriginatorAddress2) ? $this->OriginatorAddress2 : null;
    }
    /**
     * Set OriginatorAddress2 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $originatorAddress2
     * @return \StructType\PayeeDetail
     */
    public function setOriginatorAddress2($originatorAddress2 = null)
    {
        // validation for constraint: string
        if (!is_null($originatorAddress2) && !is_string($originatorAddress2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($originatorAddress2, true), gettype($originatorAddress2)), __LINE__);
        }
        if (is_null($originatorAddress2) || (is_array($originatorAddress2) && empty($originatorAddress2))) {
            unset($this->OriginatorAddress2);
        } else {
            $this->OriginatorAddress2 = $originatorAddress2;
        }
        return $this;
    }
    /**
     * Get OriginatorCity value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOriginatorCity()
    {
        return isset($this->OriginatorCity) ? $this->OriginatorCity : null;
    }
    /**
     * Set OriginatorCity value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $originatorCity
     * @return \StructType\PayeeDetail
     */
    public function setOriginatorCity($originatorCity = null)
    {
        // validation for constraint: string
        if (!is_null($originatorCity) && !is_string($originatorCity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($originatorCity, true), gettype($originatorCity)), __LINE__);
        }
        if (is_null($originatorCity) || (is_array($originatorCity) && empty($originatorCity))) {
            unset($this->OriginatorCity);
        } else {
            $this->OriginatorCity = $originatorCity;
        }
        return $this;
    }
    /**
     * Get OriginatorCountryID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOriginatorCountryID()
    {
        return isset($this->OriginatorCountryID) ? $this->OriginatorCountryID : null;
    }
    /**
     * Set OriginatorCountryID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $originatorCountryID
     * @return \StructType\PayeeDetail
     */
    public function setOriginatorCountryID($originatorCountryID = null)
    {
        // validation for constraint: string
        if (!is_null($originatorCountryID) && !is_string($originatorCountryID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($originatorCountryID, true), gettype($originatorCountryID)), __LINE__);
        }
        if (is_null($originatorCountryID) || (is_array($originatorCountryID) && empty($originatorCountryID))) {
            unset($this->OriginatorCountryID);
        } else {
            $this->OriginatorCountryID = $originatorCountryID;
        }
        return $this;
    }
    /**
     * Get OriginatorID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOriginatorID()
    {
        return isset($this->OriginatorID) ? $this->OriginatorID : null;
    }
    /**
     * Set OriginatorID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $originatorID
     * @return \StructType\PayeeDetail
     */
    public function setOriginatorID($originatorID = null)
    {
        // validation for constraint: string
        if (!is_null($originatorID) && !is_string($originatorID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($originatorID, true), gettype($originatorID)), __LINE__);
        }
        if (is_null($originatorID) || (is_array($originatorID) && empty($originatorID))) {
            unset($this->OriginatorID);
        } else {
            $this->OriginatorID = $originatorID;
        }
        return $this;
    }
    /**
     * Get OriginatorName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOriginatorName()
    {
        return isset($this->OriginatorName) ? $this->OriginatorName : null;
    }
    /**
     * Set OriginatorName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $originatorName
     * @return \StructType\PayeeDetail
     */
    public function setOriginatorName($originatorName = null)
    {
        // validation for constraint: string
        if (!is_null($originatorName) && !is_string($originatorName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($originatorName, true), gettype($originatorName)), __LINE__);
        }
        if (is_null($originatorName) || (is_array($originatorName) && empty($originatorName))) {
            unset($this->OriginatorName);
        } else {
            $this->OriginatorName = $originatorName;
        }
        return $this;
    }
    /**
     * Get OriginatorPostalCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOriginatorPostalCode()
    {
        return isset($this->OriginatorPostalCode) ? $this->OriginatorPostalCode : null;
    }
    /**
     * Set OriginatorPostalCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $originatorPostalCode
     * @return \StructType\PayeeDetail
     */
    public function setOriginatorPostalCode($originatorPostalCode = null)
    {
        // validation for constraint: string
        if (!is_null($originatorPostalCode) && !is_string($originatorPostalCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($originatorPostalCode, true), gettype($originatorPostalCode)), __LINE__);
        }
        if (is_null($originatorPostalCode) || (is_array($originatorPostalCode) && empty($originatorPostalCode))) {
            unset($this->OriginatorPostalCode);
        } else {
            $this->OriginatorPostalCode = $originatorPostalCode;
        }
        return $this;
    }
    /**
     * Get OriginatorProvince value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOriginatorProvince()
    {
        return isset($this->OriginatorProvince) ? $this->OriginatorProvince : null;
    }
    /**
     * Set OriginatorProvince value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $originatorProvince
     * @return \StructType\PayeeDetail
     */
    public function setOriginatorProvince($originatorProvince = null)
    {
        // validation for constraint: string
        if (!is_null($originatorProvince) && !is_string($originatorProvince)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($originatorProvince, true), gettype($originatorProvince)), __LINE__);
        }
        if (is_null($originatorProvince) || (is_array($originatorProvince) && empty($originatorProvince))) {
            unset($this->OriginatorProvince);
        } else {
            $this->OriginatorProvince = $originatorProvince;
        }
        return $this;
    }
    /**
     * Get OriginatorType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOriginatorType()
    {
        return isset($this->OriginatorType) ? $this->OriginatorType : null;
    }
    /**
     * Set OriginatorType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \EnumType\OriginatorType::valueIsValid()
     * @uses \EnumType\OriginatorType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $originatorType
     * @return \StructType\PayeeDetail
     */
    public function setOriginatorType($originatorType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\OriginatorType::valueIsValid($originatorType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\OriginatorType', is_array($originatorType) ? implode(', ', $originatorType) : var_export($originatorType, true), implode(', ', \EnumType\OriginatorType::getValidValues())), __LINE__);
        }
        if (is_null($originatorType) || (is_array($originatorType) && empty($originatorType))) {
            unset($this->OriginatorType);
        } else {
            $this->OriginatorType = $originatorType;
        }
        return $this;
    }
    /**
     * Get PayeeAccountIBANNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPayeeAccountIBANNumber()
    {
        return isset($this->PayeeAccountIBANNumber) ? $this->PayeeAccountIBANNumber : null;
    }
    /**
     * Set PayeeAccountIBANNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $payeeAccountIBANNumber
     * @return \StructType\PayeeDetail
     */
    public function setPayeeAccountIBANNumber($payeeAccountIBANNumber = null)
    {
        // validation for constraint: string
        if (!is_null($payeeAccountIBANNumber) && !is_string($payeeAccountIBANNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($payeeAccountIBANNumber, true), gettype($payeeAccountIBANNumber)), __LINE__);
        }
        if (is_null($payeeAccountIBANNumber) || (is_array($payeeAccountIBANNumber) && empty($payeeAccountIBANNumber))) {
            unset($this->PayeeAccountIBANNumber);
        } else {
            $this->PayeeAccountIBANNumber = $payeeAccountIBANNumber;
        }
        return $this;
    }
    /**
     * Get PayeeAddress1 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPayeeAddress1()
    {
        return isset($this->PayeeAddress1) ? $this->PayeeAddress1 : null;
    }
    /**
     * Set PayeeAddress1 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $payeeAddress1
     * @return \StructType\PayeeDetail
     */
    public function setPayeeAddress1($payeeAddress1 = null)
    {
        // validation for constraint: string
        if (!is_null($payeeAddress1) && !is_string($payeeAddress1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($payeeAddress1, true), gettype($payeeAddress1)), __LINE__);
        }
        if (is_null($payeeAddress1) || (is_array($payeeAddress1) && empty($payeeAddress1))) {
            unset($this->PayeeAddress1);
        } else {
            $this->PayeeAddress1 = $payeeAddress1;
        }
        return $this;
    }
    /**
     * Get PayeeAddress2 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPayeeAddress2()
    {
        return isset($this->PayeeAddress2) ? $this->PayeeAddress2 : null;
    }
    /**
     * Set PayeeAddress2 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $payeeAddress2
     * @return \StructType\PayeeDetail
     */
    public function setPayeeAddress2($payeeAddress2 = null)
    {
        // validation for constraint: string
        if (!is_null($payeeAddress2) && !is_string($payeeAddress2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($payeeAddress2, true), gettype($payeeAddress2)), __LINE__);
        }
        if (is_null($payeeAddress2) || (is_array($payeeAddress2) && empty($payeeAddress2))) {
            unset($this->PayeeAddress2);
        } else {
            $this->PayeeAddress2 = $payeeAddress2;
        }
        return $this;
    }
    /**
     * Get PayeeBankAddress1 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPayeeBankAddress1()
    {
        return isset($this->PayeeBankAddress1) ? $this->PayeeBankAddress1 : null;
    }
    /**
     * Set PayeeBankAddress1 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $payeeBankAddress1
     * @return \StructType\PayeeDetail
     */
    public function setPayeeBankAddress1($payeeBankAddress1 = null)
    {
        // validation for constraint: string
        if (!is_null($payeeBankAddress1) && !is_string($payeeBankAddress1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($payeeBankAddress1, true), gettype($payeeBankAddress1)), __LINE__);
        }
        if (is_null($payeeBankAddress1) || (is_array($payeeBankAddress1) && empty($payeeBankAddress1))) {
            unset($this->PayeeBankAddress1);
        } else {
            $this->PayeeBankAddress1 = $payeeBankAddress1;
        }
        return $this;
    }
    /**
     * Get PayeeBankAddress2 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPayeeBankAddress2()
    {
        return isset($this->PayeeBankAddress2) ? $this->PayeeBankAddress2 : null;
    }
    /**
     * Set PayeeBankAddress2 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $payeeBankAddress2
     * @return \StructType\PayeeDetail
     */
    public function setPayeeBankAddress2($payeeBankAddress2 = null)
    {
        // validation for constraint: string
        if (!is_null($payeeBankAddress2) && !is_string($payeeBankAddress2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($payeeBankAddress2, true), gettype($payeeBankAddress2)), __LINE__);
        }
        if (is_null($payeeBankAddress2) || (is_array($payeeBankAddress2) && empty($payeeBankAddress2))) {
            unset($this->PayeeBankAddress2);
        } else {
            $this->PayeeBankAddress2 = $payeeBankAddress2;
        }
        return $this;
    }
    /**
     * Get PayeeBankBankCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPayeeBankBankCode()
    {
        return isset($this->PayeeBankBankCode) ? $this->PayeeBankBankCode : null;
    }
    /**
     * Set PayeeBankBankCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $payeeBankBankCode
     * @return \StructType\PayeeDetail
     */
    public function setPayeeBankBankCode($payeeBankBankCode = null)
    {
        // validation for constraint: string
        if (!is_null($payeeBankBankCode) && !is_string($payeeBankBankCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($payeeBankBankCode, true), gettype($payeeBankBankCode)), __LINE__);
        }
        if (is_null($payeeBankBankCode) || (is_array($payeeBankBankCode) && empty($payeeBankBankCode))) {
            unset($this->PayeeBankBankCode);
        } else {
            $this->PayeeBankBankCode = $payeeBankBankCode;
        }
        return $this;
    }
    /**
     * Get PayeeBankCity value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPayeeBankCity()
    {
        return isset($this->PayeeBankCity) ? $this->PayeeBankCity : null;
    }
    /**
     * Set PayeeBankCity value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $payeeBankCity
     * @return \StructType\PayeeDetail
     */
    public function setPayeeBankCity($payeeBankCity = null)
    {
        // validation for constraint: string
        if (!is_null($payeeBankCity) && !is_string($payeeBankCity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($payeeBankCity, true), gettype($payeeBankCity)), __LINE__);
        }
        if (is_null($payeeBankCity) || (is_array($payeeBankCity) && empty($payeeBankCity))) {
            unset($this->PayeeBankCity);
        } else {
            $this->PayeeBankCity = $payeeBankCity;
        }
        return $this;
    }
    /**
     * Get PayeeBankCountryID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPayeeBankCountryID()
    {
        return isset($this->PayeeBankCountryID) ? $this->PayeeBankCountryID : null;
    }
    /**
     * Set PayeeBankCountryID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $payeeBankCountryID
     * @return \StructType\PayeeDetail
     */
    public function setPayeeBankCountryID($payeeBankCountryID = null)
    {
        // validation for constraint: string
        if (!is_null($payeeBankCountryID) && !is_string($payeeBankCountryID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($payeeBankCountryID, true), gettype($payeeBankCountryID)), __LINE__);
        }
        if (is_null($payeeBankCountryID) || (is_array($payeeBankCountryID) && empty($payeeBankCountryID))) {
            unset($this->PayeeBankCountryID);
        } else {
            $this->PayeeBankCountryID = $payeeBankCountryID;
        }
        return $this;
    }
    /**
     * Get PayeeBankName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPayeeBankName()
    {
        return isset($this->PayeeBankName) ? $this->PayeeBankName : null;
    }
    /**
     * Set PayeeBankName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $payeeBankName
     * @return \StructType\PayeeDetail
     */
    public function setPayeeBankName($payeeBankName = null)
    {
        // validation for constraint: string
        if (!is_null($payeeBankName) && !is_string($payeeBankName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($payeeBankName, true), gettype($payeeBankName)), __LINE__);
        }
        if (is_null($payeeBankName) || (is_array($payeeBankName) && empty($payeeBankName))) {
            unset($this->PayeeBankName);
        } else {
            $this->PayeeBankName = $payeeBankName;
        }
        return $this;
    }
    /**
     * Get PayeeBankPostalCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPayeeBankPostalCode()
    {
        return isset($this->PayeeBankPostalCode) ? $this->PayeeBankPostalCode : null;
    }
    /**
     * Set PayeeBankPostalCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $payeeBankPostalCode
     * @return \StructType\PayeeDetail
     */
    public function setPayeeBankPostalCode($payeeBankPostalCode = null)
    {
        // validation for constraint: string
        if (!is_null($payeeBankPostalCode) && !is_string($payeeBankPostalCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($payeeBankPostalCode, true), gettype($payeeBankPostalCode)), __LINE__);
        }
        if (is_null($payeeBankPostalCode) || (is_array($payeeBankPostalCode) && empty($payeeBankPostalCode))) {
            unset($this->PayeeBankPostalCode);
        } else {
            $this->PayeeBankPostalCode = $payeeBankPostalCode;
        }
        return $this;
    }
    /**
     * Get PayeeBankProvince value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPayeeBankProvince()
    {
        return isset($this->PayeeBankProvince) ? $this->PayeeBankProvince : null;
    }
    /**
     * Set PayeeBankProvince value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $payeeBankProvince
     * @return \StructType\PayeeDetail
     */
    public function setPayeeBankProvince($payeeBankProvince = null)
    {
        // validation for constraint: string
        if (!is_null($payeeBankProvince) && !is_string($payeeBankProvince)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($payeeBankProvince, true), gettype($payeeBankProvince)), __LINE__);
        }
        if (is_null($payeeBankProvince) || (is_array($payeeBankProvince) && empty($payeeBankProvince))) {
            unset($this->PayeeBankProvince);
        } else {
            $this->PayeeBankProvince = $payeeBankProvince;
        }
        return $this;
    }
    /**
     * Get PayeeBankRoutingCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPayeeBankRoutingCode()
    {
        return isset($this->PayeeBankRoutingCode) ? $this->PayeeBankRoutingCode : null;
    }
    /**
     * Set PayeeBankRoutingCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $payeeBankRoutingCode
     * @return \StructType\PayeeDetail
     */
    public function setPayeeBankRoutingCode($payeeBankRoutingCode = null)
    {
        // validation for constraint: string
        if (!is_null($payeeBankRoutingCode) && !is_string($payeeBankRoutingCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($payeeBankRoutingCode, true), gettype($payeeBankRoutingCode)), __LINE__);
        }
        if (is_null($payeeBankRoutingCode) || (is_array($payeeBankRoutingCode) && empty($payeeBankRoutingCode))) {
            unset($this->PayeeBankRoutingCode);
        } else {
            $this->PayeeBankRoutingCode = $payeeBankRoutingCode;
        }
        return $this;
    }
    /**
     * Get PayeeBankRoutingType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPayeeBankRoutingType()
    {
        return isset($this->PayeeBankRoutingType) ? $this->PayeeBankRoutingType : null;
    }
    /**
     * Set PayeeBankRoutingType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $payeeBankRoutingType
     * @return \StructType\PayeeDetail
     */
    public function setPayeeBankRoutingType($payeeBankRoutingType = null)
    {
        // validation for constraint: string
        if (!is_null($payeeBankRoutingType) && !is_string($payeeBankRoutingType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($payeeBankRoutingType, true), gettype($payeeBankRoutingType)), __LINE__);
        }
        if (is_null($payeeBankRoutingType) || (is_array($payeeBankRoutingType) && empty($payeeBankRoutingType))) {
            unset($this->PayeeBankRoutingType);
        } else {
            $this->PayeeBankRoutingType = $payeeBankRoutingType;
        }
        return $this;
    }
    /**
     * Get PayeeBankSwiftCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPayeeBankSwiftCode()
    {
        return isset($this->PayeeBankSwiftCode) ? $this->PayeeBankSwiftCode : null;
    }
    /**
     * Set PayeeBankSwiftCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $payeeBankSwiftCode
     * @return \StructType\PayeeDetail
     */
    public function setPayeeBankSwiftCode($payeeBankSwiftCode = null)
    {
        // validation for constraint: string
        if (!is_null($payeeBankSwiftCode) && !is_string($payeeBankSwiftCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($payeeBankSwiftCode, true), gettype($payeeBankSwiftCode)), __LINE__);
        }
        if (is_null($payeeBankSwiftCode) || (is_array($payeeBankSwiftCode) && empty($payeeBankSwiftCode))) {
            unset($this->PayeeBankSwiftCode);
        } else {
            $this->PayeeBankSwiftCode = $payeeBankSwiftCode;
        }
        return $this;
    }
    /**
     * Get PayeeCity value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPayeeCity()
    {
        return isset($this->PayeeCity) ? $this->PayeeCity : null;
    }
    /**
     * Set PayeeCity value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $payeeCity
     * @return \StructType\PayeeDetail
     */
    public function setPayeeCity($payeeCity = null)
    {
        // validation for constraint: string
        if (!is_null($payeeCity) && !is_string($payeeCity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($payeeCity, true), gettype($payeeCity)), __LINE__);
        }
        if (is_null($payeeCity) || (is_array($payeeCity) && empty($payeeCity))) {
            unset($this->PayeeCity);
        } else {
            $this->PayeeCity = $payeeCity;
        }
        return $this;
    }
    /**
     * Get PayeeCountryID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPayeeCountryID()
    {
        return isset($this->PayeeCountryID) ? $this->PayeeCountryID : null;
    }
    /**
     * Set PayeeCountryID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $payeeCountryID
     * @return \StructType\PayeeDetail
     */
    public function setPayeeCountryID($payeeCountryID = null)
    {
        // validation for constraint: string
        if (!is_null($payeeCountryID) && !is_string($payeeCountryID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($payeeCountryID, true), gettype($payeeCountryID)), __LINE__);
        }
        if (is_null($payeeCountryID) || (is_array($payeeCountryID) && empty($payeeCountryID))) {
            unset($this->PayeeCountryID);
        } else {
            $this->PayeeCountryID = $payeeCountryID;
        }
        return $this;
    }
    /**
     * Get PayeeEmail value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPayeeEmail()
    {
        return isset($this->PayeeEmail) ? $this->PayeeEmail : null;
    }
    /**
     * Set PayeeEmail value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $payeeEmail
     * @return \StructType\PayeeDetail
     */
    public function setPayeeEmail($payeeEmail = null)
    {
        // validation for constraint: string
        if (!is_null($payeeEmail) && !is_string($payeeEmail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($payeeEmail, true), gettype($payeeEmail)), __LINE__);
        }
        if (is_null($payeeEmail) || (is_array($payeeEmail) && empty($payeeEmail))) {
            unset($this->PayeeEmail);
        } else {
            $this->PayeeEmail = $payeeEmail;
        }
        return $this;
    }
    /**
     * Get PayeeID value
     * @return int|null
     */
    public function getPayeeID()
    {
        return $this->PayeeID;
    }
    /**
     * Set PayeeID value
     * @param int $payeeID
     * @return \StructType\PayeeDetail
     */
    public function setPayeeID($payeeID = null)
    {
        // validation for constraint: int
        if (!is_null($payeeID) && !(is_int($payeeID) || ctype_digit($payeeID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($payeeID, true), gettype($payeeID)), __LINE__);
        }
        $this->PayeeID = $payeeID;
        return $this;
    }
    /**
     * Get PayeeInterBankAddress1 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPayeeInterBankAddress1()
    {
        return isset($this->PayeeInterBankAddress1) ? $this->PayeeInterBankAddress1 : null;
    }
    /**
     * Set PayeeInterBankAddress1 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $payeeInterBankAddress1
     * @return \StructType\PayeeDetail
     */
    public function setPayeeInterBankAddress1($payeeInterBankAddress1 = null)
    {
        // validation for constraint: string
        if (!is_null($payeeInterBankAddress1) && !is_string($payeeInterBankAddress1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($payeeInterBankAddress1, true), gettype($payeeInterBankAddress1)), __LINE__);
        }
        if (is_null($payeeInterBankAddress1) || (is_array($payeeInterBankAddress1) && empty($payeeInterBankAddress1))) {
            unset($this->PayeeInterBankAddress1);
        } else {
            $this->PayeeInterBankAddress1 = $payeeInterBankAddress1;
        }
        return $this;
    }
    /**
     * Get PayeeInterBankAddress2 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPayeeInterBankAddress2()
    {
        return isset($this->PayeeInterBankAddress2) ? $this->PayeeInterBankAddress2 : null;
    }
    /**
     * Set PayeeInterBankAddress2 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $payeeInterBankAddress2
     * @return \StructType\PayeeDetail
     */
    public function setPayeeInterBankAddress2($payeeInterBankAddress2 = null)
    {
        // validation for constraint: string
        if (!is_null($payeeInterBankAddress2) && !is_string($payeeInterBankAddress2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($payeeInterBankAddress2, true), gettype($payeeInterBankAddress2)), __LINE__);
        }
        if (is_null($payeeInterBankAddress2) || (is_array($payeeInterBankAddress2) && empty($payeeInterBankAddress2))) {
            unset($this->PayeeInterBankAddress2);
        } else {
            $this->PayeeInterBankAddress2 = $payeeInterBankAddress2;
        }
        return $this;
    }
    /**
     * Get PayeeInterBankBankCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPayeeInterBankBankCode()
    {
        return isset($this->PayeeInterBankBankCode) ? $this->PayeeInterBankBankCode : null;
    }
    /**
     * Set PayeeInterBankBankCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $payeeInterBankBankCode
     * @return \StructType\PayeeDetail
     */
    public function setPayeeInterBankBankCode($payeeInterBankBankCode = null)
    {
        // validation for constraint: string
        if (!is_null($payeeInterBankBankCode) && !is_string($payeeInterBankBankCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($payeeInterBankBankCode, true), gettype($payeeInterBankBankCode)), __LINE__);
        }
        if (is_null($payeeInterBankBankCode) || (is_array($payeeInterBankBankCode) && empty($payeeInterBankBankCode))) {
            unset($this->PayeeInterBankBankCode);
        } else {
            $this->PayeeInterBankBankCode = $payeeInterBankBankCode;
        }
        return $this;
    }
    /**
     * Get PayeeInterBankCity value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPayeeInterBankCity()
    {
        return isset($this->PayeeInterBankCity) ? $this->PayeeInterBankCity : null;
    }
    /**
     * Set PayeeInterBankCity value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $payeeInterBankCity
     * @return \StructType\PayeeDetail
     */
    public function setPayeeInterBankCity($payeeInterBankCity = null)
    {
        // validation for constraint: string
        if (!is_null($payeeInterBankCity) && !is_string($payeeInterBankCity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($payeeInterBankCity, true), gettype($payeeInterBankCity)), __LINE__);
        }
        if (is_null($payeeInterBankCity) || (is_array($payeeInterBankCity) && empty($payeeInterBankCity))) {
            unset($this->PayeeInterBankCity);
        } else {
            $this->PayeeInterBankCity = $payeeInterBankCity;
        }
        return $this;
    }
    /**
     * Get PayeeInterBankCountryID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPayeeInterBankCountryID()
    {
        return isset($this->PayeeInterBankCountryID) ? $this->PayeeInterBankCountryID : null;
    }
    /**
     * Set PayeeInterBankCountryID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $payeeInterBankCountryID
     * @return \StructType\PayeeDetail
     */
    public function setPayeeInterBankCountryID($payeeInterBankCountryID = null)
    {
        // validation for constraint: string
        if (!is_null($payeeInterBankCountryID) && !is_string($payeeInterBankCountryID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($payeeInterBankCountryID, true), gettype($payeeInterBankCountryID)), __LINE__);
        }
        if (is_null($payeeInterBankCountryID) || (is_array($payeeInterBankCountryID) && empty($payeeInterBankCountryID))) {
            unset($this->PayeeInterBankCountryID);
        } else {
            $this->PayeeInterBankCountryID = $payeeInterBankCountryID;
        }
        return $this;
    }
    /**
     * Get PayeeInterBankName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPayeeInterBankName()
    {
        return isset($this->PayeeInterBankName) ? $this->PayeeInterBankName : null;
    }
    /**
     * Set PayeeInterBankName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $payeeInterBankName
     * @return \StructType\PayeeDetail
     */
    public function setPayeeInterBankName($payeeInterBankName = null)
    {
        // validation for constraint: string
        if (!is_null($payeeInterBankName) && !is_string($payeeInterBankName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($payeeInterBankName, true), gettype($payeeInterBankName)), __LINE__);
        }
        if (is_null($payeeInterBankName) || (is_array($payeeInterBankName) && empty($payeeInterBankName))) {
            unset($this->PayeeInterBankName);
        } else {
            $this->PayeeInterBankName = $payeeInterBankName;
        }
        return $this;
    }
    /**
     * Get PayeeInterBankPostalCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPayeeInterBankPostalCode()
    {
        return isset($this->PayeeInterBankPostalCode) ? $this->PayeeInterBankPostalCode : null;
    }
    /**
     * Set PayeeInterBankPostalCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $payeeInterBankPostalCode
     * @return \StructType\PayeeDetail
     */
    public function setPayeeInterBankPostalCode($payeeInterBankPostalCode = null)
    {
        // validation for constraint: string
        if (!is_null($payeeInterBankPostalCode) && !is_string($payeeInterBankPostalCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($payeeInterBankPostalCode, true), gettype($payeeInterBankPostalCode)), __LINE__);
        }
        if (is_null($payeeInterBankPostalCode) || (is_array($payeeInterBankPostalCode) && empty($payeeInterBankPostalCode))) {
            unset($this->PayeeInterBankPostalCode);
        } else {
            $this->PayeeInterBankPostalCode = $payeeInterBankPostalCode;
        }
        return $this;
    }
    /**
     * Get PayeeInterBankProvince value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPayeeInterBankProvince()
    {
        return isset($this->PayeeInterBankProvince) ? $this->PayeeInterBankProvince : null;
    }
    /**
     * Set PayeeInterBankProvince value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $payeeInterBankProvince
     * @return \StructType\PayeeDetail
     */
    public function setPayeeInterBankProvince($payeeInterBankProvince = null)
    {
        // validation for constraint: string
        if (!is_null($payeeInterBankProvince) && !is_string($payeeInterBankProvince)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($payeeInterBankProvince, true), gettype($payeeInterBankProvince)), __LINE__);
        }
        if (is_null($payeeInterBankProvince) || (is_array($payeeInterBankProvince) && empty($payeeInterBankProvince))) {
            unset($this->PayeeInterBankProvince);
        } else {
            $this->PayeeInterBankProvince = $payeeInterBankProvince;
        }
        return $this;
    }
    /**
     * Get PayeeInterBankRoutingCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPayeeInterBankRoutingCode()
    {
        return isset($this->PayeeInterBankRoutingCode) ? $this->PayeeInterBankRoutingCode : null;
    }
    /**
     * Set PayeeInterBankRoutingCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $payeeInterBankRoutingCode
     * @return \StructType\PayeeDetail
     */
    public function setPayeeInterBankRoutingCode($payeeInterBankRoutingCode = null)
    {
        // validation for constraint: string
        if (!is_null($payeeInterBankRoutingCode) && !is_string($payeeInterBankRoutingCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($payeeInterBankRoutingCode, true), gettype($payeeInterBankRoutingCode)), __LINE__);
        }
        if (is_null($payeeInterBankRoutingCode) || (is_array($payeeInterBankRoutingCode) && empty($payeeInterBankRoutingCode))) {
            unset($this->PayeeInterBankRoutingCode);
        } else {
            $this->PayeeInterBankRoutingCode = $payeeInterBankRoutingCode;
        }
        return $this;
    }
    /**
     * Get PayeeInterBankRoutingCodeType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPayeeInterBankRoutingCodeType()
    {
        return isset($this->PayeeInterBankRoutingCodeType) ? $this->PayeeInterBankRoutingCodeType : null;
    }
    /**
     * Set PayeeInterBankRoutingCodeType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $payeeInterBankRoutingCodeType
     * @return \StructType\PayeeDetail
     */
    public function setPayeeInterBankRoutingCodeType($payeeInterBankRoutingCodeType = null)
    {
        // validation for constraint: string
        if (!is_null($payeeInterBankRoutingCodeType) && !is_string($payeeInterBankRoutingCodeType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($payeeInterBankRoutingCodeType, true), gettype($payeeInterBankRoutingCodeType)), __LINE__);
        }
        if (is_null($payeeInterBankRoutingCodeType) || (is_array($payeeInterBankRoutingCodeType) && empty($payeeInterBankRoutingCodeType))) {
            unset($this->PayeeInterBankRoutingCodeType);
        } else {
            $this->PayeeInterBankRoutingCodeType = $payeeInterBankRoutingCodeType;
        }
        return $this;
    }
    /**
     * Get PayeeInternalReference value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPayeeInternalReference()
    {
        return isset($this->PayeeInternalReference) ? $this->PayeeInternalReference : null;
    }
    /**
     * Set PayeeInternalReference value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $payeeInternalReference
     * @return \StructType\PayeeDetail
     */
    public function setPayeeInternalReference($payeeInternalReference = null)
    {
        // validation for constraint: string
        if (!is_null($payeeInternalReference) && !is_string($payeeInternalReference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($payeeInternalReference, true), gettype($payeeInternalReference)), __LINE__);
        }
        if (is_null($payeeInternalReference) || (is_array($payeeInternalReference) && empty($payeeInternalReference))) {
            unset($this->PayeeInternalReference);
        } else {
            $this->PayeeInternalReference = $payeeInternalReference;
        }
        return $this;
    }
    /**
     * Get PayeeName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPayeeName()
    {
        return isset($this->PayeeName) ? $this->PayeeName : null;
    }
    /**
     * Set PayeeName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $payeeName
     * @return \StructType\PayeeDetail
     */
    public function setPayeeName($payeeName = null)
    {
        // validation for constraint: string
        if (!is_null($payeeName) && !is_string($payeeName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($payeeName, true), gettype($payeeName)), __LINE__);
        }
        if (is_null($payeeName) || (is_array($payeeName) && empty($payeeName))) {
            unset($this->PayeeName);
        } else {
            $this->PayeeName = $payeeName;
        }
        return $this;
    }
    /**
     * Get PayeePostalCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPayeePostalCode()
    {
        return isset($this->PayeePostalCode) ? $this->PayeePostalCode : null;
    }
    /**
     * Set PayeePostalCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $payeePostalCode
     * @return \StructType\PayeeDetail
     */
    public function setPayeePostalCode($payeePostalCode = null)
    {
        // validation for constraint: string
        if (!is_null($payeePostalCode) && !is_string($payeePostalCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($payeePostalCode, true), gettype($payeePostalCode)), __LINE__);
        }
        if (is_null($payeePostalCode) || (is_array($payeePostalCode) && empty($payeePostalCode))) {
            unset($this->PayeePostalCode);
        } else {
            $this->PayeePostalCode = $payeePostalCode;
        }
        return $this;
    }
    /**
     * Get PayeeProvince value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPayeeProvince()
    {
        return isset($this->PayeeProvince) ? $this->PayeeProvince : null;
    }
    /**
     * Set PayeeProvince value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $payeeProvince
     * @return \StructType\PayeeDetail
     */
    public function setPayeeProvince($payeeProvince = null)
    {
        // validation for constraint: string
        if (!is_null($payeeProvince) && !is_string($payeeProvince)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($payeeProvince, true), gettype($payeeProvince)), __LINE__);
        }
        if (is_null($payeeProvince) || (is_array($payeeProvince) && empty($payeeProvince))) {
            unset($this->PayeeProvince);
        } else {
            $this->PayeeProvince = $payeeProvince;
        }
        return $this;
    }
    /**
     * Get PayeeReference value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPayeeReference()
    {
        return isset($this->PayeeReference) ? $this->PayeeReference : null;
    }
    /**
     * Set PayeeReference value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $payeeReference
     * @return \StructType\PayeeDetail
     */
    public function setPayeeReference($payeeReference = null)
    {
        // validation for constraint: string
        if (!is_null($payeeReference) && !is_string($payeeReference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($payeeReference, true), gettype($payeeReference)), __LINE__);
        }
        if (is_null($payeeReference) || (is_array($payeeReference) && empty($payeeReference))) {
            unset($this->PayeeReference);
        } else {
            $this->PayeeReference = $payeeReference;
        }
        return $this;
    }
    /**
     * Get PayeeSendingBankInstructions value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPayeeSendingBankInstructions()
    {
        return isset($this->PayeeSendingBankInstructions) ? $this->PayeeSendingBankInstructions : null;
    }
    /**
     * Set PayeeSendingBankInstructions value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $payeeSendingBankInstructions
     * @return \StructType\PayeeDetail
     */
    public function setPayeeSendingBankInstructions($payeeSendingBankInstructions = null)
    {
        // validation for constraint: string
        if (!is_null($payeeSendingBankInstructions) && !is_string($payeeSendingBankInstructions)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($payeeSendingBankInstructions, true), gettype($payeeSendingBankInstructions)), __LINE__);
        }
        if (is_null($payeeSendingBankInstructions) || (is_array($payeeSendingBankInstructions) && empty($payeeSendingBankInstructions))) {
            unset($this->PayeeSendingBankInstructions);
        } else {
            $this->PayeeSendingBankInstructions = $payeeSendingBankInstructions;
        }
        return $this;
    }
    /**
     * Get PaymentMethod value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPaymentMethod()
    {
        return isset($this->PaymentMethod) ? $this->PaymentMethod : null;
    }
    /**
     * Set PaymentMethod value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $paymentMethod
     * @return \StructType\PayeeDetail
     */
    public function setPaymentMethod($paymentMethod = null)
    {
        // validation for constraint: string
        if (!is_null($paymentMethod) && !is_string($paymentMethod)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentMethod, true), gettype($paymentMethod)), __LINE__);
        }
        if (is_null($paymentMethod) || (is_array($paymentMethod) && empty($paymentMethod))) {
            unset($this->PaymentMethod);
        } else {
            $this->PaymentMethod = $paymentMethod;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PayeeDetail
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
