<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetQuoteRequest StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:GetQuoteRequest
 * @subpackage Structs
 */
class GetQuoteRequest extends AbstractStructBase
{
    /**
     * The MethodID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $MethodID;
    /**
     * The OrgID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OrgID;
    /**
     * The Payment
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfDeal
     */
    public $Payment;
    /**
     * The TotalNumberOfPayment
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $TotalNumberOfPayment;
    /**
     * Constructor method for GetQuoteRequest
     * @uses GetQuoteRequest::setMethodID()
     * @uses GetQuoteRequest::setOrgID()
     * @uses GetQuoteRequest::setPayment()
     * @uses GetQuoteRequest::setTotalNumberOfPayment()
     * @param string $methodID
     * @param string $orgID
     * @param \ArrayType\ArrayOfDeal $payment
     * @param int $totalNumberOfPayment
     */
    public function __construct($methodID = null, $orgID = null, \ArrayType\ArrayOfDeal $payment = null, $totalNumberOfPayment = null)
    {
        $this
            ->setMethodID($methodID)
            ->setOrgID($orgID)
            ->setPayment($payment)
            ->setTotalNumberOfPayment($totalNumberOfPayment);
    }
    /**
     * Get MethodID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMethodID()
    {
        return isset($this->MethodID) ? $this->MethodID : null;
    }
    /**
     * Set MethodID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $methodID
     * @return \StructType\GetQuoteRequest
     */
    public function setMethodID($methodID = null)
    {
        // validation for constraint: string
        if (!is_null($methodID) && !is_string($methodID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($methodID, true), gettype($methodID)), __LINE__);
        }
        if (is_null($methodID) || (is_array($methodID) && empty($methodID))) {
            unset($this->MethodID);
        } else {
            $this->MethodID = $methodID;
        }
        return $this;
    }
    /**
     * Get OrgID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrgID()
    {
        return isset($this->OrgID) ? $this->OrgID : null;
    }
    /**
     * Set OrgID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $orgID
     * @return \StructType\GetQuoteRequest
     */
    public function setOrgID($orgID = null)
    {
        // validation for constraint: string
        if (!is_null($orgID) && !is_string($orgID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($orgID, true), gettype($orgID)), __LINE__);
        }
        if (is_null($orgID) || (is_array($orgID) && empty($orgID))) {
            unset($this->OrgID);
        } else {
            $this->OrgID = $orgID;
        }
        return $this;
    }
    /**
     * Get Payment value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfDeal|null
     */
    public function getPayment()
    {
        return isset($this->Payment) ? $this->Payment : null;
    }
    /**
     * Set Payment value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfDeal $payment
     * @return \StructType\GetQuoteRequest
     */
    public function setPayment(\ArrayType\ArrayOfDeal $payment = null)
    {
        if (is_null($payment) || (is_array($payment) && empty($payment))) {
            unset($this->Payment);
        } else {
            $this->Payment = $payment;
        }
        return $this;
    }
    /**
     * Get TotalNumberOfPayment value
     * @return int|null
     */
    public function getTotalNumberOfPayment()
    {
        return $this->TotalNumberOfPayment;
    }
    /**
     * Set TotalNumberOfPayment value
     * @param int $totalNumberOfPayment
     * @return \StructType\GetQuoteRequest
     */
    public function setTotalNumberOfPayment($totalNumberOfPayment = null)
    {
        // validation for constraint: int
        if (!is_null($totalNumberOfPayment) && !(is_int($totalNumberOfPayment) || ctype_digit($totalNumberOfPayment))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($totalNumberOfPayment, true), gettype($totalNumberOfPayment)), __LINE__);
        }
        $this->TotalNumberOfPayment = $totalNumberOfPayment;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetQuoteRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
