<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ValidateIBANRequest StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ValidateIBANRequest
 * @subpackage Structs
 */
class ValidateIBANRequest extends AbstractStructBase
{
    /**
     * The IBANNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $IBANNumber;
    /**
     * The MethodID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $MethodID;
    /**
     * The OrgID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OrgID;
    /**
     * Constructor method for ValidateIBANRequest
     * @uses ValidateIBANRequest::setIBANNumber()
     * @uses ValidateIBANRequest::setMethodID()
     * @uses ValidateIBANRequest::setOrgID()
     * @param string $iBANNumber
     * @param string $methodID
     * @param string $orgID
     */
    public function __construct($iBANNumber = null, $methodID = null, $orgID = null)
    {
        $this
            ->setIBANNumber($iBANNumber)
            ->setMethodID($methodID)
            ->setOrgID($orgID);
    }
    /**
     * Get IBANNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIBANNumber()
    {
        return isset($this->IBANNumber) ? $this->IBANNumber : null;
    }
    /**
     * Set IBANNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $iBANNumber
     * @return \StructType\ValidateIBANRequest
     */
    public function setIBANNumber($iBANNumber = null)
    {
        // validation for constraint: string
        if (!is_null($iBANNumber) && !is_string($iBANNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iBANNumber, true), gettype($iBANNumber)), __LINE__);
        }
        if (is_null($iBANNumber) || (is_array($iBANNumber) && empty($iBANNumber))) {
            unset($this->IBANNumber);
        } else {
            $this->IBANNumber = $iBANNumber;
        }
        return $this;
    }
    /**
     * Get MethodID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMethodID()
    {
        return isset($this->MethodID) ? $this->MethodID : null;
    }
    /**
     * Set MethodID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $methodID
     * @return \StructType\ValidateIBANRequest
     */
    public function setMethodID($methodID = null)
    {
        // validation for constraint: string
        if (!is_null($methodID) && !is_string($methodID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($methodID, true), gettype($methodID)), __LINE__);
        }
        if (is_null($methodID) || (is_array($methodID) && empty($methodID))) {
            unset($this->MethodID);
        } else {
            $this->MethodID = $methodID;
        }
        return $this;
    }
    /**
     * Get OrgID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrgID()
    {
        return isset($this->OrgID) ? $this->OrgID : null;
    }
    /**
     * Set OrgID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $orgID
     * @return \StructType\ValidateIBANRequest
     */
    public function setOrgID($orgID = null)
    {
        // validation for constraint: string
        if (!is_null($orgID) && !is_string($orgID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($orgID, true), gettype($orgID)), __LINE__);
        }
        if (is_null($orgID) || (is_array($orgID) && empty($orgID))) {
            unset($this->OrgID);
        } else {
            $this->OrgID = $orgID;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ValidateIBANRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
