<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PayeeInfoValidationResult StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:PayeeInfoValidationResult
 * @subpackage Structs
 */
class PayeeInfoValidationResult extends AbstractStructBase
{
    /**
     * The ErrorCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ErrorCode;
    /**
     * The ErrorMessage
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ErrorMessage;
    /**
     * The NumberOfInValidPayees
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $NumberOfInValidPayees;
    /**
     * The NumberOfPayees
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $NumberOfPayees;
    /**
     * The NumberOfValidPayees
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $NumberOfValidPayees;
    /**
     * The ValidationDetail
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfValidationDetails
     */
    public $ValidationDetail;
    /**
     * Constructor method for PayeeInfoValidationResult
     * @uses PayeeInfoValidationResult::setErrorCode()
     * @uses PayeeInfoValidationResult::setErrorMessage()
     * @uses PayeeInfoValidationResult::setNumberOfInValidPayees()
     * @uses PayeeInfoValidationResult::setNumberOfPayees()
     * @uses PayeeInfoValidationResult::setNumberOfValidPayees()
     * @uses PayeeInfoValidationResult::setValidationDetail()
     * @param int $errorCode
     * @param string $errorMessage
     * @param int $numberOfInValidPayees
     * @param int $numberOfPayees
     * @param int $numberOfValidPayees
     * @param \ArrayType\ArrayOfValidationDetails $validationDetail
     */
    public function __construct($errorCode = null, $errorMessage = null, $numberOfInValidPayees = null, $numberOfPayees = null, $numberOfValidPayees = null, \ArrayType\ArrayOfValidationDetails $validationDetail = null)
    {
        $this
            ->setErrorCode($errorCode)
            ->setErrorMessage($errorMessage)
            ->setNumberOfInValidPayees($numberOfInValidPayees)
            ->setNumberOfPayees($numberOfPayees)
            ->setNumberOfValidPayees($numberOfValidPayees)
            ->setValidationDetail($validationDetail);
    }
    /**
     * Get ErrorCode value
     * @return int|null
     */
    public function getErrorCode()
    {
        return $this->ErrorCode;
    }
    /**
     * Set ErrorCode value
     * @param int $errorCode
     * @return \StructType\PayeeInfoValidationResult
     */
    public function setErrorCode($errorCode = null)
    {
        // validation for constraint: int
        if (!is_null($errorCode) && !(is_int($errorCode) || ctype_digit($errorCode))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($errorCode, true), gettype($errorCode)), __LINE__);
        }
        $this->ErrorCode = $errorCode;
        return $this;
    }
    /**
     * Get ErrorMessage value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getErrorMessage()
    {
        return isset($this->ErrorMessage) ? $this->ErrorMessage : null;
    }
    /**
     * Set ErrorMessage value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $errorMessage
     * @return \StructType\PayeeInfoValidationResult
     */
    public function setErrorMessage($errorMessage = null)
    {
        // validation for constraint: string
        if (!is_null($errorMessage) && !is_string($errorMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($errorMessage, true), gettype($errorMessage)), __LINE__);
        }
        if (is_null($errorMessage) || (is_array($errorMessage) && empty($errorMessage))) {
            unset($this->ErrorMessage);
        } else {
            $this->ErrorMessage = $errorMessage;
        }
        return $this;
    }
    /**
     * Get NumberOfInValidPayees value
     * @return int|null
     */
    public function getNumberOfInValidPayees()
    {
        return $this->NumberOfInValidPayees;
    }
    /**
     * Set NumberOfInValidPayees value
     * @param int $numberOfInValidPayees
     * @return \StructType\PayeeInfoValidationResult
     */
    public function setNumberOfInValidPayees($numberOfInValidPayees = null)
    {
        // validation for constraint: int
        if (!is_null($numberOfInValidPayees) && !(is_int($numberOfInValidPayees) || ctype_digit($numberOfInValidPayees))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numberOfInValidPayees, true), gettype($numberOfInValidPayees)), __LINE__);
        }
        $this->NumberOfInValidPayees = $numberOfInValidPayees;
        return $this;
    }
    /**
     * Get NumberOfPayees value
     * @return int|null
     */
    public function getNumberOfPayees()
    {
        return $this->NumberOfPayees;
    }
    /**
     * Set NumberOfPayees value
     * @param int $numberOfPayees
     * @return \StructType\PayeeInfoValidationResult
     */
    public function setNumberOfPayees($numberOfPayees = null)
    {
        // validation for constraint: int
        if (!is_null($numberOfPayees) && !(is_int($numberOfPayees) || ctype_digit($numberOfPayees))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numberOfPayees, true), gettype($numberOfPayees)), __LINE__);
        }
        $this->NumberOfPayees = $numberOfPayees;
        return $this;
    }
    /**
     * Get NumberOfValidPayees value
     * @return int|null
     */
    public function getNumberOfValidPayees()
    {
        return $this->NumberOfValidPayees;
    }
    /**
     * Set NumberOfValidPayees value
     * @param int $numberOfValidPayees
     * @return \StructType\PayeeInfoValidationResult
     */
    public function setNumberOfValidPayees($numberOfValidPayees = null)
    {
        // validation for constraint: int
        if (!is_null($numberOfValidPayees) && !(is_int($numberOfValidPayees) || ctype_digit($numberOfValidPayees))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numberOfValidPayees, true), gettype($numberOfValidPayees)), __LINE__);
        }
        $this->NumberOfValidPayees = $numberOfValidPayees;
        return $this;
    }
    /**
     * Get ValidationDetail value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfValidationDetails|null
     */
    public function getValidationDetail()
    {
        return isset($this->ValidationDetail) ? $this->ValidationDetail : null;
    }
    /**
     * Set ValidationDetail value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfValidationDetails $validationDetail
     * @return \StructType\PayeeInfoValidationResult
     */
    public function setValidationDetail(\ArrayType\ArrayOfValidationDetails $validationDetail = null)
    {
        if (is_null($validationDetail) || (is_array($validationDetail) && empty($validationDetail))) {
            unset($this->ValidationDetail);
        } else {
            $this->ValidationDetail = $validationDetail;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PayeeInfoValidationResult
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
