<?php

namespace EnumType;

/**
 * This class stands for OriginatorType EnumType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:OriginatorType
 * @subpackage Enumerations
 */
class OriginatorType
{
    /**
     * Constant for value 'Consumer'
     * @return string 'Consumer'
     */
    const VALUE_CONSUMER = 'Consumer';
    /**
     * Constant for value 'Business'
     * @return string 'Business'
     */
    const VALUE_BUSINESS = 'Business';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_CONSUMER
     * @uses self::VALUE_BUSINESS
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_CONSUMER,
            self::VALUE_BUSINESS,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
