<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AccountDetails StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:AccountDetails
 * @subpackage Structs
 */
class AccountDetails extends AbstractStructBase
{
    /**
     * The AccountCurrencyID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AccountCurrencyID;
    /**
     * The AccountNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AccountNumber;
    /**
     * The BalanceAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $BalanceAmount;
    /**
     * Constructor method for AccountDetails
     * @uses AccountDetails::setAccountCurrencyID()
     * @uses AccountDetails::setAccountNumber()
     * @uses AccountDetails::setBalanceAmount()
     * @param string $accountCurrencyID
     * @param string $accountNumber
     * @param float $balanceAmount
     */
    public function __construct($accountCurrencyID = null, $accountNumber = null, $balanceAmount = null)
    {
        $this
            ->setAccountCurrencyID($accountCurrencyID)
            ->setAccountNumber($accountNumber)
            ->setBalanceAmount($balanceAmount);
    }
    /**
     * Get AccountCurrencyID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAccountCurrencyID()
    {
        return isset($this->AccountCurrencyID) ? $this->AccountCurrencyID : null;
    }
    /**
     * Set AccountCurrencyID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $accountCurrencyID
     * @return \StructType\AccountDetails
     */
    public function setAccountCurrencyID($accountCurrencyID = null)
    {
        // validation for constraint: string
        if (!is_null($accountCurrencyID) && !is_string($accountCurrencyID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accountCurrencyID, true), gettype($accountCurrencyID)), __LINE__);
        }
        if (is_null($accountCurrencyID) || (is_array($accountCurrencyID) && empty($accountCurrencyID))) {
            unset($this->AccountCurrencyID);
        } else {
            $this->AccountCurrencyID = $accountCurrencyID;
        }
        return $this;
    }
    /**
     * Get AccountNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAccountNumber()
    {
        return isset($this->AccountNumber) ? $this->AccountNumber : null;
    }
    /**
     * Set AccountNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $accountNumber
     * @return \StructType\AccountDetails
     */
    public function setAccountNumber($accountNumber = null)
    {
        // validation for constraint: string
        if (!is_null($accountNumber) && !is_string($accountNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accountNumber, true), gettype($accountNumber)), __LINE__);
        }
        if (is_null($accountNumber) || (is_array($accountNumber) && empty($accountNumber))) {
            unset($this->AccountNumber);
        } else {
            $this->AccountNumber = $accountNumber;
        }
        return $this;
    }
    /**
     * Get BalanceAmount value
     * @return float|null
     */
    public function getBalanceAmount()
    {
        return $this->BalanceAmount;
    }
    /**
     * Set BalanceAmount value
     * @param float $balanceAmount
     * @return \StructType\AccountDetails
     */
    public function setBalanceAmount($balanceAmount = null)
    {
        // validation for constraint: float
        if (!is_null($balanceAmount) && !(is_float($balanceAmount) || is_numeric($balanceAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($balanceAmount, true), gettype($balanceAmount)), __LINE__);
        }
        $this->BalanceAmount = $balanceAmount;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AccountDetails
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
