<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetDealPendingApprovalResult StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:GetDealPendingApprovalResult
 * @subpackage Structs
 */
class GetDealPendingApprovalResult extends AbstractStructBase
{
    /**
     * The Deals
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfDealPendingApprovalDetails
     */
    public $Deals;
    /**
     * The ErrorCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ErrorCode;
    /**
     * The ErrorMessage
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ErrorMessage;
    /**
     * The NumberOfDeals
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $NumberOfDeals;
    /**
     * Constructor method for GetDealPendingApprovalResult
     * @uses GetDealPendingApprovalResult::setDeals()
     * @uses GetDealPendingApprovalResult::setErrorCode()
     * @uses GetDealPendingApprovalResult::setErrorMessage()
     * @uses GetDealPendingApprovalResult::setNumberOfDeals()
     * @param \ArrayType\ArrayOfDealPendingApprovalDetails $deals
     * @param int $errorCode
     * @param string $errorMessage
     * @param int $numberOfDeals
     */
    public function __construct(\ArrayType\ArrayOfDealPendingApprovalDetails $deals = null, $errorCode = null, $errorMessage = null, $numberOfDeals = null)
    {
        $this
            ->setDeals($deals)
            ->setErrorCode($errorCode)
            ->setErrorMessage($errorMessage)
            ->setNumberOfDeals($numberOfDeals);
    }
    /**
     * Get Deals value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfDealPendingApprovalDetails|null
     */
    public function getDeals()
    {
        return isset($this->Deals) ? $this->Deals : null;
    }
    /**
     * Set Deals value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfDealPendingApprovalDetails $deals
     * @return \StructType\GetDealPendingApprovalResult
     */
    public function setDeals(\ArrayType\ArrayOfDealPendingApprovalDetails $deals = null)
    {
        if (is_null($deals) || (is_array($deals) && empty($deals))) {
            unset($this->Deals);
        } else {
            $this->Deals = $deals;
        }
        return $this;
    }
    /**
     * Get ErrorCode value
     * @return int|null
     */
    public function getErrorCode()
    {
        return $this->ErrorCode;
    }
    /**
     * Set ErrorCode value
     * @param int $errorCode
     * @return \StructType\GetDealPendingApprovalResult
     */
    public function setErrorCode($errorCode = null)
    {
        // validation for constraint: int
        if (!is_null($errorCode) && !(is_int($errorCode) || ctype_digit($errorCode))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($errorCode, true), gettype($errorCode)), __LINE__);
        }
        $this->ErrorCode = $errorCode;
        return $this;
    }
    /**
     * Get ErrorMessage value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getErrorMessage()
    {
        return isset($this->ErrorMessage) ? $this->ErrorMessage : null;
    }
    /**
     * Set ErrorMessage value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $errorMessage
     * @return \StructType\GetDealPendingApprovalResult
     */
    public function setErrorMessage($errorMessage = null)
    {
        // validation for constraint: string
        if (!is_null($errorMessage) && !is_string($errorMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($errorMessage, true), gettype($errorMessage)), __LINE__);
        }
        if (is_null($errorMessage) || (is_array($errorMessage) && empty($errorMessage))) {
            unset($this->ErrorMessage);
        } else {
            $this->ErrorMessage = $errorMessage;
        }
        return $this;
    }
    /**
     * Get NumberOfDeals value
     * @return int|null
     */
    public function getNumberOfDeals()
    {
        return $this->NumberOfDeals;
    }
    /**
     * Set NumberOfDeals value
     * @param int $numberOfDeals
     * @return \StructType\GetDealPendingApprovalResult
     */
    public function setNumberOfDeals($numberOfDeals = null)
    {
        // validation for constraint: int
        if (!is_null($numberOfDeals) && !(is_int($numberOfDeals) || ctype_digit($numberOfDeals))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numberOfDeals, true), gettype($numberOfDeals)), __LINE__);
        }
        $this->NumberOfDeals = $numberOfDeals;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetDealPendingApprovalResult
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
