<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the fist needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientbase class each generated ServiceType class extends this class
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://afxlink-test.ascendantfx.com/AFXLinkCustom.svc?wsdl',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc....
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://afxlink-test.ascendantfx.com/AFXLinkCustom.svc?wsdl',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => ClassMap::get(),
);
/**
 * Samples for Get ServiceType
 */
$get = new \ServiceType\Get($options);
/**
 * Sample call for GetQuote operation/method
 */
if ($get->GetQuote(new \StructType\GetQuote()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetAccountBalance operation/method
 */
if ($get->GetAccountBalance(new \StructType\GetAccountBalance()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetPayeeInfo operation/method
 */
if ($get->GetPayeeInfo(new \StructType\GetPayeeInfo()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetAccountActivity operation/method
 */
if ($get->GetAccountActivity(new \StructType\GetAccountActivity()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetQuoteTBA operation/method
 */
if ($get->GetQuoteTBA(new \StructType\GetQuoteTBA()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetIncomingPaymentInstruction operation/method
 */
if ($get->GetIncomingPaymentInstruction(new \StructType\GetIncomingPaymentInstruction()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Samples for Accept ServiceType
 */
$accept = new \ServiceType\Accept($options);
/**
 * Sample call for AcceptQuote operation/method
 */
if ($accept->AcceptQuote(new \StructType\AcceptQuote()) !== false) {
    print_r($accept->getResult());
} else {
    print_r($accept->getLastError());
}
/**
 * Sample call for AcceptAndSubmitDealTBA operation/method
 */
if ($accept->AcceptAndSubmitDealTBA(new \StructType\AcceptAndSubmitDealTBA()) !== false) {
    print_r($accept->getResult());
} else {
    print_r($accept->getLastError());
}
/**
 * Samples for Submit ServiceType
 */
$submit = new \ServiceType\Submit($options);
/**
 * Sample call for SubmitDeal operation/method
 */
if ($submit->SubmitDeal(new \StructType\SubmitDeal()) !== false) {
    print_r($submit->getResult());
} else {
    print_r($submit->getLastError());
}
/**
 * Sample call for SubmitIncomingDeal operation/method
 */
if ($submit->SubmitIncomingDeal(new \StructType\SubmitIncomingDeal()) !== false) {
    print_r($submit->getResult());
} else {
    print_r($submit->getLastError());
}
/**
 * Samples for Validate ServiceType
 */
$validate = new \ServiceType\Validate($options);
/**
 * Sample call for ValidateIBAN operation/method
 */
if ($validate->ValidateIBAN(new \StructType\ValidateIBAN()) !== false) {
    print_r($validate->getResult());
} else {
    print_r($validate->getLastError());
}
/**
 * Samples for Add ServiceType
 */
$add = new \ServiceType\Add($options);
/**
 * Sample call for AddPayee operation/method
 */
if ($add->AddPayee(new \StructType\AddPayee()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Samples for Update ServiceType
 */
$update = new \ServiceType\Update($options);
/**
 * Sample call for UpdatePayee operation/method
 */
if ($update->UpdatePayee(new \StructType\UpdatePayee()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Samples for Delete ServiceType
 */
$delete = new \ServiceType\Delete($options);
/**
 * Sample call for DeletePayee operation/method
 */
if ($delete->DeletePayee(new \StructType\DeletePayee()) !== false) {
    print_r($delete->getResult());
} else {
    print_r($delete->getLastError());
}
/**
 * Samples for Post ServiceType
 */
$post = new \ServiceType\Post($options);
/**
 * Sample call for PostDeal operation/method
 */
if ($post->PostDeal(new \StructType\PostDeal()) !== false) {
    print_r($post->getResult());
} else {
    print_r($post->getLastError());
}
/**
 * Sample call for PostDealConfirmation operation/method
 */
if ($post->PostDealConfirmation(new \StructType\PostDealConfirmation()) !== false) {
    print_r($post->getResult());
} else {
    print_r($post->getLastError());
}
/**
 * Samples for Payee ServiceType
 */
$payee = new \ServiceType\Payee($options);
/**
 * Sample call for PayeeInfoValidation operation/method
 */
if ($payee->PayeeInfoValidation(new \StructType\PayeeInfoValidation()) !== false) {
    print_r($payee->getResult());
} else {
    print_r($payee->getLastError());
}
/**
 * Samples for Incoming ServiceType
 */
$incoming = new \ServiceType\Incoming($options);
/**
 * Sample call for IncomingFundStatusCheck operation/method
 */
if ($incoming->IncomingFundStatusCheck(new \StructType\IncomingFundStatusCheck()) !== false) {
    print_r($incoming->getResult());
} else {
    print_r($incoming->getLastError());
}
