<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetAccountBalanceResult StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:GetAccountBalanceResult
 * @subpackage Structs
 */
class GetAccountBalanceResult extends AbstractStructBase
{
    /**
     * The Account
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfAccountDetails
     */
    public $Account;
    /**
     * The ErrorCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ErrorCode;
    /**
     * The ErrorMessage
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ErrorMessage;
    /**
     * The NumberOfAccount
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $NumberOfAccount;
    /**
     * Constructor method for GetAccountBalanceResult
     * @uses GetAccountBalanceResult::setAccount()
     * @uses GetAccountBalanceResult::setErrorCode()
     * @uses GetAccountBalanceResult::setErrorMessage()
     * @uses GetAccountBalanceResult::setNumberOfAccount()
     * @param \ArrayType\ArrayOfAccountDetails $account
     * @param int $errorCode
     * @param string $errorMessage
     * @param string $numberOfAccount
     */
    public function __construct(\ArrayType\ArrayOfAccountDetails $account = null, $errorCode = null, $errorMessage = null, $numberOfAccount = null)
    {
        $this
            ->setAccount($account)
            ->setErrorCode($errorCode)
            ->setErrorMessage($errorMessage)
            ->setNumberOfAccount($numberOfAccount);
    }
    /**
     * Get Account value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfAccountDetails|null
     */
    public function getAccount()
    {
        return isset($this->Account) ? $this->Account : null;
    }
    /**
     * Set Account value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfAccountDetails $account
     * @return \StructType\GetAccountBalanceResult
     */
    public function setAccount(\ArrayType\ArrayOfAccountDetails $account = null)
    {
        if (is_null($account) || (is_array($account) && empty($account))) {
            unset($this->Account);
        } else {
            $this->Account = $account;
        }
        return $this;
    }
    /**
     * Get ErrorCode value
     * @return int|null
     */
    public function getErrorCode()
    {
        return $this->ErrorCode;
    }
    /**
     * Set ErrorCode value
     * @param int $errorCode
     * @return \StructType\GetAccountBalanceResult
     */
    public function setErrorCode($errorCode = null)
    {
        // validation for constraint: int
        if (!is_null($errorCode) && !is_numeric($errorCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($errorCode)), __LINE__);
        }
        $this->ErrorCode = $errorCode;
        return $this;
    }
    /**
     * Get ErrorMessage value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getErrorMessage()
    {
        return isset($this->ErrorMessage) ? $this->ErrorMessage : null;
    }
    /**
     * Set ErrorMessage value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $errorMessage
     * @return \StructType\GetAccountBalanceResult
     */
    public function setErrorMessage($errorMessage = null)
    {
        // validation for constraint: string
        if (!is_null($errorMessage) && !is_string($errorMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($errorMessage)), __LINE__);
        }
        if (is_null($errorMessage) || (is_array($errorMessage) && empty($errorMessage))) {
            unset($this->ErrorMessage);
        } else {
            $this->ErrorMessage = $errorMessage;
        }
        return $this;
    }
    /**
     * Get NumberOfAccount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNumberOfAccount()
    {
        return isset($this->NumberOfAccount) ? $this->NumberOfAccount : null;
    }
    /**
     * Set NumberOfAccount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $numberOfAccount
     * @return \StructType\GetAccountBalanceResult
     */
    public function setNumberOfAccount($numberOfAccount = null)
    {
        // validation for constraint: string
        if (!is_null($numberOfAccount) && !is_string($numberOfAccount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($numberOfAccount)), __LINE__);
        }
        if (is_null($numberOfAccount) || (is_array($numberOfAccount) && empty($numberOfAccount))) {
            unset($this->NumberOfAccount);
        } else {
            $this->NumberOfAccount = $numberOfAccount;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetAccountBalanceResult
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
