<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Deal StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:Deal
 * @subpackage Structs
 */
class Deal extends AbstractStructBase
{
    /**
     * The Direction
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Direction;
    /**
     * The Fee
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $Fee;
    /**
     * The FxAmount
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $FxAmount;
    /**
     * The FxCurrencyID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FxCurrencyID;
    /**
     * The OriginatorType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OriginatorType;
    /**
     * The PaymentMethod
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PaymentMethod;
    /**
     * The PaymentSequenceNo
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $PaymentSequenceNo;
    /**
     * The Rate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $Rate;
    /**
     * The SettlementAmount
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $SettlementAmount;
    /**
     * The SettlementCurrencyID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SettlementCurrencyID;
    /**
     * The TotalSettlementAmount
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $TotalSettlementAmount;
    /**
     * Constructor method for Deal
     * @uses Deal::setDirection()
     * @uses Deal::setFee()
     * @uses Deal::setFxAmount()
     * @uses Deal::setFxCurrencyID()
     * @uses Deal::setOriginatorType()
     * @uses Deal::setPaymentMethod()
     * @uses Deal::setPaymentSequenceNo()
     * @uses Deal::setRate()
     * @uses Deal::setSettlementAmount()
     * @uses Deal::setSettlementCurrencyID()
     * @uses Deal::setTotalSettlementAmount()
     * @param string $direction
     * @param float $fee
     * @param float $fxAmount
     * @param string $fxCurrencyID
     * @param string $originatorType
     * @param string $paymentMethod
     * @param int $paymentSequenceNo
     * @param float $rate
     * @param float $settlementAmount
     * @param string $settlementCurrencyID
     * @param float $totalSettlementAmount
     */
    public function __construct($direction = null, $fee = null, $fxAmount = null, $fxCurrencyID = null, $originatorType = null, $paymentMethod = null, $paymentSequenceNo = null, $rate = null, $settlementAmount = null, $settlementCurrencyID = null, $totalSettlementAmount = null)
    {
        $this
            ->setDirection($direction)
            ->setFee($fee)
            ->setFxAmount($fxAmount)
            ->setFxCurrencyID($fxCurrencyID)
            ->setOriginatorType($originatorType)
            ->setPaymentMethod($paymentMethod)
            ->setPaymentSequenceNo($paymentSequenceNo)
            ->setRate($rate)
            ->setSettlementAmount($settlementAmount)
            ->setSettlementCurrencyID($settlementCurrencyID)
            ->setTotalSettlementAmount($totalSettlementAmount);
    }
    /**
     * Get Direction value
     * @return string|null
     */
    public function getDirection()
    {
        return $this->Direction;
    }
    /**
     * Set Direction value
     * @uses \EnumType\Direction::valueIsValid()
     * @uses \EnumType\Direction::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $direction
     * @return \StructType\Deal
     */
    public function setDirection($direction = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Direction::valueIsValid($direction)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $direction, implode(', ', \EnumType\Direction::getValidValues())), __LINE__);
        }
        $this->Direction = $direction;
        return $this;
    }
    /**
     * Get Fee value
     * @return float|null
     */
    public function getFee()
    {
        return $this->Fee;
    }
    /**
     * Set Fee value
     * @param float $fee
     * @return \StructType\Deal
     */
    public function setFee($fee = null)
    {
        $this->Fee = $fee;
        return $this;
    }
    /**
     * Get FxAmount value
     * @return float|null
     */
    public function getFxAmount()
    {
        return $this->FxAmount;
    }
    /**
     * Set FxAmount value
     * @param float $fxAmount
     * @return \StructType\Deal
     */
    public function setFxAmount($fxAmount = null)
    {
        $this->FxAmount = $fxAmount;
        return $this;
    }
    /**
     * Get FxCurrencyID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFxCurrencyID()
    {
        return isset($this->FxCurrencyID) ? $this->FxCurrencyID : null;
    }
    /**
     * Set FxCurrencyID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $fxCurrencyID
     * @return \StructType\Deal
     */
    public function setFxCurrencyID($fxCurrencyID = null)
    {
        // validation for constraint: string
        if (!is_null($fxCurrencyID) && !is_string($fxCurrencyID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($fxCurrencyID)), __LINE__);
        }
        if (is_null($fxCurrencyID) || (is_array($fxCurrencyID) && empty($fxCurrencyID))) {
            unset($this->FxCurrencyID);
        } else {
            $this->FxCurrencyID = $fxCurrencyID;
        }
        return $this;
    }
    /**
     * Get OriginatorType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOriginatorType()
    {
        return isset($this->OriginatorType) ? $this->OriginatorType : null;
    }
    /**
     * Set OriginatorType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \EnumType\OriginatorType::valueIsValid()
     * @uses \EnumType\OriginatorType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $originatorType
     * @return \StructType\Deal
     */
    public function setOriginatorType($originatorType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\OriginatorType::valueIsValid($originatorType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $originatorType, implode(', ', \EnumType\OriginatorType::getValidValues())), __LINE__);
        }
        if (is_null($originatorType) || (is_array($originatorType) && empty($originatorType))) {
            unset($this->OriginatorType);
        } else {
            $this->OriginatorType = $originatorType;
        }
        return $this;
    }
    /**
     * Get PaymentMethod value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPaymentMethod()
    {
        return isset($this->PaymentMethod) ? $this->PaymentMethod : null;
    }
    /**
     * Set PaymentMethod value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $paymentMethod
     * @return \StructType\Deal
     */
    public function setPaymentMethod($paymentMethod = null)
    {
        // validation for constraint: string
        if (!is_null($paymentMethod) && !is_string($paymentMethod)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($paymentMethod)), __LINE__);
        }
        if (is_null($paymentMethod) || (is_array($paymentMethod) && empty($paymentMethod))) {
            unset($this->PaymentMethod);
        } else {
            $this->PaymentMethod = $paymentMethod;
        }
        return $this;
    }
    /**
     * Get PaymentSequenceNo value
     * @return int|null
     */
    public function getPaymentSequenceNo()
    {
        return $this->PaymentSequenceNo;
    }
    /**
     * Set PaymentSequenceNo value
     * @param int $paymentSequenceNo
     * @return \StructType\Deal
     */
    public function setPaymentSequenceNo($paymentSequenceNo = null)
    {
        // validation for constraint: int
        if (!is_null($paymentSequenceNo) && !is_numeric($paymentSequenceNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($paymentSequenceNo)), __LINE__);
        }
        $this->PaymentSequenceNo = $paymentSequenceNo;
        return $this;
    }
    /**
     * Get Rate value
     * @return float|null
     */
    public function getRate()
    {
        return $this->Rate;
    }
    /**
     * Set Rate value
     * @param float $rate
     * @return \StructType\Deal
     */
    public function setRate($rate = null)
    {
        $this->Rate = $rate;
        return $this;
    }
    /**
     * Get SettlementAmount value
     * @return float|null
     */
    public function getSettlementAmount()
    {
        return $this->SettlementAmount;
    }
    /**
     * Set SettlementAmount value
     * @param float $settlementAmount
     * @return \StructType\Deal
     */
    public function setSettlementAmount($settlementAmount = null)
    {
        $this->SettlementAmount = $settlementAmount;
        return $this;
    }
    /**
     * Get SettlementCurrencyID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSettlementCurrencyID()
    {
        return isset($this->SettlementCurrencyID) ? $this->SettlementCurrencyID : null;
    }
    /**
     * Set SettlementCurrencyID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $settlementCurrencyID
     * @return \StructType\Deal
     */
    public function setSettlementCurrencyID($settlementCurrencyID = null)
    {
        // validation for constraint: string
        if (!is_null($settlementCurrencyID) && !is_string($settlementCurrencyID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($settlementCurrencyID)), __LINE__);
        }
        if (is_null($settlementCurrencyID) || (is_array($settlementCurrencyID) && empty($settlementCurrencyID))) {
            unset($this->SettlementCurrencyID);
        } else {
            $this->SettlementCurrencyID = $settlementCurrencyID;
        }
        return $this;
    }
    /**
     * Get TotalSettlementAmount value
     * @return float|null
     */
    public function getTotalSettlementAmount()
    {
        return $this->TotalSettlementAmount;
    }
    /**
     * Set TotalSettlementAmount value
     * @param float $totalSettlementAmount
     * @return \StructType\Deal
     */
    public function setTotalSettlementAmount($totalSettlementAmount = null)
    {
        $this->TotalSettlementAmount = $totalSettlementAmount;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Deal
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
