<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InstructionToSender StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:InstructionToSender
 * @subpackage Structs
 */
class InstructionToSender extends AbstractStructBase
{
    /**
     * The AccountAddress
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AccountAddress;
    /**
     * The AccountName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AccountName;
    /**
     * The AccountNo
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AccountNo;
    /**
     * The Amount
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $Amount;
    /**
     * The BankAddress
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $BankAddress;
    /**
     * The BankName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $BankName;
    /**
     * The CurrencyID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CurrencyID;
    /**
     * The LocalRoutingCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LocalRoutingCode;
    /**
     * The Memo1
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Memo1;
    /**
     * The Memo2
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Memo2;
    /**
     * The SwiftCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SwiftCode;
    /**
     * Constructor method for InstructionToSender
     * @uses InstructionToSender::setAccountAddress()
     * @uses InstructionToSender::setAccountName()
     * @uses InstructionToSender::setAccountNo()
     * @uses InstructionToSender::setAmount()
     * @uses InstructionToSender::setBankAddress()
     * @uses InstructionToSender::setBankName()
     * @uses InstructionToSender::setCurrencyID()
     * @uses InstructionToSender::setLocalRoutingCode()
     * @uses InstructionToSender::setMemo1()
     * @uses InstructionToSender::setMemo2()
     * @uses InstructionToSender::setSwiftCode()
     * @param string $accountAddress
     * @param string $accountName
     * @param string $accountNo
     * @param float $amount
     * @param string $bankAddress
     * @param string $bankName
     * @param string $currencyID
     * @param string $localRoutingCode
     * @param string $memo1
     * @param string $memo2
     * @param string $swiftCode
     */
    public function __construct($accountAddress = null, $accountName = null, $accountNo = null, $amount = null, $bankAddress = null, $bankName = null, $currencyID = null, $localRoutingCode = null, $memo1 = null, $memo2 = null, $swiftCode = null)
    {
        $this
            ->setAccountAddress($accountAddress)
            ->setAccountName($accountName)
            ->setAccountNo($accountNo)
            ->setAmount($amount)
            ->setBankAddress($bankAddress)
            ->setBankName($bankName)
            ->setCurrencyID($currencyID)
            ->setLocalRoutingCode($localRoutingCode)
            ->setMemo1($memo1)
            ->setMemo2($memo2)
            ->setSwiftCode($swiftCode);
    }
    /**
     * Get AccountAddress value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAccountAddress()
    {
        return isset($this->AccountAddress) ? $this->AccountAddress : null;
    }
    /**
     * Set AccountAddress value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $accountAddress
     * @return \StructType\InstructionToSender
     */
    public function setAccountAddress($accountAddress = null)
    {
        // validation for constraint: string
        if (!is_null($accountAddress) && !is_string($accountAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($accountAddress)), __LINE__);
        }
        if (is_null($accountAddress) || (is_array($accountAddress) && empty($accountAddress))) {
            unset($this->AccountAddress);
        } else {
            $this->AccountAddress = $accountAddress;
        }
        return $this;
    }
    /**
     * Get AccountName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAccountName()
    {
        return isset($this->AccountName) ? $this->AccountName : null;
    }
    /**
     * Set AccountName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $accountName
     * @return \StructType\InstructionToSender
     */
    public function setAccountName($accountName = null)
    {
        // validation for constraint: string
        if (!is_null($accountName) && !is_string($accountName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($accountName)), __LINE__);
        }
        if (is_null($accountName) || (is_array($accountName) && empty($accountName))) {
            unset($this->AccountName);
        } else {
            $this->AccountName = $accountName;
        }
        return $this;
    }
    /**
     * Get AccountNo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAccountNo()
    {
        return isset($this->AccountNo) ? $this->AccountNo : null;
    }
    /**
     * Set AccountNo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $accountNo
     * @return \StructType\InstructionToSender
     */
    public function setAccountNo($accountNo = null)
    {
        // validation for constraint: string
        if (!is_null($accountNo) && !is_string($accountNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($accountNo)), __LINE__);
        }
        if (is_null($accountNo) || (is_array($accountNo) && empty($accountNo))) {
            unset($this->AccountNo);
        } else {
            $this->AccountNo = $accountNo;
        }
        return $this;
    }
    /**
     * Get Amount value
     * @return float|null
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param float $amount
     * @return \StructType\InstructionToSender
     */
    public function setAmount($amount = null)
    {
        $this->Amount = $amount;
        return $this;
    }
    /**
     * Get BankAddress value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBankAddress()
    {
        return isset($this->BankAddress) ? $this->BankAddress : null;
    }
    /**
     * Set BankAddress value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bankAddress
     * @return \StructType\InstructionToSender
     */
    public function setBankAddress($bankAddress = null)
    {
        // validation for constraint: string
        if (!is_null($bankAddress) && !is_string($bankAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($bankAddress)), __LINE__);
        }
        if (is_null($bankAddress) || (is_array($bankAddress) && empty($bankAddress))) {
            unset($this->BankAddress);
        } else {
            $this->BankAddress = $bankAddress;
        }
        return $this;
    }
    /**
     * Get BankName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBankName()
    {
        return isset($this->BankName) ? $this->BankName : null;
    }
    /**
     * Set BankName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bankName
     * @return \StructType\InstructionToSender
     */
    public function setBankName($bankName = null)
    {
        // validation for constraint: string
        if (!is_null($bankName) && !is_string($bankName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($bankName)), __LINE__);
        }
        if (is_null($bankName) || (is_array($bankName) && empty($bankName))) {
            unset($this->BankName);
        } else {
            $this->BankName = $bankName;
        }
        return $this;
    }
    /**
     * Get CurrencyID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCurrencyID()
    {
        return isset($this->CurrencyID) ? $this->CurrencyID : null;
    }
    /**
     * Set CurrencyID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $currencyID
     * @return \StructType\InstructionToSender
     */
    public function setCurrencyID($currencyID = null)
    {
        // validation for constraint: string
        if (!is_null($currencyID) && !is_string($currencyID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($currencyID)), __LINE__);
        }
        if (is_null($currencyID) || (is_array($currencyID) && empty($currencyID))) {
            unset($this->CurrencyID);
        } else {
            $this->CurrencyID = $currencyID;
        }
        return $this;
    }
    /**
     * Get LocalRoutingCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLocalRoutingCode()
    {
        return isset($this->LocalRoutingCode) ? $this->LocalRoutingCode : null;
    }
    /**
     * Set LocalRoutingCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $localRoutingCode
     * @return \StructType\InstructionToSender
     */
    public function setLocalRoutingCode($localRoutingCode = null)
    {
        // validation for constraint: string
        if (!is_null($localRoutingCode) && !is_string($localRoutingCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($localRoutingCode)), __LINE__);
        }
        if (is_null($localRoutingCode) || (is_array($localRoutingCode) && empty($localRoutingCode))) {
            unset($this->LocalRoutingCode);
        } else {
            $this->LocalRoutingCode = $localRoutingCode;
        }
        return $this;
    }
    /**
     * Get Memo1 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMemo1()
    {
        return isset($this->Memo1) ? $this->Memo1 : null;
    }
    /**
     * Set Memo1 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $memo1
     * @return \StructType\InstructionToSender
     */
    public function setMemo1($memo1 = null)
    {
        // validation for constraint: string
        if (!is_null($memo1) && !is_string($memo1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($memo1)), __LINE__);
        }
        if (is_null($memo1) || (is_array($memo1) && empty($memo1))) {
            unset($this->Memo1);
        } else {
            $this->Memo1 = $memo1;
        }
        return $this;
    }
    /**
     * Get Memo2 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMemo2()
    {
        return isset($this->Memo2) ? $this->Memo2 : null;
    }
    /**
     * Set Memo2 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $memo2
     * @return \StructType\InstructionToSender
     */
    public function setMemo2($memo2 = null)
    {
        // validation for constraint: string
        if (!is_null($memo2) && !is_string($memo2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($memo2)), __LINE__);
        }
        if (is_null($memo2) || (is_array($memo2) && empty($memo2))) {
            unset($this->Memo2);
        } else {
            $this->Memo2 = $memo2;
        }
        return $this;
    }
    /**
     * Get SwiftCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSwiftCode()
    {
        return isset($this->SwiftCode) ? $this->SwiftCode : null;
    }
    /**
     * Set SwiftCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $swiftCode
     * @return \StructType\InstructionToSender
     */
    public function setSwiftCode($swiftCode = null)
    {
        // validation for constraint: string
        if (!is_null($swiftCode) && !is_string($swiftCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($swiftCode)), __LINE__);
        }
        if (is_null($swiftCode) || (is_array($swiftCode) && empty($swiftCode))) {
            unset($this->SwiftCode);
        } else {
            $this->SwiftCode = $swiftCode;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\InstructionToSender
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
