<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PostDealConfirmationRequest StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:PostDealConfirmationRequest
 * @subpackage Structs
 */
class PostDealConfirmationRequest extends AbstractStructBase
{
    /**
     * The AFXDealID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AFXDealID;
    /**
     * The AFXPaymentID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AFXPaymentID;
    /**
     * The DealPostCallID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $DealPostCallID;
    /**
     * The DealPostConfirm
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $DealPostConfirm;
    /**
     * The MethodID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $MethodID;
    /**
     * The OrgID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OrgID;
    /**
     * Constructor method for PostDealConfirmationRequest
     * @uses PostDealConfirmationRequest::setAFXDealID()
     * @uses PostDealConfirmationRequest::setAFXPaymentID()
     * @uses PostDealConfirmationRequest::setDealPostCallID()
     * @uses PostDealConfirmationRequest::setDealPostConfirm()
     * @uses PostDealConfirmationRequest::setMethodID()
     * @uses PostDealConfirmationRequest::setOrgID()
     * @param string $aFXDealID
     * @param string $aFXPaymentID
     * @param int $dealPostCallID
     * @param string $dealPostConfirm
     * @param string $methodID
     * @param string $orgID
     */
    public function __construct($aFXDealID = null, $aFXPaymentID = null, $dealPostCallID = null, $dealPostConfirm = null, $methodID = null, $orgID = null)
    {
        $this
            ->setAFXDealID($aFXDealID)
            ->setAFXPaymentID($aFXPaymentID)
            ->setDealPostCallID($dealPostCallID)
            ->setDealPostConfirm($dealPostConfirm)
            ->setMethodID($methodID)
            ->setOrgID($orgID);
    }
    /**
     * Get AFXDealID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAFXDealID()
    {
        return isset($this->AFXDealID) ? $this->AFXDealID : null;
    }
    /**
     * Set AFXDealID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $aFXDealID
     * @return \StructType\PostDealConfirmationRequest
     */
    public function setAFXDealID($aFXDealID = null)
    {
        // validation for constraint: string
        if (!is_null($aFXDealID) && !is_string($aFXDealID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($aFXDealID)), __LINE__);
        }
        if (is_null($aFXDealID) || (is_array($aFXDealID) && empty($aFXDealID))) {
            unset($this->AFXDealID);
        } else {
            $this->AFXDealID = $aFXDealID;
        }
        return $this;
    }
    /**
     * Get AFXPaymentID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAFXPaymentID()
    {
        return isset($this->AFXPaymentID) ? $this->AFXPaymentID : null;
    }
    /**
     * Set AFXPaymentID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $aFXPaymentID
     * @return \StructType\PostDealConfirmationRequest
     */
    public function setAFXPaymentID($aFXPaymentID = null)
    {
        // validation for constraint: string
        if (!is_null($aFXPaymentID) && !is_string($aFXPaymentID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($aFXPaymentID)), __LINE__);
        }
        if (is_null($aFXPaymentID) || (is_array($aFXPaymentID) && empty($aFXPaymentID))) {
            unset($this->AFXPaymentID);
        } else {
            $this->AFXPaymentID = $aFXPaymentID;
        }
        return $this;
    }
    /**
     * Get DealPostCallID value
     * @return int|null
     */
    public function getDealPostCallID()
    {
        return $this->DealPostCallID;
    }
    /**
     * Set DealPostCallID value
     * @param int $dealPostCallID
     * @return \StructType\PostDealConfirmationRequest
     */
    public function setDealPostCallID($dealPostCallID = null)
    {
        // validation for constraint: int
        if (!is_null($dealPostCallID) && !is_numeric($dealPostCallID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($dealPostCallID)), __LINE__);
        }
        $this->DealPostCallID = $dealPostCallID;
        return $this;
    }
    /**
     * Get DealPostConfirm value
     * @return string|null
     */
    public function getDealPostConfirm()
    {
        return $this->DealPostConfirm;
    }
    /**
     * Set DealPostConfirm value
     * @uses \EnumType\DealPostConfirm::valueIsValid()
     * @uses \EnumType\DealPostConfirm::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $dealPostConfirm
     * @return \StructType\PostDealConfirmationRequest
     */
    public function setDealPostConfirm($dealPostConfirm = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\DealPostConfirm::valueIsValid($dealPostConfirm)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $dealPostConfirm, implode(', ', \EnumType\DealPostConfirm::getValidValues())), __LINE__);
        }
        $this->DealPostConfirm = $dealPostConfirm;
        return $this;
    }
    /**
     * Get MethodID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMethodID()
    {
        return isset($this->MethodID) ? $this->MethodID : null;
    }
    /**
     * Set MethodID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $methodID
     * @return \StructType\PostDealConfirmationRequest
     */
    public function setMethodID($methodID = null)
    {
        // validation for constraint: string
        if (!is_null($methodID) && !is_string($methodID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($methodID)), __LINE__);
        }
        if (is_null($methodID) || (is_array($methodID) && empty($methodID))) {
            unset($this->MethodID);
        } else {
            $this->MethodID = $methodID;
        }
        return $this;
    }
    /**
     * Get OrgID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrgID()
    {
        return isset($this->OrgID) ? $this->OrgID : null;
    }
    /**
     * Set OrgID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $orgID
     * @return \StructType\PostDealConfirmationRequest
     */
    public function setOrgID($orgID = null)
    {
        // validation for constraint: string
        if (!is_null($orgID) && !is_string($orgID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($orgID)), __LINE__);
        }
        if (is_null($orgID) || (is_array($orgID) && empty($orgID))) {
            unset($this->OrgID);
        } else {
            $this->OrgID = $orgID;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PostDealConfirmationRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
