<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AccountList StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:AccountList
 * @subpackage Structs
 */
class AccountList extends AbstractStructBase
{
    /**
     * The AccountCurrencyID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AccountCurrencyID;
    /**
     * The AccountID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $AccountID;
    /**
     * The AccountNumber
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AccountNumber;
    /**
     * The BankName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $BankName;
    /**
     * The NameOnAccount
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $NameOnAccount;
    /**
     * The PaymentMethod
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PaymentMethod;
    /**
     * The Type
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Type;
    /**
     * Constructor method for AccountList
     * @uses AccountList::setAccountCurrencyID()
     * @uses AccountList::setAccountID()
     * @uses AccountList::setAccountNumber()
     * @uses AccountList::setBankName()
     * @uses AccountList::setNameOnAccount()
     * @uses AccountList::setPaymentMethod()
     * @uses AccountList::setType()
     * @param string $accountCurrencyID
     * @param int $accountID
     * @param string $accountNumber
     * @param string $bankName
     * @param string $nameOnAccount
     * @param string $paymentMethod
     * @param int $type
     */
    public function __construct($accountCurrencyID = null, $accountID = null, $accountNumber = null, $bankName = null, $nameOnAccount = null, $paymentMethod = null, $type = null)
    {
        $this
            ->setAccountCurrencyID($accountCurrencyID)
            ->setAccountID($accountID)
            ->setAccountNumber($accountNumber)
            ->setBankName($bankName)
            ->setNameOnAccount($nameOnAccount)
            ->setPaymentMethod($paymentMethod)
            ->setType($type);
    }
    /**
     * Get AccountCurrencyID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAccountCurrencyID()
    {
        return isset($this->AccountCurrencyID) ? $this->AccountCurrencyID : null;
    }
    /**
     * Set AccountCurrencyID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $accountCurrencyID
     * @return \StructType\AccountList
     */
    public function setAccountCurrencyID($accountCurrencyID = null)
    {
        // validation for constraint: string
        if (!is_null($accountCurrencyID) && !is_string($accountCurrencyID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($accountCurrencyID)), __LINE__);
        }
        if (is_null($accountCurrencyID) || (is_array($accountCurrencyID) && empty($accountCurrencyID))) {
            unset($this->AccountCurrencyID);
        } else {
            $this->AccountCurrencyID = $accountCurrencyID;
        }
        return $this;
    }
    /**
     * Get AccountID value
     * @return int|null
     */
    public function getAccountID()
    {
        return $this->AccountID;
    }
    /**
     * Set AccountID value
     * @param int $accountID
     * @return \StructType\AccountList
     */
    public function setAccountID($accountID = null)
    {
        // validation for constraint: int
        if (!is_null($accountID) && !is_numeric($accountID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($accountID)), __LINE__);
        }
        $this->AccountID = $accountID;
        return $this;
    }
    /**
     * Get AccountNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAccountNumber()
    {
        return isset($this->AccountNumber) ? $this->AccountNumber : null;
    }
    /**
     * Set AccountNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $accountNumber
     * @return \StructType\AccountList
     */
    public function setAccountNumber($accountNumber = null)
    {
        // validation for constraint: string
        if (!is_null($accountNumber) && !is_string($accountNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($accountNumber)), __LINE__);
        }
        if (is_null($accountNumber) || (is_array($accountNumber) && empty($accountNumber))) {
            unset($this->AccountNumber);
        } else {
            $this->AccountNumber = $accountNumber;
        }
        return $this;
    }
    /**
     * Get BankName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBankName()
    {
        return isset($this->BankName) ? $this->BankName : null;
    }
    /**
     * Set BankName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bankName
     * @return \StructType\AccountList
     */
    public function setBankName($bankName = null)
    {
        // validation for constraint: string
        if (!is_null($bankName) && !is_string($bankName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($bankName)), __LINE__);
        }
        if (is_null($bankName) || (is_array($bankName) && empty($bankName))) {
            unset($this->BankName);
        } else {
            $this->BankName = $bankName;
        }
        return $this;
    }
    /**
     * Get NameOnAccount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNameOnAccount()
    {
        return isset($this->NameOnAccount) ? $this->NameOnAccount : null;
    }
    /**
     * Set NameOnAccount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $nameOnAccount
     * @return \StructType\AccountList
     */
    public function setNameOnAccount($nameOnAccount = null)
    {
        // validation for constraint: string
        if (!is_null($nameOnAccount) && !is_string($nameOnAccount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($nameOnAccount)), __LINE__);
        }
        if (is_null($nameOnAccount) || (is_array($nameOnAccount) && empty($nameOnAccount))) {
            unset($this->NameOnAccount);
        } else {
            $this->NameOnAccount = $nameOnAccount;
        }
        return $this;
    }
    /**
     * Get PaymentMethod value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPaymentMethod()
    {
        return isset($this->PaymentMethod) ? $this->PaymentMethod : null;
    }
    /**
     * Set PaymentMethod value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $paymentMethod
     * @return \StructType\AccountList
     */
    public function setPaymentMethod($paymentMethod = null)
    {
        // validation for constraint: string
        if (!is_null($paymentMethod) && !is_string($paymentMethod)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($paymentMethod)), __LINE__);
        }
        if (is_null($paymentMethod) || (is_array($paymentMethod) && empty($paymentMethod))) {
            unset($this->PaymentMethod);
        } else {
            $this->PaymentMethod = $paymentMethod;
        }
        return $this;
    }
    /**
     * Get Type value
     * @return int|null
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @param int $type
     * @return \StructType\AccountList
     */
    public function setType($type = null)
    {
        // validation for constraint: int
        if (!is_null($type) && !is_numeric($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($type)), __LINE__);
        }
        $this->Type = $type;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AccountList
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
