<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PostDealResult_0_0_2 StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:PostDealResult_0_0_2
 * @subpackage Structs
 */
class PostDealResult_0_0_2 extends AbstractStructBase
{
    /**
     * The DealPostCallID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $DealPostCallID;
    /**
     * The Deals
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfDealDetails_0_0_2
     */
    public $Deals;
    /**
     * The ErrorCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ErrorCode;
    /**
     * The ErrorMessage
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ErrorMessage;
    /**
     * The NumberOfDeals
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $NumberOfDeals;
    /**
     * Constructor method for PostDealResult_0_0_2
     * @uses PostDealResult_0_0_2::setDealPostCallID()
     * @uses PostDealResult_0_0_2::setDeals()
     * @uses PostDealResult_0_0_2::setErrorCode()
     * @uses PostDealResult_0_0_2::setErrorMessage()
     * @uses PostDealResult_0_0_2::setNumberOfDeals()
     * @param int $dealPostCallID
     * @param \ArrayType\ArrayOfDealDetails_0_0_2 $deals
     * @param int $errorCode
     * @param string $errorMessage
     * @param int $numberOfDeals
     */
    public function __construct($dealPostCallID = null, \ArrayType\ArrayOfDealDetails_0_0_2 $deals = null, $errorCode = null, $errorMessage = null, $numberOfDeals = null)
    {
        $this
            ->setDealPostCallID($dealPostCallID)
            ->setDeals($deals)
            ->setErrorCode($errorCode)
            ->setErrorMessage($errorMessage)
            ->setNumberOfDeals($numberOfDeals);
    }
    /**
     * Get DealPostCallID value
     * @return int|null
     */
    public function getDealPostCallID()
    {
        return $this->DealPostCallID;
    }
    /**
     * Set DealPostCallID value
     * @param int $dealPostCallID
     * @return \StructType\PostDealResult_0_0_2
     */
    public function setDealPostCallID($dealPostCallID = null)
    {
        // validation for constraint: int
        if (!is_null($dealPostCallID) && !is_numeric($dealPostCallID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($dealPostCallID)), __LINE__);
        }
        $this->DealPostCallID = $dealPostCallID;
        return $this;
    }
    /**
     * Get Deals value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfDealDetails_0_0_2|null
     */
    public function getDeals()
    {
        return isset($this->Deals) ? $this->Deals : null;
    }
    /**
     * Set Deals value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfDealDetails_0_0_2 $deals
     * @return \StructType\PostDealResult_0_0_2
     */
    public function setDeals(\ArrayType\ArrayOfDealDetails_0_0_2 $deals = null)
    {
        if (is_null($deals) || (is_array($deals) && empty($deals))) {
            unset($this->Deals);
        } else {
            $this->Deals = $deals;
        }
        return $this;
    }
    /**
     * Get ErrorCode value
     * @return int|null
     */
    public function getErrorCode()
    {
        return $this->ErrorCode;
    }
    /**
     * Set ErrorCode value
     * @param int $errorCode
     * @return \StructType\PostDealResult_0_0_2
     */
    public function setErrorCode($errorCode = null)
    {
        // validation for constraint: int
        if (!is_null($errorCode) && !is_numeric($errorCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($errorCode)), __LINE__);
        }
        $this->ErrorCode = $errorCode;
        return $this;
    }
    /**
     * Get ErrorMessage value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getErrorMessage()
    {
        return isset($this->ErrorMessage) ? $this->ErrorMessage : null;
    }
    /**
     * Set ErrorMessage value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $errorMessage
     * @return \StructType\PostDealResult_0_0_2
     */
    public function setErrorMessage($errorMessage = null)
    {
        // validation for constraint: string
        if (!is_null($errorMessage) && !is_string($errorMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($errorMessage)), __LINE__);
        }
        if (is_null($errorMessage) || (is_array($errorMessage) && empty($errorMessage))) {
            unset($this->ErrorMessage);
        } else {
            $this->ErrorMessage = $errorMessage;
        }
        return $this;
    }
    /**
     * Get NumberOfDeals value
     * @return int|null
     */
    public function getNumberOfDeals()
    {
        return $this->NumberOfDeals;
    }
    /**
     * Set NumberOfDeals value
     * @param int $numberOfDeals
     * @return \StructType\PostDealResult_0_0_2
     */
    public function setNumberOfDeals($numberOfDeals = null)
    {
        // validation for constraint: int
        if (!is_null($numberOfDeals) && !is_numeric($numberOfDeals)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($numberOfDeals)), __LINE__);
        }
        $this->NumberOfDeals = $numberOfDeals;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PostDealResult_0_0_2
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
