<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Get ServiceType
 * @subpackage Services
 */
class Get extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named GetQuote
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetQuote $parameters
     * @return \StructType\GetQuoteResponse|bool
     */
    public function GetQuote(\StructType\GetQuote $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetQuote($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetAccountBalance
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetAccountBalance $parameters
     * @return \StructType\GetAccountBalanceResponse|bool
     */
    public function GetAccountBalance(\StructType\GetAccountBalance $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetAccountBalance($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetAccountBalance_0_0_1
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetAccountBalance_0_0_1 $parameters
     * @return \StructType\GetAccountBalance_0_0_1Response|bool
     */
    public function GetAccountBalance_0_0_1(\StructType\GetAccountBalance_0_0_1 $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetAccountBalance_0_0_1($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetFundingAccountList
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetFundingAccountList $parameters
     * @return \StructType\GetFundingAccountListResponse|bool
     */
    public function GetFundingAccountList(\StructType\GetFundingAccountList $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetFundingAccountList($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetPayeeInfo
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetPayeeInfo $parameters
     * @return \StructType\GetPayeeInfoResponse|bool
     */
    public function GetPayeeInfo(\StructType\GetPayeeInfo $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetPayeeInfo($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetAccountActivity
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetAccountActivity $parameters
     * @return \StructType\GetAccountActivityResponse|bool
     */
    public function GetAccountActivity(\StructType\GetAccountActivity $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetAccountActivity($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetQuoteTBA
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetQuoteTBA $parameters
     * @return \StructType\GetQuoteTBAResponse|bool
     */
    public function GetQuoteTBA(\StructType\GetQuoteTBA $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetQuoteTBA($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetIncomingPaymentInstruction
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetIncomingPaymentInstruction $parameters
     * @return \StructType\GetIncomingPaymentInstructionResponse|bool
     */
    public function GetIncomingPaymentInstruction(\StructType\GetIncomingPaymentInstruction $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetIncomingPaymentInstruction($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\GetAccountActivityResponse|\StructType\GetAccountBalanceResponse|\StructType\GetAccountBalance_0_0_1Response|\StructType\GetFundingAccountListResponse|\StructType\GetIncomingPaymentInstructionResponse|\StructType\GetPayeeInfoResponse|\StructType\GetQuoteResponse|\StructType\GetQuoteTBAResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
