<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfAccountList ArrayType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfAccountList
 * @subpackage Arrays
 */
class ArrayOfAccountList extends AbstractStructArrayBase
{
    /**
     * The AccountList
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\AccountList[]
     */
    public $AccountList;
    /**
     * Constructor method for ArrayOfAccountList
     * @uses ArrayOfAccountList::setAccountList()
     * @param \StructType\AccountList[] $accountList
     */
    public function __construct(array $accountList = array())
    {
        $this
            ->setAccountList($accountList);
    }
    /**
     * Get AccountList value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\AccountList[]|null
     */
    public function getAccountList()
    {
        return isset($this->AccountList) ? $this->AccountList : null;
    }
    /**
     * Set AccountList value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\AccountList[] $accountList
     * @return \ArrayType\ArrayOfAccountList
     */
    public function setAccountList(array $accountList = array())
    {
        foreach ($accountList as $arrayOfAccountListAccountListItem) {
            // validation for constraint: itemType
            if (!$arrayOfAccountListAccountListItem instanceof \StructType\AccountList) {
                throw new \InvalidArgumentException(sprintf('The AccountList property can only contain items of \StructType\AccountList, "%s" given', is_object($arrayOfAccountListAccountListItem) ? get_class($arrayOfAccountListAccountListItem) : gettype($arrayOfAccountListAccountListItem)), __LINE__);
            }
        }
        if (is_null($accountList) || (is_array($accountList) && empty($accountList))) {
            unset($this->AccountList);
        } else {
            $this->AccountList = $accountList;
        }
        return $this;
    }
    /**
     * Add item to AccountList value
     * @throws \InvalidArgumentException
     * @param \StructType\AccountList $item
     * @return \ArrayType\ArrayOfAccountList
     */
    public function addToAccountList(\StructType\AccountList $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\AccountList) {
            throw new \InvalidArgumentException(sprintf('The AccountList property can only contain items of \StructType\AccountList, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->AccountList[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\AccountList|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\AccountList|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\AccountList|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\AccountList|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\AccountList|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string AccountList
     */
    public function getAttributeName()
    {
        return 'AccountList';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfAccountList
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
