<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SubmitIncomingPayee StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:SubmitIncomingPayee
 * @subpackage Structs
 */
class SubmitIncomingPayee extends AbstractStructBase
{
    /**
     * The SenderAccountIBANNumber
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SenderAccountIBANNumber;
    /**
     * The SenderAddress1
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SenderAddress1;
    /**
     * The SenderAddress2
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SenderAddress2;
    /**
     * The SenderBankName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SenderBankName;
    /**
     * The SenderCity
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SenderCity;
    /**
     * The SenderCountryID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SenderCountryID;
    /**
     * The SenderID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $SenderID;
    /**
     * The SenderName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SenderName;
    /**
     * The SenderPostalCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SenderPostalCode;
    /**
     * The SenderProvince
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SenderProvince;
    /**
     * Constructor method for SubmitIncomingPayee
     * @uses SubmitIncomingPayee::setSenderAccountIBANNumber()
     * @uses SubmitIncomingPayee::setSenderAddress1()
     * @uses SubmitIncomingPayee::setSenderAddress2()
     * @uses SubmitIncomingPayee::setSenderBankName()
     * @uses SubmitIncomingPayee::setSenderCity()
     * @uses SubmitIncomingPayee::setSenderCountryID()
     * @uses SubmitIncomingPayee::setSenderID()
     * @uses SubmitIncomingPayee::setSenderName()
     * @uses SubmitIncomingPayee::setSenderPostalCode()
     * @uses SubmitIncomingPayee::setSenderProvince()
     * @param string $senderAccountIBANNumber
     * @param string $senderAddress1
     * @param string $senderAddress2
     * @param string $senderBankName
     * @param string $senderCity
     * @param string $senderCountryID
     * @param int $senderID
     * @param string $senderName
     * @param string $senderPostalCode
     * @param string $senderProvince
     */
    public function __construct($senderAccountIBANNumber = null, $senderAddress1 = null, $senderAddress2 = null, $senderBankName = null, $senderCity = null, $senderCountryID = null, $senderID = null, $senderName = null, $senderPostalCode = null, $senderProvince = null)
    {
        $this
            ->setSenderAccountIBANNumber($senderAccountIBANNumber)
            ->setSenderAddress1($senderAddress1)
            ->setSenderAddress2($senderAddress2)
            ->setSenderBankName($senderBankName)
            ->setSenderCity($senderCity)
            ->setSenderCountryID($senderCountryID)
            ->setSenderID($senderID)
            ->setSenderName($senderName)
            ->setSenderPostalCode($senderPostalCode)
            ->setSenderProvince($senderProvince);
    }
    /**
     * Get SenderAccountIBANNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSenderAccountIBANNumber()
    {
        return isset($this->SenderAccountIBANNumber) ? $this->SenderAccountIBANNumber : null;
    }
    /**
     * Set SenderAccountIBANNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $senderAccountIBANNumber
     * @return \StructType\SubmitIncomingPayee
     */
    public function setSenderAccountIBANNumber($senderAccountIBANNumber = null)
    {
        // validation for constraint: string
        if (!is_null($senderAccountIBANNumber) && !is_string($senderAccountIBANNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($senderAccountIBANNumber)), __LINE__);
        }
        if (is_null($senderAccountIBANNumber) || (is_array($senderAccountIBANNumber) && empty($senderAccountIBANNumber))) {
            unset($this->SenderAccountIBANNumber);
        } else {
            $this->SenderAccountIBANNumber = $senderAccountIBANNumber;
        }
        return $this;
    }
    /**
     * Get SenderAddress1 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSenderAddress1()
    {
        return isset($this->SenderAddress1) ? $this->SenderAddress1 : null;
    }
    /**
     * Set SenderAddress1 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $senderAddress1
     * @return \StructType\SubmitIncomingPayee
     */
    public function setSenderAddress1($senderAddress1 = null)
    {
        // validation for constraint: string
        if (!is_null($senderAddress1) && !is_string($senderAddress1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($senderAddress1)), __LINE__);
        }
        if (is_null($senderAddress1) || (is_array($senderAddress1) && empty($senderAddress1))) {
            unset($this->SenderAddress1);
        } else {
            $this->SenderAddress1 = $senderAddress1;
        }
        return $this;
    }
    /**
     * Get SenderAddress2 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSenderAddress2()
    {
        return isset($this->SenderAddress2) ? $this->SenderAddress2 : null;
    }
    /**
     * Set SenderAddress2 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $senderAddress2
     * @return \StructType\SubmitIncomingPayee
     */
    public function setSenderAddress2($senderAddress2 = null)
    {
        // validation for constraint: string
        if (!is_null($senderAddress2) && !is_string($senderAddress2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($senderAddress2)), __LINE__);
        }
        if (is_null($senderAddress2) || (is_array($senderAddress2) && empty($senderAddress2))) {
            unset($this->SenderAddress2);
        } else {
            $this->SenderAddress2 = $senderAddress2;
        }
        return $this;
    }
    /**
     * Get SenderBankName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSenderBankName()
    {
        return isset($this->SenderBankName) ? $this->SenderBankName : null;
    }
    /**
     * Set SenderBankName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $senderBankName
     * @return \StructType\SubmitIncomingPayee
     */
    public function setSenderBankName($senderBankName = null)
    {
        // validation for constraint: string
        if (!is_null($senderBankName) && !is_string($senderBankName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($senderBankName)), __LINE__);
        }
        if (is_null($senderBankName) || (is_array($senderBankName) && empty($senderBankName))) {
            unset($this->SenderBankName);
        } else {
            $this->SenderBankName = $senderBankName;
        }
        return $this;
    }
    /**
     * Get SenderCity value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSenderCity()
    {
        return isset($this->SenderCity) ? $this->SenderCity : null;
    }
    /**
     * Set SenderCity value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $senderCity
     * @return \StructType\SubmitIncomingPayee
     */
    public function setSenderCity($senderCity = null)
    {
        // validation for constraint: string
        if (!is_null($senderCity) && !is_string($senderCity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($senderCity)), __LINE__);
        }
        if (is_null($senderCity) || (is_array($senderCity) && empty($senderCity))) {
            unset($this->SenderCity);
        } else {
            $this->SenderCity = $senderCity;
        }
        return $this;
    }
    /**
     * Get SenderCountryID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSenderCountryID()
    {
        return isset($this->SenderCountryID) ? $this->SenderCountryID : null;
    }
    /**
     * Set SenderCountryID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $senderCountryID
     * @return \StructType\SubmitIncomingPayee
     */
    public function setSenderCountryID($senderCountryID = null)
    {
        // validation for constraint: string
        if (!is_null($senderCountryID) && !is_string($senderCountryID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($senderCountryID)), __LINE__);
        }
        if (is_null($senderCountryID) || (is_array($senderCountryID) && empty($senderCountryID))) {
            unset($this->SenderCountryID);
        } else {
            $this->SenderCountryID = $senderCountryID;
        }
        return $this;
    }
    /**
     * Get SenderID value
     * @return int|null
     */
    public function getSenderID()
    {
        return $this->SenderID;
    }
    /**
     * Set SenderID value
     * @param int $senderID
     * @return \StructType\SubmitIncomingPayee
     */
    public function setSenderID($senderID = null)
    {
        // validation for constraint: int
        if (!is_null($senderID) && !is_numeric($senderID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($senderID)), __LINE__);
        }
        $this->SenderID = $senderID;
        return $this;
    }
    /**
     * Get SenderName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSenderName()
    {
        return isset($this->SenderName) ? $this->SenderName : null;
    }
    /**
     * Set SenderName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $senderName
     * @return \StructType\SubmitIncomingPayee
     */
    public function setSenderName($senderName = null)
    {
        // validation for constraint: string
        if (!is_null($senderName) && !is_string($senderName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($senderName)), __LINE__);
        }
        if (is_null($senderName) || (is_array($senderName) && empty($senderName))) {
            unset($this->SenderName);
        } else {
            $this->SenderName = $senderName;
        }
        return $this;
    }
    /**
     * Get SenderPostalCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSenderPostalCode()
    {
        return isset($this->SenderPostalCode) ? $this->SenderPostalCode : null;
    }
    /**
     * Set SenderPostalCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $senderPostalCode
     * @return \StructType\SubmitIncomingPayee
     */
    public function setSenderPostalCode($senderPostalCode = null)
    {
        // validation for constraint: string
        if (!is_null($senderPostalCode) && !is_string($senderPostalCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($senderPostalCode)), __LINE__);
        }
        if (is_null($senderPostalCode) || (is_array($senderPostalCode) && empty($senderPostalCode))) {
            unset($this->SenderPostalCode);
        } else {
            $this->SenderPostalCode = $senderPostalCode;
        }
        return $this;
    }
    /**
     * Get SenderProvince value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSenderProvince()
    {
        return isset($this->SenderProvince) ? $this->SenderProvince : null;
    }
    /**
     * Set SenderProvince value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $senderProvince
     * @return \StructType\SubmitIncomingPayee
     */
    public function setSenderProvince($senderProvince = null)
    {
        // validation for constraint: string
        if (!is_null($senderProvince) && !is_string($senderProvince)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($senderProvince)), __LINE__);
        }
        if (is_null($senderProvince) || (is_array($senderProvince) && empty($senderProvince))) {
            unset($this->SenderProvince);
        } else {
            $this->SenderProvince = $senderProvince;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SubmitIncomingPayee
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
