<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetPayeeInfoResult StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:GetPayeeInfoResult
 * @subpackage Structs
 */
class GetPayeeInfoResult extends AbstractStructBase
{
    /**
     * The ErrorCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ErrorCode;
    /**
     * The ErrorMessage
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ErrorMessage;
    /**
     * The NumberOfPayees
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $NumberOfPayees;
    /**
     * The PayeeDetail
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfPayeeDetail
     */
    public $PayeeDetail;
    /**
     * Constructor method for GetPayeeInfoResult
     * @uses GetPayeeInfoResult::setErrorCode()
     * @uses GetPayeeInfoResult::setErrorMessage()
     * @uses GetPayeeInfoResult::setNumberOfPayees()
     * @uses GetPayeeInfoResult::setPayeeDetail()
     * @param int $errorCode
     * @param string $errorMessage
     * @param string $numberOfPayees
     * @param \ArrayType\ArrayOfPayeeDetail $payeeDetail
     */
    public function __construct($errorCode = null, $errorMessage = null, $numberOfPayees = null, \ArrayType\ArrayOfPayeeDetail $payeeDetail = null)
    {
        $this
            ->setErrorCode($errorCode)
            ->setErrorMessage($errorMessage)
            ->setNumberOfPayees($numberOfPayees)
            ->setPayeeDetail($payeeDetail);
    }
    /**
     * Get ErrorCode value
     * @return int|null
     */
    public function getErrorCode()
    {
        return $this->ErrorCode;
    }
    /**
     * Set ErrorCode value
     * @param int $errorCode
     * @return \StructType\GetPayeeInfoResult
     */
    public function setErrorCode($errorCode = null)
    {
        // validation for constraint: int
        if (!is_null($errorCode) && !is_numeric($errorCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($errorCode)), __LINE__);
        }
        $this->ErrorCode = $errorCode;
        return $this;
    }
    /**
     * Get ErrorMessage value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getErrorMessage()
    {
        return isset($this->ErrorMessage) ? $this->ErrorMessage : null;
    }
    /**
     * Set ErrorMessage value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $errorMessage
     * @return \StructType\GetPayeeInfoResult
     */
    public function setErrorMessage($errorMessage = null)
    {
        // validation for constraint: string
        if (!is_null($errorMessage) && !is_string($errorMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($errorMessage)), __LINE__);
        }
        if (is_null($errorMessage) || (is_array($errorMessage) && empty($errorMessage))) {
            unset($this->ErrorMessage);
        } else {
            $this->ErrorMessage = $errorMessage;
        }
        return $this;
    }
    /**
     * Get NumberOfPayees value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNumberOfPayees()
    {
        return isset($this->NumberOfPayees) ? $this->NumberOfPayees : null;
    }
    /**
     * Set NumberOfPayees value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $numberOfPayees
     * @return \StructType\GetPayeeInfoResult
     */
    public function setNumberOfPayees($numberOfPayees = null)
    {
        // validation for constraint: string
        if (!is_null($numberOfPayees) && !is_string($numberOfPayees)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($numberOfPayees)), __LINE__);
        }
        if (is_null($numberOfPayees) || (is_array($numberOfPayees) && empty($numberOfPayees))) {
            unset($this->NumberOfPayees);
        } else {
            $this->NumberOfPayees = $numberOfPayees;
        }
        return $this;
    }
    /**
     * Get PayeeDetail value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfPayeeDetail|null
     */
    public function getPayeeDetail()
    {
        return isset($this->PayeeDetail) ? $this->PayeeDetail : null;
    }
    /**
     * Set PayeeDetail value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfPayeeDetail $payeeDetail
     * @return \StructType\GetPayeeInfoResult
     */
    public function setPayeeDetail(\ArrayType\ArrayOfPayeeDetail $payeeDetail = null)
    {
        if (is_null($payeeDetail) || (is_array($payeeDetail) && empty($payeeDetail))) {
            unset($this->PayeeDetail);
        } else {
            $this->PayeeDetail = $payeeDetail;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetPayeeInfoResult
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
