<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetAccountActivityResult StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:GetAccountActivityResult
 * @subpackage Structs
 */
class GetAccountActivityResult extends AbstractStructBase
{
    /**
     * The AccountNumber
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AccountNumber;
    /**
     * The ClosingBalance
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $ClosingBalance;
    /**
     * The ErrorCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ErrorCode;
    /**
     * The ErrorMessage
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ErrorMessage;
    /**
     * The Factor
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Factor;
    /**
     * The Month
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Month;
    /**
     * The NumberOfTransaction
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $NumberOfTransaction;
    /**
     * The OpeningBalance
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $OpeningBalance;
    /**
     * The Transaction
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfTransactionDetails
     */
    public $Transaction;
    /**
     * The Year
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Year;
    /**
     * Constructor method for GetAccountActivityResult
     * @uses GetAccountActivityResult::setAccountNumber()
     * @uses GetAccountActivityResult::setClosingBalance()
     * @uses GetAccountActivityResult::setErrorCode()
     * @uses GetAccountActivityResult::setErrorMessage()
     * @uses GetAccountActivityResult::setFactor()
     * @uses GetAccountActivityResult::setMonth()
     * @uses GetAccountActivityResult::setNumberOfTransaction()
     * @uses GetAccountActivityResult::setOpeningBalance()
     * @uses GetAccountActivityResult::setTransaction()
     * @uses GetAccountActivityResult::setYear()
     * @param string $accountNumber
     * @param float $closingBalance
     * @param int $errorCode
     * @param string $errorMessage
     * @param int $factor
     * @param int $month
     * @param int $numberOfTransaction
     * @param float $openingBalance
     * @param \ArrayType\ArrayOfTransactionDetails $transaction
     * @param int $year
     */
    public function __construct($accountNumber = null, $closingBalance = null, $errorCode = null, $errorMessage = null, $factor = null, $month = null, $numberOfTransaction = null, $openingBalance = null, \ArrayType\ArrayOfTransactionDetails $transaction = null, $year = null)
    {
        $this
            ->setAccountNumber($accountNumber)
            ->setClosingBalance($closingBalance)
            ->setErrorCode($errorCode)
            ->setErrorMessage($errorMessage)
            ->setFactor($factor)
            ->setMonth($month)
            ->setNumberOfTransaction($numberOfTransaction)
            ->setOpeningBalance($openingBalance)
            ->setTransaction($transaction)
            ->setYear($year);
    }
    /**
     * Get AccountNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAccountNumber()
    {
        return isset($this->AccountNumber) ? $this->AccountNumber : null;
    }
    /**
     * Set AccountNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $accountNumber
     * @return \StructType\GetAccountActivityResult
     */
    public function setAccountNumber($accountNumber = null)
    {
        // validation for constraint: string
        if (!is_null($accountNumber) && !is_string($accountNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($accountNumber)), __LINE__);
        }
        if (is_null($accountNumber) || (is_array($accountNumber) && empty($accountNumber))) {
            unset($this->AccountNumber);
        } else {
            $this->AccountNumber = $accountNumber;
        }
        return $this;
    }
    /**
     * Get ClosingBalance value
     * @return float|null
     */
    public function getClosingBalance()
    {
        return $this->ClosingBalance;
    }
    /**
     * Set ClosingBalance value
     * @param float $closingBalance
     * @return \StructType\GetAccountActivityResult
     */
    public function setClosingBalance($closingBalance = null)
    {
        $this->ClosingBalance = $closingBalance;
        return $this;
    }
    /**
     * Get ErrorCode value
     * @return int|null
     */
    public function getErrorCode()
    {
        return $this->ErrorCode;
    }
    /**
     * Set ErrorCode value
     * @param int $errorCode
     * @return \StructType\GetAccountActivityResult
     */
    public function setErrorCode($errorCode = null)
    {
        // validation for constraint: int
        if (!is_null($errorCode) && !is_numeric($errorCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($errorCode)), __LINE__);
        }
        $this->ErrorCode = $errorCode;
        return $this;
    }
    /**
     * Get ErrorMessage value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getErrorMessage()
    {
        return isset($this->ErrorMessage) ? $this->ErrorMessage : null;
    }
    /**
     * Set ErrorMessage value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $errorMessage
     * @return \StructType\GetAccountActivityResult
     */
    public function setErrorMessage($errorMessage = null)
    {
        // validation for constraint: string
        if (!is_null($errorMessage) && !is_string($errorMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($errorMessage)), __LINE__);
        }
        if (is_null($errorMessage) || (is_array($errorMessage) && empty($errorMessage))) {
            unset($this->ErrorMessage);
        } else {
            $this->ErrorMessage = $errorMessage;
        }
        return $this;
    }
    /**
     * Get Factor value
     * @return int|null
     */
    public function getFactor()
    {
        return $this->Factor;
    }
    /**
     * Set Factor value
     * @param int $factor
     * @return \StructType\GetAccountActivityResult
     */
    public function setFactor($factor = null)
    {
        // validation for constraint: int
        if (!is_null($factor) && !is_numeric($factor)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($factor)), __LINE__);
        }
        $this->Factor = $factor;
        return $this;
    }
    /**
     * Get Month value
     * @return int|null
     */
    public function getMonth()
    {
        return $this->Month;
    }
    /**
     * Set Month value
     * @param int $month
     * @return \StructType\GetAccountActivityResult
     */
    public function setMonth($month = null)
    {
        // validation for constraint: int
        if (!is_null($month) && !is_numeric($month)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($month)), __LINE__);
        }
        $this->Month = $month;
        return $this;
    }
    /**
     * Get NumberOfTransaction value
     * @return int|null
     */
    public function getNumberOfTransaction()
    {
        return $this->NumberOfTransaction;
    }
    /**
     * Set NumberOfTransaction value
     * @param int $numberOfTransaction
     * @return \StructType\GetAccountActivityResult
     */
    public function setNumberOfTransaction($numberOfTransaction = null)
    {
        // validation for constraint: int
        if (!is_null($numberOfTransaction) && !is_numeric($numberOfTransaction)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($numberOfTransaction)), __LINE__);
        }
        $this->NumberOfTransaction = $numberOfTransaction;
        return $this;
    }
    /**
     * Get OpeningBalance value
     * @return float|null
     */
    public function getOpeningBalance()
    {
        return $this->OpeningBalance;
    }
    /**
     * Set OpeningBalance value
     * @param float $openingBalance
     * @return \StructType\GetAccountActivityResult
     */
    public function setOpeningBalance($openingBalance = null)
    {
        $this->OpeningBalance = $openingBalance;
        return $this;
    }
    /**
     * Get Transaction value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfTransactionDetails|null
     */
    public function getTransaction()
    {
        return isset($this->Transaction) ? $this->Transaction : null;
    }
    /**
     * Set Transaction value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfTransactionDetails $transaction
     * @return \StructType\GetAccountActivityResult
     */
    public function setTransaction(\ArrayType\ArrayOfTransactionDetails $transaction = null)
    {
        if (is_null($transaction) || (is_array($transaction) && empty($transaction))) {
            unset($this->Transaction);
        } else {
            $this->Transaction = $transaction;
        }
        return $this;
    }
    /**
     * Get Year value
     * @return int|null
     */
    public function getYear()
    {
        return $this->Year;
    }
    /**
     * Set Year value
     * @param int $year
     * @return \StructType\GetAccountActivityResult
     */
    public function setYear($year = null)
    {
        // validation for constraint: int
        if (!is_null($year) && !is_numeric($year)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($year)), __LINE__);
        }
        $this->Year = $year;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetAccountActivityResult
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
