<?php

namespace EnumType;

/**
 * This class stands for Direction EnumType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:Direction
 * @subpackage Enumerations
 */
class Direction
{
    /**
     * Constant for value 'Buy'
     * @return string 'Buy'
     */
    const VALUE_BUY = 'Buy';
    /**
     * Constant for value 'Sell'
     * @return string 'Sell'
     */
    const VALUE_SELL = 'Sell';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_BUY
     * @uses self::VALUE_SELL
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_BUY,
            self::VALUE_SELL,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
