<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SubmitIncomingDealRequest StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:SubmitIncomingDealRequest
 * @subpackage Structs
 */
class SubmitIncomingDealRequest extends AbstractStructBase
{
    /**
     * The MethodID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $MethodID;
    /**
     * The OrgID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OrgID;
    /**
     * The PaymentDetail
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfSubmitIncomingDealDetail
     */
    public $PaymentDetail;
    /**
     * The QuoteID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $QuoteID;
    /**
     * The TotalNumberOfPayment
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $TotalNumberOfPayment;
    /**
     * Constructor method for SubmitIncomingDealRequest
     * @uses SubmitIncomingDealRequest::setMethodID()
     * @uses SubmitIncomingDealRequest::setOrgID()
     * @uses SubmitIncomingDealRequest::setPaymentDetail()
     * @uses SubmitIncomingDealRequest::setQuoteID()
     * @uses SubmitIncomingDealRequest::setTotalNumberOfPayment()
     * @param string $methodID
     * @param string $orgID
     * @param \ArrayType\ArrayOfSubmitIncomingDealDetail $paymentDetail
     * @param int $quoteID
     * @param int $totalNumberOfPayment
     */
    public function __construct($methodID = null, $orgID = null, \ArrayType\ArrayOfSubmitIncomingDealDetail $paymentDetail = null, $quoteID = null, $totalNumberOfPayment = null)
    {
        $this
            ->setMethodID($methodID)
            ->setOrgID($orgID)
            ->setPaymentDetail($paymentDetail)
            ->setQuoteID($quoteID)
            ->setTotalNumberOfPayment($totalNumberOfPayment);
    }
    /**
     * Get MethodID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMethodID()
    {
        return isset($this->MethodID) ? $this->MethodID : null;
    }
    /**
     * Set MethodID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $methodID
     * @return \StructType\SubmitIncomingDealRequest
     */
    public function setMethodID($methodID = null)
    {
        // validation for constraint: string
        if (!is_null($methodID) && !is_string($methodID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($methodID)), __LINE__);
        }
        if (is_null($methodID) || (is_array($methodID) && empty($methodID))) {
            unset($this->MethodID);
        } else {
            $this->MethodID = $methodID;
        }
        return $this;
    }
    /**
     * Get OrgID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrgID()
    {
        return isset($this->OrgID) ? $this->OrgID : null;
    }
    /**
     * Set OrgID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $orgID
     * @return \StructType\SubmitIncomingDealRequest
     */
    public function setOrgID($orgID = null)
    {
        // validation for constraint: string
        if (!is_null($orgID) && !is_string($orgID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($orgID)), __LINE__);
        }
        if (is_null($orgID) || (is_array($orgID) && empty($orgID))) {
            unset($this->OrgID);
        } else {
            $this->OrgID = $orgID;
        }
        return $this;
    }
    /**
     * Get PaymentDetail value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfSubmitIncomingDealDetail|null
     */
    public function getPaymentDetail()
    {
        return isset($this->PaymentDetail) ? $this->PaymentDetail : null;
    }
    /**
     * Set PaymentDetail value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfSubmitIncomingDealDetail $paymentDetail
     * @return \StructType\SubmitIncomingDealRequest
     */
    public function setPaymentDetail(\ArrayType\ArrayOfSubmitIncomingDealDetail $paymentDetail = null)
    {
        if (is_null($paymentDetail) || (is_array($paymentDetail) && empty($paymentDetail))) {
            unset($this->PaymentDetail);
        } else {
            $this->PaymentDetail = $paymentDetail;
        }
        return $this;
    }
    /**
     * Get QuoteID value
     * @return int|null
     */
    public function getQuoteID()
    {
        return $this->QuoteID;
    }
    /**
     * Set QuoteID value
     * @param int $quoteID
     * @return \StructType\SubmitIncomingDealRequest
     */
    public function setQuoteID($quoteID = null)
    {
        // validation for constraint: int
        if (!is_null($quoteID) && !is_numeric($quoteID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($quoteID)), __LINE__);
        }
        $this->QuoteID = $quoteID;
        return $this;
    }
    /**
     * Get TotalNumberOfPayment value
     * @return int|null
     */
    public function getTotalNumberOfPayment()
    {
        return $this->TotalNumberOfPayment;
    }
    /**
     * Set TotalNumberOfPayment value
     * @param int $totalNumberOfPayment
     * @return \StructType\SubmitIncomingDealRequest
     */
    public function setTotalNumberOfPayment($totalNumberOfPayment = null)
    {
        // validation for constraint: int
        if (!is_null($totalNumberOfPayment) && !is_numeric($totalNumberOfPayment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($totalNumberOfPayment)), __LINE__);
        }
        $this->TotalNumberOfPayment = $totalNumberOfPayment;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SubmitIncomingDealRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
