<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfTransactionDetails ArrayType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfTransactionDetails
 * @subpackage Arrays
 */
class ArrayOfTransactionDetails extends AbstractStructArrayBase
{
    /**
     * The TransactionDetails
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\TransactionDetails[]
     */
    public $TransactionDetails;
    /**
     * Constructor method for ArrayOfTransactionDetails
     * @uses ArrayOfTransactionDetails::setTransactionDetails()
     * @param \StructType\TransactionDetails[] $transactionDetails
     */
    public function __construct(array $transactionDetails = array())
    {
        $this
            ->setTransactionDetails($transactionDetails);
    }
    /**
     * Get TransactionDetails value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\TransactionDetails[]|null
     */
    public function getTransactionDetails()
    {
        return isset($this->TransactionDetails) ? $this->TransactionDetails : null;
    }
    /**
     * Set TransactionDetails value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\TransactionDetails[] $transactionDetails
     * @return \ArrayType\ArrayOfTransactionDetails
     */
    public function setTransactionDetails(array $transactionDetails = array())
    {
        foreach ($transactionDetails as $arrayOfTransactionDetailsTransactionDetailsItem) {
            // validation for constraint: itemType
            if (!$arrayOfTransactionDetailsTransactionDetailsItem instanceof \StructType\TransactionDetails) {
                throw new \InvalidArgumentException(sprintf('The TransactionDetails property can only contain items of \StructType\TransactionDetails, "%s" given', is_object($arrayOfTransactionDetailsTransactionDetailsItem) ? get_class($arrayOfTransactionDetailsTransactionDetailsItem) : gettype($arrayOfTransactionDetailsTransactionDetailsItem)), __LINE__);
            }
        }
        if (is_null($transactionDetails) || (is_array($transactionDetails) && empty($transactionDetails))) {
            unset($this->TransactionDetails);
        } else {
            $this->TransactionDetails = $transactionDetails;
        }
        return $this;
    }
    /**
     * Add item to TransactionDetails value
     * @throws \InvalidArgumentException
     * @param \StructType\TransactionDetails $item
     * @return \ArrayType\ArrayOfTransactionDetails
     */
    public function addToTransactionDetails(\StructType\TransactionDetails $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\TransactionDetails) {
            throw new \InvalidArgumentException(sprintf('The TransactionDetails property can only contain items of \StructType\TransactionDetails, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->TransactionDetails[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\TransactionDetails|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\TransactionDetails|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\TransactionDetails|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\TransactionDetails|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\TransactionDetails|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string TransactionDetails
     */
    public function getAttributeName()
    {
        return 'TransactionDetails';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfTransactionDetails
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
